/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.util;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectInvalidInputException;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectParseException;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.SWTResourceManager;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.parsers.path.ApiPathParser;
import com.ibm.zosconnect.ui.parsers.path.BasePathParser;
import com.ibm.zosconnect.ui.parsers.path.EnvPromotionVariable;
import com.ibm.zosconnect.ui.parsers.path.PathParameter;
import com.ibm.zosconnect.ui.parsers.path.PathToken;
import com.ibm.zosconnect.ui.parsers.path.QueryParameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class PathValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void validateRelativePathUri(String relativePath, List<PathToken> tokens, StyledText txtApiRelPath) throws ZosConnectInvalidInputException {
        String testPath = relativePath;
        for (PathToken token : tokens) {
            if (!(token instanceof QueryParameter) && !(token instanceof PathParameter)) continue;
            testPath = testPath.replace(token.text, "x");
        }
        UrlValidator validator = new UrlValidator();
        String dummyPrefix = "http://www.ibm.com";
        if (!StringUtils.startsWith((CharSequence)testPath, (CharSequence)"/")) {
            throw new ZosConnectInvalidInputException(Xlat.error((String)"API_PATH_MUST_START_WITH_FORWARD_SLASH_ERROR"));
        }
        if (!validator.isValid(dummyPrefix + testPath)) {
            StyleRange style = new StyleRange();
            style.start = 0;
            style.length = relativePath.length();
            style.foreground = SWTResourceManager.getColor((int)3);
            txtApiRelPath.setStyleRange(style);
            throw new ZosConnectInvalidInputException(Xlat.error((String)"INVALID_API_PATH_ERROR"));
        }
        txtApiRelPath.setForeground(SWTResourceManager.getColor((int)2));
    }

    public static void validateHighlightApiPathSyntax(StyledText txtApiRelPath, boolean validate, boolean highlight) throws ZosConnectInvalidInputException {
        String pathText = XSwt.getText((StyledText)txtApiRelPath);
        List<PathToken> tokens = null;
        List<ZosConnectParseException> errors = null;
        try {
            ApiPathParser parser = new ApiPathParser();
            parser.parse(pathText);
            tokens = parser.getTokens();
            errors = parser.getErrors();
            if (highlight) {
                ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
                for (PathToken token : tokens) {
                    StyleRange style = new StyleRange();
                    style.start = token.offset;
                    style.length = token.length;
                    style.foreground = ApiPathParser.getPathTokenColor(token);
                    style.fontStyle = 1;
                    styleRanges.add(style);
                }
                if (!styleRanges.isEmpty()) {
                    try {
                        txtApiRelPath.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (validate) {
                PathValidator.validateRelativePathUri(pathText, tokens, txtApiRelPath);
                ZosConnectParseException firstError = (ZosConnectParseException)((Object)ListUtilz.getFirstMember(errors));
                if (firstError != null) {
                    throw firstError;
                }
            }
        }
        catch (ZosConnectParseException e) {
            StyleRange style = new StyleRange();
            style.start = e.getErrorOffset();
            style.length = pathText.length() - style.start;
            style.foreground = SWTResourceManager.getColor((int)3);
            txtApiRelPath.setStyleRange(style);
            throw new ZosConnectInvalidInputException(e.getMessage());
        }
    }

    public static void validateBasePathUri(String basePath, List<PathToken> tokens, StyledText txtApiBasePath) throws ZosConnectInvalidInputException {
        String testPath = basePath;
        for (PathToken token : tokens) {
            if (!(token instanceof EnvPromotionVariable)) continue;
            testPath = testPath.replace(token.text, "x");
        }
        if (testPath.charAt(0) == ' ') {
            throw new ZosConnectInvalidInputException(Xlat.error((String)"INVALID_BASEPATH_ERROR_SPACE"));
        }
        UrlValidator validator = new UrlValidator();
        String dummyPrefix = "http://www.ibm.com";
        if (!validator.isValid(dummyPrefix + testPath) || testPath.equals("/")) {
            StyleRange style = new StyleRange();
            style.start = 0;
            style.length = basePath.length();
            style.foreground = SWTResourceManager.getColor((int)3);
            txtApiBasePath.setStyleRange(style);
            throw new ZosConnectInvalidInputException(Xlat.error((String)"INVALID_BASEPATH_ERROR"));
        }
        txtApiBasePath.setForeground(SWTResourceManager.getColor((int)2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateHighlightBasePathSyntax(StyledText txtApiBasePath) throws ZosConnectInvalidInputException {
        String pathText = XSwt.getText((StyledText)txtApiBasePath);
        if (pathText == null || pathText.isEmpty()) throw new ZosConnectInvalidInputException(Xlat.error((String)"INVALID_BASEPATH_ERROR"));
        try {
            List<PathToken> tokens = BasePathParser.parse(pathText);
            PathValidator.validateBasePathUri(pathText, tokens, txtApiBasePath);
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            for (PathToken token : tokens) {
                StyleRange style = new StyleRange();
                style.start = token.offset;
                style.length = token.length;
                style.foreground = BasePathParser.getPathTokenColor(token);
                style.fontStyle = 1;
                styleRanges.add(style);
            }
            if (styleRanges.isEmpty()) return;
            txtApiBasePath.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            return;
        }
        catch (ZosConnectParseException e) {
            StyleRange style = new StyleRange();
            style.start = e.getErrorOffset();
            style.length = pathText.length() - style.start;
            style.foreground = SWTResourceManager.getColor((int)3);
            txtApiBasePath.setStyleRange(style);
            throw new ZosConnectInvalidInputException(e.getMessage());
        }
    }

    public static void validateHighlightContactUrl(StyledText txtUrl) throws ZosConnectInvalidInputException {
        String urlText = XSwt.getText((StyledText)txtUrl);
        if (urlText != null && !urlText.isEmpty()) {
            UrlValidator validator = new UrlValidator(8L);
            if (!validator.isValid(urlText)) {
                StyleRange style = new StyleRange();
                style.start = 0;
                style.length = urlText.length();
                style.foreground = SWTResourceManager.getColor((int)3);
                txtUrl.setStyleRange(style);
                throw new ZosConnectInvalidInputException(Xlat.error((String)"INVALID_CONTACT_URL"));
            }
            StyleRange style = new StyleRange();
            style.start = 0;
            style.length = urlText.length();
            style.foreground = SWTResourceManager.getColor((int)2);
            txtUrl.setStyleRange(style);
        }
    }
}

