/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.util;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AdminApiConnectionUIUtil {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CATEGORY_ID = "com.ibm.zosconnect.ui.connections.category.adminapi";
    public static final String CONNECTION_ID = "com.ibm.zosconnect.ui.connections.type.adminapi";
    private static IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private static IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();

    public static boolean apisRefSameCredential(List<ZosConnectApiNode> apis) {
        if (ListUtilz.isEmpty(apis)) {
            return false;
        }
        ArrayList<ZosConnectServerNode> servers = new ArrayList<ZosConnectServerNode>();
        for (ZosConnectApiNode api : apis) {
            servers.add(api.getServerNode());
        }
        return AdminApiConnectionUIUtil.serversRefSameCredential(servers);
    }

    public static boolean servicesRefSameCredential(List<ZosConnectServiceNode> services) {
        if (ListUtilz.isEmpty(services)) {
            return false;
        }
        ArrayList<ZosConnectServerNode> servers = new ArrayList<ZosConnectServerNode>();
        for (ZosConnectServiceNode service : services) {
            servers.add(service.getServerNode());
        }
        return AdminApiConnectionUIUtil.serversRefSameCredential(servers);
    }

    public static boolean serversRefSameCredential(List<ZosConnectServerNode> servers) {
        if (ListUtilz.isEmpty(servers)) {
            return false;
        }
        ZosConnectServerNode firstServer = (ZosConnectServerNode)ListUtilz.getFirstMember(servers);
        ConnectionProfile firstConnProfile = firstServer.getConnectionProfile();
        if (firstConnProfile == null) {
            return false;
        }
        CredentialsConfiguration firstCredConfig = firstConnProfile.getCredentials();
        if (firstCredConfig == null) {
            return false;
        }
        int serverIdx = 1;
        while (serverIdx < servers.size()) {
            CredentialsConfiguration nextCredConfig;
            ZosConnectServerNode nextServer = servers.get(serverIdx);
            ConnectionProfile nextConnProfile = nextServer.getConnectionProfile();
            if (nextConnProfile != null && (nextCredConfig = nextConnProfile.getCredentials()) != null && StringUtils.equals((CharSequence)firstCredConfig.getID(), (CharSequence)nextCredConfig.getID())) {
                return true;
            }
            ++serverIdx;
        }
        return false;
    }
}

