/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.property.testers;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ApiOrPackagePropertyTester
extends PropertyTester {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            if (!"isApiOrPackage".equals(property) || !(receiver instanceof List)) return false;
            List receivers = (List)receiver;
            ArrayList<IProject> projects = new ArrayList<IProject>();
            ArrayList<IFile> files = new ArrayList<IFile>();
            for (Object currReceiver : receivers) {
                if (currReceiver instanceof IProject) {
                    IProject currProject = (IProject)currReceiver;
                    projects.add(currProject);
                    continue;
                }
                if (!(currReceiver instanceof IFile)) continue;
                IFile currFile = (IFile)currReceiver;
                IProject currProject = currFile.getProject();
                projects.add(currProject);
                if (!this.isApiProject(currProject)) continue;
                files.add(currFile);
            }
            if (projects.isEmpty() && files.isEmpty()) {
                return false;
            }
            for (IProject currProject : projects) {
                if (this.isApiProject(currProject)) continue;
                return false;
            }
            for (IFile currFile : files) {
                if ("package.xml".equals(currFile.getName())) continue;
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return false;
    }

    private boolean isApiProject(IProject proj) throws CoreException {
        if (proj != null && proj.isOpen()) {
            String[] stringArray = proj.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String currNature = stringArray[n2];
                if ("com.ibm.zosconnect.ui.projects.ZosConnectApiProjectNature".equals(currNature)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

