/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.problems.model;

import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.problems.model.ProblemsNode;
import com.ibm.zosconnect.ui.problems.model.ProblemsType;
import com.ibm.zosconnect.ui.util.Images;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProblemsLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Image getColumnImage(Object element, int columnIndex) {
        Image retVal = null;
        if (element instanceof ProblemsType && columnIndex == 0) {
            ProblemsType.ProbType type = ((ProblemsType)element).probType;
            if (type == ProblemsType.ProbType.ERRORS) {
                retVal = Images.getErrorWarningImage();
            } else if (type == ProblemsType.ProbType.WARNINGS) {
                retVal = Images.getMappingWarningImage();
            } else if (type == ProblemsType.ProbType.INFO) {
                retVal = Images.getMappingInfoImage();
            }
        }
        return retVal;
    }

    public String getColumnText(Object element, int columnIndex) {
        String retVal = null;
        if (element instanceof ProblemsType) {
            if (columnIndex == 0) {
                retVal = ((ProblemsType)element).getName();
            }
        } else if (element instanceof ProblemsNode) {
            MappingValidationProblem2 msg = ((ProblemsNode)element).getMsg();
            if (columnIndex == 0) {
                retVal = msg.getMessage();
            } else if (columnIndex == 1) {
                retVal = msg.getFileTypeString();
            } else if (columnIndex == 2) {
                retVal = msg.getPath();
            } else if (columnIndex == 3) {
                retVal = msg.getMethod();
            } else if (columnIndex == 4) {
                retVal = msg.getOperationId();
            } else if (columnIndex == 5) {
                retVal = msg.getService();
            } else if (columnIndex == 6) {
                retVal = msg.getType().toStringXlat();
            }
        }
        return retVal;
    }
}

