/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.perspective;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ZosConnectPerspective
implements IPerspectiveFactory {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger;
    public static final String ZOS_CONNECT_PERSPECTIVE_ID = "com.ibm.zosconnect.ui.perspective.ZosConnectPerspective";
    private static final String LEFT_TOP = "top_left";
    private static final String RIGHT_TOP = "top_right";
    private static final String LEFT_BOT = "bottom_left";
    private static final String BOTTOM = "bottom";

    public ZosConnectPerspective() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void createInitialLayout(IPageLayout layout) {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "createInitialLayout(IPageLayout layout)");
            }
            String editorArea = layout.getEditorArea();
            IFolderLayout lefttop = layout.createFolder(LEFT_TOP, 1, 0.25f, editorArea);
            IFolderLayout leftbot = layout.createFolder(LEFT_BOT, 4, 0.5f, LEFT_TOP);
            IFolderLayout bottom = layout.createFolder(BOTTOM, 4, 0.7f, editorArea);
            lefttop.addView("org.eclipse.ui.navigator.ProjectExplorer");
            leftbot.addView("com.ibm.zosconnect.ui.nav.ZosConnectServerNav");
            leftbot.addView("org.eclipse.rse.ui.view.systemView");
            bottom.addView("com.ibm.cics.explorer.connections_view");
            bottom.addView("org.eclipse.ui.views.PropertySheet");
            bottom.addView("org.eclipse.ui.views.ProgressView");
            bottom.addView("org.eclipse.ui.views.ProblemView");
            layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
            layout.addShowViewShortcut("com.ibm.cics.explorer.connections_view");
            layout.addShowViewShortcut("com.ibm.zosconnect.ui.nav.ZosConnectServerNav");
            layout.addShowViewShortcut("org.eclipse.rse.ui.view.systemView");
            layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
            layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
            layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
            layout.addNewWizardShortcut("com.ibm.zosconnect.ui.wizards.NewApiProjectWizard");
            layout.addNewWizardShortcut("com.ibm.zosconnect.ui.service.wizards.NewServiceProjectWizard");
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "createInitialLayout(IPageLayout layout)");
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "createInitialLayout(IPageLayout layout)", e);
        }
    }

    public static boolean isActive() {
        boolean active = false;
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IPerspectiveDescriptor perspective = page.getPerspective();
            active = StringUtils.equals((CharSequence)ZOS_CONNECT_PERSPECTIVE_ID, (CharSequence)perspective.getId());
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return active;
    }
}

