/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.parsers.path;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectInvalidInputException;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectParseException;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.parsers.path.AbstractPathParser;
import com.ibm.zosconnect.ui.parsers.path.EnvPromotionVariable;
import com.ibm.zosconnect.ui.parsers.path.PathSeparatorToken;
import com.ibm.zosconnect.ui.parsers.path.PathToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasePathParser
extends AbstractPathParser {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private BasePathParser() {
    }

    public static List<PathToken> parse(String path) throws ZosConnectParseException, ZosConnectInvalidInputException {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PathToken> tokens = new ArrayList<PathToken>();
        boolean inEnvPromotionVariable = false;
        boolean insideCurlyBraces = false;
        PathToken currToken = new PathToken();
        int pathOffset = 0;
        while (pathOffset < path.length()) {
            char ch = path.charAt(pathOffset);
            switch (ch) {
                case '/': {
                    inEnvPromotionVariable = false;
                    PathSeparatorToken pathSepToken = new PathSeparatorToken();
                    pathSepToken.offset = pathOffset;
                    pathSepToken.length = 1;
                    pathSepToken.text = String.valueOf(ch);
                    tokens.add(pathSepToken);
                    if (pathOffset != path.length() - 1) break;
                    throw new ZosConnectInvalidInputException(Xlat.error((String)"INVALID_BASEPATH_ERROR_TRAILING_SLASH"));
                }
                case '$': {
                    inEnvPromotionVariable = true;
                    currToken = new EnvPromotionVariable();
                    currToken.offset = pathOffset;
                    break;
                }
                case '{': {
                    if (!inEnvPromotionVariable) {
                        throw new ZosConnectParseException(Xlat.error((String)"INVALID_ENV_PROMOTION_VAR_ERROR"), pathOffset, currToken.offset);
                    }
                    if (pathOffset - currToken.offset > 1) {
                        throw new ZosConnectParseException(Xlat.error((String)"INVALID_ENV_PROMOTION_VAR_ERROR"), pathOffset, currToken.offset);
                    }
                    insideCurlyBraces = true;
                    break;
                }
                case '}': {
                    if (!inEnvPromotionVariable) {
                        throw new ZosConnectParseException(Xlat.error((String)"INVALID_ENV_PROMOTION_VAR_ERROR"), pathOffset, currToken.offset);
                    }
                    if (pathOffset - currToken.offset == 2) {
                        throw new ZosConnectParseException(Xlat.error((String)"INVALID_ENV_PROMOTION_VAR_ERROR"), pathOffset, currToken.offset);
                    }
                    inEnvPromotionVariable = false;
                    insideCurlyBraces = false;
                    if (pathOffset - currToken.offset <= 1) break;
                    currToken.text = path.substring(currToken.offset, pathOffset + 1);
                    currToken.length = currToken.text.length();
                    tokens.add(currToken);
                    break;
                }
                default: {
                    if (!inEnvPromotionVariable || insideCurlyBraces) break;
                    throw new ZosConnectParseException(Xlat.error((String)"INVALID_ENV_PROMOTION_VAR_ERROR"), pathOffset, currToken.offset);
                }
            }
            ++pathOffset;
        }
        return tokens;
    }
}

