/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.parsers.path;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectParseException;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.parsers.path.AbstractPathParser;
import com.ibm.zosconnect.ui.parsers.path.PathParameter;
import com.ibm.zosconnect.ui.parsers.path.PathSeparatorToken;
import com.ibm.zosconnect.ui.parsers.path.PathToken;
import com.ibm.zosconnect.ui.parsers.path.QueryParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ApiPathParser
extends AbstractPathParser {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<ZosConnectParseException> errors;
    private List<PathToken> tokens = new ArrayList<PathToken>();

    public ApiPathParser() {
        this.errors = new ArrayList<ZosConnectParseException>();
    }

    public void parse(String path) throws ZosConnectParseException {
        this.tokens.clear();
        this.errors.clear();
        boolean inPathParameter = false;
        boolean inQueryParameter = false;
        HashSet<String> pathParams = new HashSet<String>();
        HashSet<String> queryParams = new HashSet<String>();
        PathToken currToken = new PathToken();
        int pathOffset = 0;
        while (pathOffset < path.length()) {
            char ch = path.charAt(pathOffset);
            switch (ch) {
                case '/': {
                    inPathParameter = false;
                    inQueryParameter = false;
                    PathSeparatorToken pathSepToken = new PathSeparatorToken();
                    pathSepToken.offset = pathOffset;
                    pathSepToken.length = 1;
                    pathSepToken.textNoDelim = pathSepToken.text = String.valueOf(ch);
                    this.tokens.add(pathSepToken);
                    break;
                }
                case '{': {
                    if (inQueryParameter) {
                        this.errors.add(new ZosConnectParseException(Xlat.error((String)"INVALID_QUERY_PARM_ERROR"), pathOffset, currToken.offset));
                    }
                    inPathParameter = true;
                    currToken = new PathParameter();
                    currToken.offset = pathOffset;
                    break;
                }
                case '}': {
                    if (!inPathParameter) {
                        this.errors.add(new ZosConnectParseException(Xlat.error((String)"INVALID_PATH_PARM_ERROR"), pathOffset, currToken.offset));
                    }
                    inPathParameter = false;
                    if (currToken.offset < 0 || pathOffset - currToken.offset <= 1) break;
                    currToken.text = path.substring(currToken.offset, pathOffset + 1);
                    currToken.textNoDelim = path.substring(currToken.offset + 1, pathOffset);
                    currToken.length = currToken.text.length();
                    this.tokens.add(currToken);
                    if (pathParams.add(currToken.textNoDelim)) break;
                    this.errors.add(new ZosConnectParseException(Xlat.error((String)"DUPLICATE_PATH_PARM_ERROR", (String[])new String[]{currToken.text}), currToken.offset, currToken.offset));
                    break;
                }
                case '?': {
                    if (inPathParameter) {
                        this.errors.add(new ZosConnectParseException(Xlat.error((String)"INVALID_PATH_PARM_ERROR"), pathOffset, currToken.offset));
                    }
                    inQueryParameter = true;
                    currToken = new QueryParameter();
                    currToken.offset = pathOffset;
                    break;
                }
                case '&': {
                    if (inPathParameter) {
                        this.errors.add(new ZosConnectParseException(Xlat.error((String)"INVALID_PATH_PARM_ERROR"), pathOffset, currToken.offset));
                    }
                    if (inQueryParameter) {
                        currToken.text = path.substring(currToken.offset, pathOffset);
                        currToken.textNoDelim = path.substring(currToken.offset + 1, pathOffset);
                        currToken.length = currToken.text.length();
                        this.tokens.add(currToken);
                        if (!queryParams.add(currToken.textNoDelim)) {
                            this.errors.add(new ZosConnectParseException(Xlat.error((String)"DUPLICATE_QUERY_PARM_ERROR", (String[])new String[]{currToken.text}), currToken.offset, currToken.offset));
                        }
                    }
                    inQueryParameter = true;
                    currToken = new QueryParameter();
                    currToken.offset = pathOffset;
                }
            }
            ++pathOffset;
        }
        if (inQueryParameter && currToken.offset >= 0 && pathOffset - currToken.offset > 1) {
            currToken.text = path.substring(currToken.offset, pathOffset);
            currToken.textNoDelim = path.substring(currToken.offset + 1, pathOffset);
            currToken.length = currToken.text.length();
            this.tokens.add(currToken);
            if (!queryParams.add(currToken.textNoDelim)) {
                this.errors.add(new ZosConnectParseException(Xlat.error((String)"DUPLICATE_QUERY_PARM_ERROR", (String[])new String[]{currToken.text}), currToken.offset, currToken.offset));
            }
        }
    }

    public List<ZosConnectParseException> getErrors() {
        return this.errors;
    }

    public List<PathToken> getTokens() {
        return this.tokens;
    }
}

