/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav.properties;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ServerPropertiesSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label labelType;
    private Label labelName;
    private Label labelHost;
    private Label labelPort;
    private Label textType;
    private Label textName;
    private Label textHost;
    private Label textPort;
    private Composite containerComposite;
    private Composite row1Composite;
    private Composite row2Composite;
    private Composite row3Composite;
    private Composite row4Composite;
    private TabbedPropertySheetWidgetFactory factory;
    private ZosConnectServerNode selectedServerNode;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.factory = this.getWidgetFactory();
        this.containerComposite = this.factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        this.containerComposite.setLayout((Layout)layout);
        this.row1Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row2Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row3Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row4Composite = this.factory.createFlatFormComposite(this.containerComposite);
        RowLayout rLayout = new RowLayout();
        this.row1Composite.setLayout((Layout)rLayout);
        this.row2Composite.setLayout((Layout)rLayout);
        this.row3Composite.setLayout((Layout)rLayout);
        this.row4Composite.setLayout((Layout)rLayout);
        this.labelType = this.factory.createLabel(this.row1Composite, Xlat.label((String)"PROPERTIES_RESOURCE_TYPE") + Xlat.colon());
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.labelType.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)this.labelType.getDisplay());
        this.labelType.setFont(boldFont);
        this.labelType.setLayoutData((Object)new RowData());
        this.textType = this.factory.createLabel(this.row1Composite, Xlat.label((String)"PROPERTIES_SERVER_TYPE"));
        this.textType.setLayoutData((Object)new RowData());
        this.labelName = this.factory.createLabel(this.row2Composite, Xlat.label((String)"PROPERTIES_SERVER_NAME") + Xlat.colon());
        this.labelName.setFont(boldFont);
        this.labelName.setLayoutData((Object)new RowData());
        this.textName = this.factory.createLabel(this.row2Composite, "");
        this.textName.setLayoutData((Object)new RowData());
        this.labelHost = this.factory.createLabel(this.row3Composite, Xlat.label((String)"PROPERTIES_SERVER_HOST") + Xlat.colon());
        this.labelHost.setFont(boldFont);
        this.labelHost.setLayoutData((Object)new RowData());
        this.textHost = this.factory.createLabel(this.row3Composite, "");
        this.textHost.setLayoutData((Object)new RowData());
        this.labelPort = this.factory.createLabel(this.row4Composite, Xlat.label((String)"PROPERTIES_SERVER_PORT") + Xlat.colon());
        this.labelPort.setFont(boldFont);
        this.labelPort.setLayoutData((Object)new RowData());
        this.textPort = this.factory.createLabel(this.row4Composite, "");
        this.textPort.setLayoutData((Object)new RowData());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.selectedServerNode = (ZosConnectServerNode)((IStructuredSelection)selection).getFirstElement();
    }

    public void refresh() {
        super.refresh();
        ConnectionProfile profile = this.selectedServerNode.getConnectionProfile();
        if (profile != null) {
            this.textName.setText(StringUtils.trimToEmpty((String)profile.getName()));
            this.textHost.setText(StringUtils.trimToEmpty((String)profile.getAttribute("host")));
            this.textPort.setText(StringUtils.trimToEmpty((String)profile.getAttribute("port")));
        }
        this.containerComposite.layout(true);
    }
}

