/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav.properties;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ApiPropertiesSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label labelType;
    private Label labelName;
    private Label labelVersion;
    private Label labelDescription;
    private Label labelStatus;
    private Label labelApiUrl;
    private Label labelDocumentation;
    private StyledText textType;
    private StyledText textName;
    private StyledText textVersion;
    private StyledText textDescription;
    private StyledText textStatus;
    private ImageHyperlink imageLinkApiUrl;
    private ImageHyperlink imageLinkDocUrl;
    private Hyperlink linkApiUrl;
    private Hyperlink linkDocUrl;
    private Composite containerComposite;
    private Composite row1Composite;
    private Composite row2Composite;
    private Composite row3Composite;
    private Composite row4Composite;
    private Composite row5Composite;
    private Composite row6Composite;
    private Composite row7Composite;
    private TabbedPropertySheetWidgetFactory factory;
    private ZosConnectApiNode selectedApiNode;
    private ClickUrlListener clickApiUrlListener = null;
    private ClickUrlListener clickDocUrlListener = null;
    private CopyUrlListener copyApiUrlListener = null;
    private CopyUrlListener copyDocUrlListener = null;
    private ZosConnectApi api;
    private ZosConnectApiDetail apiDetail;
    private TabbedPropertySheetPage page;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.factory = this.getWidgetFactory();
        this.containerComposite = this.factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        GridData data = new GridData(16384, 4, false, true);
        data.widthHint = 500;
        this.containerComposite.setLayout((Layout)layout);
        this.containerComposite.setData((Object)data);
        this.row1Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row2Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row3Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row4Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row5Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row6Composite = this.factory.createFlatFormComposite(this.containerComposite);
        this.row7Composite = this.factory.createFlatFormComposite(this.containerComposite);
        RowLayout rLayout = new RowLayout();
        rLayout.center = true;
        rLayout.wrap = true;
        this.row1Composite.setLayout((Layout)rLayout);
        this.row2Composite.setLayout((Layout)rLayout);
        this.row3Composite.setLayout((Layout)rLayout);
        this.row4Composite.setLayout((Layout)rLayout);
        this.row5Composite.setLayout((Layout)rLayout);
        this.row6Composite.setLayout((Layout)rLayout);
        this.row7Composite.setLayout((Layout)rLayout);
        this.labelType = this.factory.createLabel(this.row1Composite, Xlat.label((String)"PROPERTIES_RESOURCE_TYPE") + Xlat.colon());
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)this.labelType.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)this.labelType.getDisplay());
        this.labelType.setFont(boldFont);
        this.labelType.setLayoutData((Object)new RowData());
        this.textType = new StyledText(this.row1Composite, 64);
        this.textType.setText(Xlat.label((String)"PROPERTIES_APITYPE"));
        this.textType.setEditable(false);
        this.textType.setLayoutData((Object)new RowData());
        this.labelName = this.factory.createLabel(this.row2Composite, Xlat.label((String)"PROPERTIES_API_NAME") + Xlat.colon());
        this.labelName.setFont(boldFont);
        this.labelName.setLayoutData((Object)new RowData());
        this.textName = new StyledText(this.row2Composite, 64);
        this.textName.setEditable(false);
        this.textName.setLayoutData((Object)new RowData());
        this.labelVersion = this.factory.createLabel(this.row3Composite, Xlat.label((String)"PROPERTIES_API_VERSION") + Xlat.colon());
        this.labelVersion.setFont(boldFont);
        this.labelVersion.setLayoutData((Object)new RowData());
        this.textVersion = new StyledText(this.row3Composite, 64);
        this.textVersion.setEditable(false);
        this.textVersion.setLayoutData((Object)new RowData());
        this.labelApiUrl = this.factory.createLabel(this.row4Composite, Xlat.label((String)"PROPERTIES_API_APIURL") + Xlat.colon());
        this.labelApiUrl.setFont(boldFont);
        this.labelApiUrl.setLayoutData((Object)new RowData());
        this.imageLinkApiUrl = this.factory.createImageHyperlink(this.row4Composite, 0);
        this.imageLinkApiUrl.setLayoutData((Object)new RowData());
        this.imageLinkApiUrl.setImage(XImg.icon((String)"copy_edit.png"));
        this.imageLinkApiUrl.setToolTipText(Xlat.description((String)"TOOLTIP_COPY_LINK_LOCATION"));
        this.linkApiUrl = this.factory.createHyperlink(this.row4Composite, "", 64);
        this.linkApiUrl.setLayoutData((Object)new RowData());
        this.labelStatus = this.factory.createLabel(this.row5Composite, Xlat.label((String)"PROPERTIES_API_STATUS") + Xlat.colon());
        this.labelStatus.setFont(boldFont);
        this.labelStatus.setLayoutData((Object)new RowData());
        this.textStatus = new StyledText(this.row5Composite, 64);
        this.textStatus.setEditable(false);
        this.textStatus.setLayoutData((Object)new RowData());
        this.labelDescription = this.factory.createLabel(this.row6Composite, Xlat.label((String)"PROPERTIES_API_DESCRIPTION") + Xlat.colon());
        this.labelDescription.setFont(boldFont);
        this.labelDescription.setLayoutData((Object)new RowData());
        this.textDescription = new StyledText(this.row6Composite, 64);
        this.textDescription.setEditable(false);
        this.textDescription.setLayoutData((Object)new RowData());
        this.labelDocumentation = this.factory.createLabel(this.row7Composite, Xlat.label((String)"PROPERTIES_API_DOCUMENTATION") + Xlat.colon());
        this.labelDocumentation.setFont(boldFont);
        this.labelDocumentation.setLayoutData((Object)new RowData());
        this.imageLinkDocUrl = this.factory.createImageHyperlink(this.row7Composite, 0);
        this.imageLinkDocUrl.setLayoutData((Object)new RowData());
        this.imageLinkDocUrl.setImage(XImg.icon((String)"copy_edit.png"));
        this.imageLinkDocUrl.setToolTipText(Xlat.description((String)"TOOLTIP_COPY_LINK_LOCATION"));
        this.linkDocUrl = this.factory.createHyperlink(this.row7Composite, "", 64);
        this.linkDocUrl.setLayoutData((Object)new RowData());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.selectedApiNode = (ZosConnectApiNode)((IStructuredSelection)selection).getFirstElement();
    }

    public void refresh() {
        super.refresh();
        ZosConnectServerNode serverNode = (ZosConnectServerNode)this.selectedApiNode.getParent().getParent();
        if (!serverNode.getConnectedState()) {
            return;
        }
        this.api = this.selectedApiNode.getApi();
        this.apiDetail = this.selectedApiNode.getApiDetail();
        if (XSwt.isNotDisposed((Control)this.imageLinkApiUrl) && this.copyApiUrlListener != null) {
            this.imageLinkApiUrl.removeHyperlinkListener((IHyperlinkListener)this.copyApiUrlListener);
            this.copyApiUrlListener = null;
        }
        if (XSwt.isNotDisposed((Control)this.linkApiUrl) && this.clickApiUrlListener != null) {
            this.linkApiUrl.removeHyperlinkListener((IHyperlinkListener)this.clickApiUrlListener);
            this.clickApiUrlListener = null;
        }
        if (XSwt.isNotDisposed((Control)this.imageLinkDocUrl) && this.copyDocUrlListener != null) {
            this.imageLinkDocUrl.removeHyperlinkListener((IHyperlinkListener)this.copyDocUrlListener);
            this.copyDocUrlListener = null;
        }
        if (XSwt.isNotDisposed((Control)this.linkDocUrl) && this.clickDocUrlListener != null) {
            this.linkDocUrl.removeHyperlinkListener((IHyperlinkListener)this.clickDocUrlListener);
            this.clickDocUrlListener = null;
        }
        XSwt.setText((StyledText)this.textName, (String)StringUtils.trimToEmpty((String)this.api.getName()));
        XSwt.setText((StyledText)this.textDescription, (String)StringUtils.trimToEmpty((String)this.api.getDescription()));
        XSwt.setText((StyledText)this.textVersion, (String)StringUtils.trimToEmpty((String)this.api.getVersion()));
        XSwt.setText((StyledText)this.textStatus, (String)"");
        XSwt.setText((Hyperlink)this.linkApiUrl, (String)"");
        XSwt.setText((Hyperlink)this.linkDocUrl, (String)"");
        if (this.apiDetail.getStatus() != null) {
            XSwt.setText((StyledText)this.textStatus, (String)this.apiDetail.getStatus().toStringXlat());
        }
        if (!XSwt.isAnyDisposed((Control[])new Control[]{this.imageLinkApiUrl, this.linkApiUrl})) {
            String apiUrl = StringUtils.trimToEmpty((String)this.apiDetail.getApiUrl());
            this.linkApiUrl.setText(apiUrl);
            if (!apiUrl.isEmpty()) {
                this.copyApiUrlListener = new CopyUrlListener((Control)this.imageLinkApiUrl, apiUrl);
                this.imageLinkApiUrl.addHyperlinkListener((IHyperlinkListener)this.copyApiUrlListener);
                this.clickApiUrlListener = new ClickUrlListener((Control)this.linkApiUrl, apiUrl);
                this.linkApiUrl.addHyperlinkListener((IHyperlinkListener)this.clickApiUrlListener);
            }
        }
        if (!XSwt.isAnyDisposed((Control[])new Control[]{this.imageLinkDocUrl, this.linkDocUrl})) {
            String docUrl = "";
            if (this.apiDetail.getDocumentation() != null) {
                docUrl = StringUtils.trimToEmpty((String)this.apiDetail.getDocumentation().getSwagger());
            }
            this.linkDocUrl.setText(docUrl);
            if (!docUrl.isEmpty()) {
                this.copyDocUrlListener = new CopyUrlListener((Control)this.imageLinkDocUrl, docUrl);
                this.imageLinkDocUrl.addHyperlinkListener((IHyperlinkListener)this.copyDocUrlListener);
                this.clickDocUrlListener = new ClickUrlListener((Control)this.linkDocUrl, docUrl);
                this.linkDocUrl.addHyperlinkListener((IHyperlinkListener)this.clickDocUrlListener);
            }
        }
        XSwt.layout((Composite)this.containerComposite, (boolean)true);
    }

    private class ClickUrlListener
    extends HyperlinkAdapter2 {
        private String url;

        public ClickUrlListener(Control owner, String url) {
            super(owner);
            this.url = url;
        }

        public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = browserSupport.getExternalBrowser();
                browser.openURL(URI.create(this.url).toURL());
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                ZCeeErrorDialog.openError((Exception)e);
            }
        }
    }

    private class CopyUrlListener
    extends HyperlinkAdapter2 {
        private String url;

        public CopyUrlListener(Control owner, String url) {
            super(owner);
            this.url = url;
        }

        public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
            XSwt.setClipboardText((String)this.url);
        }

        public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
            owner.setBackground(XSwt.getColor((int)19));
        }

        public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
            owner.setBackground(XSwt.getColor((int)37));
        }
    }
}

