/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.nav.IZosConnectServerViewParticipant;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ZosConnectServerViewExtension {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = ZosConnectServerViewExtension.class.getName();
    private static final IConfigurationElement[] participantElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.zosconnect.ui.servers.view.participant");
    private Map<String, IZosConnectServerViewParticipant> participants;
    private static ZosConnectServerViewExtension instance;
    private Map<Class<?>, IZosConnectServerViewParticipant> decorators;

    public static ZosConnectServerViewExtension getSingletonInstance() {
        if (instance == null) {
            instance = ZosConnectServerViewExtension.createInstance();
        }
        return instance;
    }

    private ZosConnectServerViewExtension(Map<String, IZosConnectServerViewParticipant> participants, Map<Class<?>, IZosConnectServerViewParticipant> decorators) {
        this.participants = participants;
        this.decorators = decorators;
    }

    private static ZosConnectServerViewExtension createInstance() {
        ZCeeUILogger.entering((String)TAG, (String)"getServerExtension()", (Object[])new Object[0]);
        HashMap<String, IZosConnectServerViewParticipant> participants = new HashMap<String, IZosConnectServerViewParticipant>();
        HashMap decorators = new HashMap();
        IConfigurationElement[] iConfigurationElementArray = participantElements;
        int n = participantElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement participantElement = iConfigurationElementArray[n2];
            String participantClass = participantElement.getAttribute("participantClass");
            Object executableParticipant = null;
            try {
                executableParticipant = participantElement.createExecutableExtension("participantClass");
                if (executableParticipant instanceof IZosConnectServerViewParticipant) {
                    IZosConnectServerViewParticipant participant = (IZosConnectServerViewParticipant)executableParticipant;
                    participants.put(participantClass, participant);
                    String[] stringArray = participant.getDecoratesClasses();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String className = stringArray[n4];
                        Class<?> decoratesClass = Class.forName(className);
                        decorators.put(decoratesClass, participant);
                        ++n4;
                    }
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++n2;
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getServerExtension()", (Object[])new Object[0]);
        return new ZosConnectServerViewExtension(participants, decorators);
    }

    public Map<String, IZosConnectServerViewParticipant> getParticipants() {
        return this.participants;
    }

    public Map<Class<?>, IZosConnectServerViewParticipant> getDecorators() {
        return this.decorators;
    }
}

