/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectService;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectServiceDetail;
import com.ibm.zosconnect.ui.connections.utils.ZCeeAdminApiUtils;
import com.ibm.zosconnect.ui.controllers.jetty.SwaggerUIController;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectApisFolder;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import com.ibm.zosconnect.ui.model.ZosConnectServicesFolder;
import com.ibm.zosconnect.ui.model.ZosConnectTreeObject;
import com.ibm.zosconnect.ui.model.ZosConnectTreeParent;
import com.ibm.zosconnect.ui.nav.HostConnectionManagerListener;
import com.ibm.zosconnect.ui.nav.HostConnectionServiceListener;
import com.ibm.zosconnect.ui.nav.IZosConnectServerViewParticipant;
import com.ibm.zosconnect.ui.nav.ServerContentProvider;
import com.ibm.zosconnect.ui.nav.ServerLabelProvider;
import com.ibm.zosconnect.ui.nav.ServerNavController;
import com.ibm.zosconnect.ui.nav.ZosConnectServerViewExtension;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ZosConnectServerNav
extends ViewPart
implements IDoubleClickListener,
ITabbedPropertySheetPageContributor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = ZosConnectServerNav.class.getName();
    public static final String ID = "com.ibm.zosconnect.ui.nav.ZosConnectServerNav";
    private FilteredTree tree;
    private TreeViewer viewer;
    private ZosConnectServerViewExtension viewExtension;
    private ServerNavController navController;
    private ZosConnectPreferencesWrapper wrapper = new ZosConnectPreferencesWrapper();
    private IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();
    private IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionManager();
    private HostConnectionServiceListener connServiceListener;
    private HostConnectionManagerListener connManagerListener;

    public ZosConnectServerNav() {
        try {
            this.navController = new ServerNavController();
            this.connServiceListener = new HostConnectionServiceListener(this);
            this.connManagerListener = new HostConnectionManagerListener(this);
            this.connectionService.addConnectionServiceListener((ConnectionServiceListener)this.connServiceListener);
            this.connectionManager.addListener((ConnectionManagerListener)this.connManagerListener);
            this.viewExtension = ZosConnectServerViewExtension.getSingletonInstance();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void addServers() {
        ZCeeUILogger.entering((String)TAG, (String)"addServers()", (Object[])new Object[0]);
        this.navController.addServerNodes();
        for (ZosConnectServerNode server : this.navController.getServerNodes()) {
            this.refreshServer(server);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"addServers()", (Object[])new Object[0]);
    }

    public void removeServer(ConnectionProfile profile) {
        ZCeeUILogger.entering((String)TAG, (String)"removeServer(profile={0})", (Object[])new Object[]{profile});
        this.navController.removeServerNode(profile);
        if (XSwt.isNotDisposed((Control)this.viewer.getTree())) {
            this.viewer.refresh();
        }
        ZCeeUILogger.exiting((String)TAG, (String)"removeServer(ConnectionProfile)", (Object[])new Object[0]);
    }

    public void addServer(ConnectionProfile profile) {
        ZCeeUILogger.entering((String)TAG, (String)"addServer(profile={0})", (Object[])new Object[]{profile});
        ZosConnectServerNode server = this.navController.addServerNode(profile);
        this.refreshServer(server);
        ZCeeUILogger.exiting((String)TAG, (String)"addServer(ConnectionProfile)", (Object[])new Object[0]);
    }

    public void refreshServer(ZosConnectServerNode server) {
        this.refreshServer(server, server.getJobGroup());
    }

    public void refreshServer(ZosConnectServerNode server, JobGroup jobGroup) {
        ZCeeUILogger.entering((String)TAG, (String)"refreshServer(server={0},jobGroup={1})", (Object[])new Object[]{server, jobGroup != null ? jobGroup.getName() : ""});
        ConnectionProfile profile = server.getConnectionProfile();
        IZCeeAdminApiConnection connection = ZCeeAdminApiUtils.getConnection((ConnectionProfile)profile, (boolean)false);
        server.setName(profile.getName());
        if (connection == null || !connection.isConnected()) {
            server.getJobGroup().cancel();
            server.setConnected(false);
            server.setConnection(null);
            server.removeChildren();
            this.refreshServerView(server);
            return;
        }
        server.setConnected(true);
        server.setConnection((IConnection)connection);
        this.refreshServerView(server);
        for (Map.Entry<String, IZosConnectServerViewParticipant> participant : this.viewExtension.getParticipants().entrySet()) {
            ZCeeUILogger.info((String)"Before call to IZosConnectServerViewParticipant={0}", (Object[])new Object[]{participant.getKey()});
            participant.getValue().refreshServer(server, jobGroup);
            ZCeeUILogger.info((String)"After call to IZosConnectServerViewParticipant={0}", (Object[])new Object[]{participant.getKey()});
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServer(ZosConnectServerNode)", (Object[])new Object[0]);
    }

    public void refreshDisconnectedServers() {
        ZCeeUILogger.entering((String)TAG, (String)"refreshDisconnectedServersView()", (Object[])new Object[0]);
        for (ZosConnectServerNode server : this.navController.getServerNodes()) {
            if (server.getConnectedState() && server.getConnection() != null && server.getConnection().isConnected()) continue;
            this.refreshServer(server);
        }
        ZCeeUILogger.entering((String)TAG, (String)"refreshDisconnectedServersView()", (Object[])new Object[0]);
    }

    public void refreshServerView(ZosConnectServerNode server) {
        ZCeeUILogger.entering((String)TAG, (String)"refreshServerView(server={0})", (Object[])new Object[]{server});
        if (XSwt.isNotDisposed((Control)this.viewer.getTree())) {
            this.viewer.refresh();
            this.restoreExpansionState(server);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServerView(ZosConnectServerNode)", (Object[])new Object[0]);
    }

    public void refreshServerViewNested(ZosConnectTreeParent nested) {
        ZCeeUILogger.entering((String)TAG, (String)"refreshServerViewNested(parent={0})", (Object[])new Object[]{nested});
        if (XSwt.isNotDisposed((Control)this.viewer.getTree())) {
            this.viewer.refresh((Object)nested);
            this.restoreExpansionState(nested);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServerViewNested(ZosConnectTreeParent)", (Object[])new Object[0]);
    }

    public void refreshServer(ConnectionProfile profile) {
        ZCeeUILogger.entering((String)TAG, (String)"refreshServer(profile={0})", (Object[])new Object[]{profile});
        ZosConnectServerNode server = this.getServer(profile);
        if (server != null) {
            this.refreshServer(server);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServer(ConnectionProfile)", (Object[])new Object[0]);
    }

    public void refreshServer(IConnection connection) {
        ConnectionProfile profile;
        ZCeeUILogger.entering((String)TAG, (String)"refreshServer(connection={0})", (Object[])new Object[]{connection});
        ConnectionConfiguration configuration = connection.getConfiguration();
        if (configuration != null && (profile = this.connectionManager.getConnectionProfile(configuration.getID())) != null) {
            this.refreshServer(profile);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServer(IConnection)", (Object[])new Object[0]);
    }

    public ZosConnectServerNode getServer(ConnectionProfile profile) {
        ZCeeUILogger.entering((String)TAG, (String)"getServer(profile={0})", (Object[])new Object[]{profile});
        ZosConnectServerNode server = null;
        List<ZosConnectServerNode> servers = this.navController.getServerNodes();
        Iterator<ZosConnectServerNode> serversIt = servers.iterator();
        while (server == null && serversIt.hasNext()) {
            ZosConnectServerNode nextServer = serversIt.next();
            ConnectionProfile nextProfile = nextServer.getConnectionProfile();
            if (nextProfile == null || !nextProfile.getId().equals(profile.getId())) continue;
            server = nextServer;
            server.setConnectionProfile(profile);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getServer(ConnectionProfile)", (Object[])new Object[0]);
        return server;
    }

    public ZosConnectServerNode getServer(IConnection connection) {
        ConnectionProfile profile;
        ZCeeUILogger.entering((String)TAG, (String)"getServer(connection={0})", (Object[])new Object[]{connection});
        ZosConnectServerNode server = null;
        ConnectionConfiguration configuration = connection.getConfiguration();
        if (configuration != null && (profile = this.connectionManager.getConnectionProfile(configuration.getID())) != null) {
            server = this.getServer(profile);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getServer(IConnection)", (Object[])new Object[0]);
        return server;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public ServerNavController getController() {
        return this.navController;
    }

    public void clearSelection() {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.navController.getInvisibleRoot()), true);
    }

    public void createPartControl(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (ZosConnectServerNav.this.connServiceListener != null) {
                    ZosConnectServerNav.this.connServiceListener.makeStale();
                }
                if (ZosConnectServerNav.this.connManagerListener != null) {
                    ZosConnectServerNav.this.connManagerListener.makeStale();
                }
            }
        });
        try {
            SwaggerUIController serverController = SwaggerUIController.getSingletonInstance();
            serverController.startServer();
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)e);
        }
        IDecoratorManager idm = PlatformUI.getWorkbench().getDecoratorManager();
        idm.update("com.ibm.zosconnect.ui.nav.ServerContentDecorator");
        ILabelDecorator decorator = idm.getLabelDecorator("com.ibm.zosconnect.ui.nav.ServerContentDecorator");
        this.tree = new FilteredTree(parent, 2050, new NavPatternFilter(), true){

            protected WorkbenchJob doCreateRefreshJob() {
                WorkbenchJob job = super.doCreateRefreshJob();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        Text filterControl = (this).ZosConnectServerNav.this.tree.getFilterControl();
                        String filterText = XSwt.getTrimText((Text)filterControl);
                        if (StringUtils.isBlank((CharSequence)filterText)) {
                            ZosConnectServerNav.this.restoreExpansionState((this).ZosConnectServerNav.this.navController.getServerNodes());
                        }
                    }
                });
                return job;
            }
        };
        this.tree.setInitialText(Xlat.description((String)"TOOLTIP_TYPE_FILTER_API_NAME"));
        this.viewer = this.tree.getViewer();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ServerContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new NavDecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)new ServerLabelProvider()), decorator, null));
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                Object expanded = event.getElement();
                if (expanded instanceof ZosConnectTreeObject) {
                    ((ZosConnectTreeObject)expanded).setExpanded(true);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                Object expanded = event.getElement();
                if (expanded instanceof ZosConnectTreeObject) {
                    ((ZosConnectTreeObject)expanded).setExpanded(false);
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "com.ibm.zosconnect.ui.serversView");
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.addServers();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void doubleClick(DoubleClickEvent event) {
        try {
            ISelection selection = event.getSelection();
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (!(firstElement instanceof ZosConnectApiNode)) {
                return;
            }
            ZosConnectApiNode api = (ZosConnectApiNode)firstElement;
            ZosConnectServerNode server = api.getServerNode();
            IZCeeAdminApiConnection connection = (IZCeeAdminApiConnection)server.getConnection();
            SwaggerUIController serverController = SwaggerUIController.getSingletonInstance();
            serverController.openApiExplorer(api.getApiDetail(), connection);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public static ZosConnectServerNav getView() {
        ZosConnectServerNav retVal = null;
        try {
            IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
            if (viewPart instanceof ZosConnectServerNav) {
                retVal = (ZosConnectServerNav)viewPart;
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return retVal;
    }

    public void restoreExpansionState(List<ZosConnectServerNode> servers) {
        for (ZosConnectServerNode server : servers) {
            this.restoreExpansionState(server);
        }
    }

    public void restoreExpansionState(ZosConnectTreeParent parent) {
        this.viewer.setExpandedState((Object)parent, parent.isExpanded());
        ZosConnectTreeObject[] zosConnectTreeObjectArray = parent.getChildren();
        int n = zosConnectTreeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZosConnectTreeObject treeObject = zosConnectTreeObjectArray[n2];
            if (treeObject instanceof ZosConnectTreeParent && this.viewer.isExpandable((Object)treeObject) && this.viewer.getExpandedState((Object)treeObject) != treeObject.isExpanded()) {
                this.viewer.setExpandedState((Object)treeObject, treeObject.isExpanded());
            }
            ++n2;
        }
    }

    public Map<ZosConnectApi, ZosConnectApiDetail> getApis(ZosConnectServerNode server) {
        ZCeeUILogger.entering((String)TAG, (String)"getApis(server={0})", (Object[])new Object[]{server});
        HashMap<ZosConnectApi, ZosConnectApiDetail> apis = new HashMap<ZosConnectApi, ZosConnectApiDetail>();
        ZosConnectTreeObject apiFolderObj = (ZosConnectTreeObject)ArrayUtilz.getFirstElementOfType((Object[])server.getChildren(), ZosConnectApisFolder.class);
        if (apiFolderObj instanceof ZosConnectApisFolder) {
            ZosConnectApisFolder apisFolder = (ZosConnectApisFolder)apiFolderObj;
            ZosConnectTreeObject[] zosConnectTreeObjectArray = apisFolder.getChildren();
            int n = zosConnectTreeObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZosConnectTreeObject apiNodeObj = zosConnectTreeObjectArray[n2];
                if (apiNodeObj instanceof ZosConnectApiNode) {
                    ZosConnectApiNode apiNode = (ZosConnectApiNode)apiNodeObj;
                    apis.put(apiNode.getApi(), apiNode.getApiDetail());
                }
                ++n2;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getApis(ZosConnectServerNode)", (Object[])new Object[0]);
        return apis;
    }

    public Map<ZosConnectService, ZosConnectServiceDetail> getServices(ZosConnectServerNode server) {
        ZCeeUILogger.entering((String)TAG, (String)"getServices(server={0})", (Object[])new Object[]{server});
        HashMap<ZosConnectService, ZosConnectServiceDetail> services = new HashMap<ZosConnectService, ZosConnectServiceDetail>();
        ZosConnectTreeObject servicesFolderObj = (ZosConnectTreeObject)ArrayUtilz.getFirstElementOfType((Object[])server.getChildren(), ZosConnectServicesFolder.class);
        if (servicesFolderObj instanceof ZosConnectServicesFolder) {
            ZosConnectServicesFolder servicesFolder = (ZosConnectServicesFolder)servicesFolderObj;
            ZosConnectTreeObject[] zosConnectTreeObjectArray = servicesFolder.getChildren();
            int n = zosConnectTreeObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZosConnectTreeObject serviceNodeObj = zosConnectTreeObjectArray[n2];
                if (serviceNodeObj instanceof ZosConnectServiceNode) {
                    ZosConnectServiceNode serviceNode = (ZosConnectServiceNode)serviceNodeObj;
                    services.put(serviceNode.getService(), serviceNode.getServiceDetail());
                }
                ++n2;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"getServices(ZosConnectServerNode)", (Object[])new Object[0]);
        return services;
    }

    public void cancelJobFamily(String family) {
        for (ZosConnectServerNode server : this.navController.getServerNodes()) {
            for (Job activeJob : server.getJobGroup().getActiveJobs()) {
                if (!activeJob.belongsTo((Object)family)) continue;
                activeJob.cancel();
            }
        }
    }

    private class NavDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public NavDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
            super(labelProvider, decorator, decorationContext);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }
    }

    private class NavPatternFilter
    extends PatternFilter {
        private NavPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof ZosConnectServerNode) {
                return true;
            }
            if (element instanceof ZosConnectApisFolder) {
                return true;
            }
            String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
            if (labelText == null) {
                return false;
            }
            return this.wordMatches(labelText);
        }
    }
}

