/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiStatus;
import com.ibm.zosconnect.ui.jobs.RefreshApisJob;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectApisFolder;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.IZosConnectServerViewParticipant;
import com.ibm.zosconnect.ui.nav.ServerOverlayImageDescriptor;
import com.ibm.zosconnect.ui.util.Images;
import com.ibm.zosconnect.ui.util.Utility;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ServerViewParticipant
implements IZosConnectServerViewParticipant {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = ServerViewParticipant.class.getName();
    private static final String[] decoratesClassNames = new String[]{ZosConnectApisFolder.class.getName(), ZosConnectServerNode.class.getName(), ZosConnectApiNode.class.getName()};
    private static Image DISCONNECTED_COMPOSITE_IMAGE = null;
    private static Image CONNECTED_COMPOSITE_IMAGE = null;
    private static Image API_STARTED_COMPOSITE_IMAGE = null;
    private static Image API_STOPPED_COMPOSITE_IMAGE = null;
    private static Image API_UNKNOWN_COMPOSITE_IMAGE = null;

    public ServerViewParticipant() {
        this.initDecoratedImages();
    }

    @Override
    public void refreshServer(ZosConnectServerNode server, JobGroup jobGroup) {
        ZCeeUILogger.entering((String)TAG, (String)"refreshServer(server={0})", (Object[])new Object[]{server});
        IConnection connection = server.getConnection();
        if (connection != null && connection.isConnected()) {
            RefreshApisJob refresh = new RefreshApisJob(server);
            if (jobGroup != null) {
                refresh.setJobGroup(jobGroup);
            }
            refresh.schedule();
        }
        ZCeeUILogger.exiting((String)TAG, (String)"refreshServer(ZosConnectServerNode)", (Object[])new Object[0]);
    }

    @Override
    public String[] getDecoratesClasses() {
        return decoratesClassNames;
    }

    @Override
    public String getText(Object element) {
        StringBuilder builder = new StringBuilder();
        if (element instanceof ZosConnectApisFolder) {
            builder.append(((ZosConnectApisFolder)element).getName());
        } else if (element instanceof ZosConnectServerNode) {
            builder.append(((ZosConnectServerNode)element).getName());
        } else if (element instanceof ZosConnectApiNode) {
            builder.append(((ZosConnectApiNode)element).getName());
        }
        return builder.toString();
    }

    @Override
    public Image getImage(Object element) {
        Image image = null;
        image = element instanceof ZosConnectApiNode ? Images.getApiImage() : (element instanceof ZosConnectApisFolder ? Images.getFolderImage() : (element instanceof ZosConnectServerNode ? Images.getServerImage() : Images.getErrorWarningImage()));
        return image;
    }

    @Override
    public String decorateText(String label, Object element) {
        StringBuilder builder = new StringBuilder();
        builder.append(label);
        if (element instanceof ZosConnectApiNode) {
            builder.append(this.decorateText((ZosConnectApiNode)element));
        } else if (element instanceof ZosConnectApisFolder) {
            builder.append(this.decorateText((ZosConnectApisFolder)element));
        } else if (element instanceof ZosConnectServerNode) {
            builder.append(this.decorateText((ZosConnectServerNode)element));
        }
        return builder.toString();
    }

    private String decorateText(ZosConnectApiNode node) {
        StringBuilder builder = new StringBuilder();
        ZosConnectApiStatus status = ZosConnectApiStatus.UNKNOWN;
        if (node.getApiDetail() != null) {
            status = node.getApiDetail().getStatus();
        }
        if (status != null) {
            builder.append(" (");
            builder.append(status.toStringXlat());
            builder.append(")");
        }
        return builder.toString();
    }

    private String decorateText(ZosConnectServerNode node) {
        StringBuilder builder = new StringBuilder();
        ConnectionProfile connProfile = node.getConnectionProfile();
        ConnectionConfiguration connConfig = connProfile.getConnectionConfiguration();
        builder.append(" (");
        builder.append(connConfig.getHost());
        builder.append(":");
        builder.append(connConfig.getPort());
        builder.append(")");
        return builder.toString();
    }

    private String decorateText(ZosConnectApisFolder node) {
        StringBuilder builder = new StringBuilder();
        if (node.isRefreshing()) {
            builder.append(" (");
            builder.append(Xlat.description((String)"STATUS_REFRESHING"));
            builder.append(")");
        } else {
            Integer apiCount = ArrayUtilz.length((Object[])node.getChildren());
            if (apiCount > 0) {
                builder.append(" (");
                builder.append(ArrayUtilz.length((Object[])node.getChildren()));
                builder.append(")");
            }
        }
        return builder.toString();
    }

    @Override
    public Image decorateImage(Image image, Object element) {
        if (element instanceof ZosConnectApiNode) {
            image = this.decorateImage(image, (ZosConnectApiNode)element);
        } else if (element instanceof ZosConnectServerNode) {
            image = this.decorateImage(image, (ZosConnectServerNode)element);
        }
        return image;
    }

    private Image decorateImage(Image image, ZosConnectApiNode element) {
        ZosConnectApiNode apiNode = element;
        image = apiNode.isStatusStarted() ? API_STARTED_COMPOSITE_IMAGE : (apiNode.isStatusStopped() ? API_STOPPED_COMPOSITE_IMAGE : API_UNKNOWN_COMPOSITE_IMAGE);
        return image;
    }

    private Image decorateImage(Image image, ZosConnectServerNode element) {
        boolean connected = element.getConnectedState();
        image = !connected ? DISCONNECTED_COMPOSITE_IMAGE : CONNECTED_COMPOSITE_IMAGE;
        return image;
    }

    private void initDecoratedImages() {
        ServerOverlayImageDescriptor olid;
        ImageDescriptor overlayImage;
        ImageDescriptor baseImage;
        if (CONNECTED_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor("zosconnectee_server_16.gif");
            overlayImage = Utility.getImageDescriptor("connected_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            CONNECTED_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
        if (DISCONNECTED_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor("zosconnectee_server_16.gif");
            overlayImage = Utility.getImageDescriptor("disconnected_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            DISCONNECTED_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
        if (API_STARTED_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor("zosconnectee_api_16.gif");
            overlayImage = Utility.getImageDescriptor("started_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            API_STARTED_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
        if (API_STOPPED_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor("zosconnectee_api_16.gif");
            overlayImage = Utility.getImageDescriptor("stopped_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            API_STOPPED_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
        if (API_UNKNOWN_COMPOSITE_IMAGE == null) {
            baseImage = Utility.getImageDescriptor("zosconnectee_api_16.gif");
            overlayImage = Utility.getImageDescriptor("unknown_overlay.gif");
            olid = new ServerOverlayImageDescriptor(baseImage, overlayImage);
            API_UNKNOWN_COMPOSITE_IMAGE = ImageDescriptor.createFromImageData((ImageData)olid.getImageData()).createImage();
        }
    }
}

