/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import java.util.logging.Logger;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ServerOverlayImageDescriptor
extends CompositeImageDescriptor {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ImageDescriptor imageDescriptor;
    private ImageDescriptor overlayImage;
    Point size;
    Point overlaySize;
    private static Logger logger;

    public ServerOverlayImageDescriptor(ImageDescriptor imgDescriptor, ImageDescriptor overlayImage) {
        this.setImageDescriptor(imgDescriptor);
        this.setOverlayImage(overlayImage);
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        try {
            int xValue = this.size.x - this.overlaySize.x;
            int yValue = this.size.y - this.overlaySize.y;
            ImageData baseImageData = this.imageDescriptor.getImageData();
            this.drawImage(baseImageData, 0, 0);
            ImageData overlayImageData = this.getOverlayImage().getImageData();
            this.drawImage(overlayImageData, xValue, yValue);
        }
        catch (Throwable e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    protected Point getSize() {
        return this.size;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        Rectangle bounds = imageDescriptor.createImage().getBounds();
        this.size = new Point(bounds.width, bounds.height);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setOverlayImage(ImageDescriptor overlayImage) {
        this.overlayImage = overlayImage;
        Rectangle bounds = overlayImage.createImage().getBounds();
        this.overlaySize = new Point(bounds.width, bounds.height);
    }

    public ImageDescriptor getOverlayImage() {
        return this.overlayImage;
    }
}

