/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.connections.utils.ZCeeAdminApiUtils;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectTreeObject;
import com.ibm.zosconnect.ui.model.ZosConnectTreeParent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;

public class ServerNavController {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZosConnectTreeParent invisibleRoot = new ZosConnectTreeParent("", null);

    public void addServerNodes() {
        this.invisibleRoot.removeChildren();
        List connProfiles = ZCeeAdminApiUtils.getConnectionProfiles();
        for (ConnectionProfile profile : connProfiles) {
            this.addServerNode(profile);
        }
    }

    public ZosConnectServerNode addServerNode(ConnectionProfile profile) {
        ZosConnectServerNode server = new ZosConnectServerNode(profile.getName(), this.invisibleRoot);
        server.setConnectionProfile(profile);
        this.invisibleRoot.addChild(server);
        return server;
    }

    public void removeServerNode(ConnectionProfile profile) {
        List<ZosConnectServerNode> servers = this.getServerNodes();
        ZosConnectServerNode server = null;
        Iterator<ZosConnectServerNode> serversIt = servers.iterator();
        while (server == null && serversIt.hasNext()) {
            ZosConnectServerNode nextServer = serversIt.next();
            ConnectionProfile nextProfile = nextServer.getConnectionProfile();
            if (nextProfile == null || !nextProfile.getId().equals(profile.getId())) continue;
            server = nextServer;
            server.setConnectionProfile(profile);
        }
        if (server != null) {
            this.invisibleRoot.removeChild(server);
        }
    }

    public List<ZosConnectServerNode> getServerNodes() {
        ZosConnectTreeObject[] serverNodes = this.invisibleRoot.getChildren();
        ArrayList<ZosConnectServerNode> retVal = new ArrayList<ZosConnectServerNode>(serverNodes.length);
        int i = 0;
        while (i < serverNodes.length) {
            retVal.add((ZosConnectServerNode)serverNodes[i]);
            ++i;
        }
        return retVal;
    }

    public ZosConnectTreeParent getInvisibleRoot() {
        return this.invisibleRoot;
    }
}

