/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.jobs.ConnectJob;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;

public class HostConnectionServiceListener
extends ConnectionServiceListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZosConnectServerNav nav;

    public HostConnectionServiceListener(ZosConnectServerNav nav) {
        this.nav = nav;
    }

    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)MessageFormat.format("event(event={0})", event), (Object[])new Object[0]);
        try {
            if ("com.ibm.zosconnect.ui.connections.category.adminapi".equals(event.getConnectionCategoryId())) {
                final ConnectionProfile eventConnProfile = event.getConnectionProfile();
                if (event instanceof ConnectionServiceListener.ConnectedEvent && eventConnProfile != null) {
                    ZosConnectServerNode server = this.nav.getServer(eventConnProfile);
                    if (server != null && !server.getConnectedState()) {
                        ZCeeUILogger.info((String)"connection profile \"{0}\" connected.", (Object[])new Object[]{eventConnProfile.getName()});
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                HostConnectionServiceListener.this.nav.refreshServer(eventConnProfile);
                            }
                        });
                    }
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent && eventConnProfile != null) {
                    ZosConnectServerNode server = this.nav.getServer(eventConnProfile);
                    if (server != null && server.getConnectedState()) {
                        server.getJobGroup().cancel();
                        ZCeeUILogger.info((String)"connection profile \"{0}\" disconnected.", (Object[])new Object[]{eventConnProfile.getName()});
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                HostConnectionServiceListener.this.nav.refreshServer(eventConnProfile);
                            }
                        });
                    }
                } else if (event instanceof ConnectionServiceListener.ExceptionEvent && eventConnProfile != null) {
                    Exception eventException = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                    ZCeeUILogger.info((String)"connection profile \"{0}\" exception: {1}.", (Object[])new Object[]{eventConnProfile.getName(), eventException.getMessage()});
                    if (eventException instanceof AuthenticationException) {
                        this.nav.cancelJobFamily(ConnectJob.TAG);
                        ZosConnectServerNode server = this.nav.getServer(eventConnProfile);
                        if (server != null) {
                            server.getJobGroup().cancel();
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                HostConnectionServiceListener.this.nav.refreshDisconnectedServers();
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"event(ConnectionServiceEvent)", (Object[])new Object[0]);
    }
}

