/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.nav;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Display;

public class HostConnectionManagerListener
extends ConnectionManagerListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZosConnectServerNav nav;
    private IConnectionDescriptor connectionDescriptor;
    private ConnectionRegistry connectionRegistry;

    public HostConnectionManagerListener(ZosConnectServerNav nav) {
        this.nav = nav;
        this.connectionRegistry = ConnectionRegistry.getConnectionRegistry();
        this.connectionDescriptor = this.connectionRegistry.find("com.ibm.zosconnect.ui.connections.type.adminapi");
    }

    public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)MessageFormat.format("event(event={0})", event), (Object[])new Object[0]);
        try {
            ConnectionProfile profile;
            final ConnectionProfile eventConnProfile = event.getConnectionProfile();
            if (event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                ConnectionProfile profile2 = event.getConnectionProfile();
                if (profile2.getConnectionDescriptor() == this.connectionDescriptor) {
                    ZCeeUILogger.info((String)"connection profile \"{0}\" updated.", (Object[])new Object[]{profile2.getName()});
                }
            } else if (event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                ConnectionProfile profile3 = event.getConnectionProfile();
                if (profile3.getConnectionDescriptor() == this.connectionDescriptor) {
                    ZCeeUILogger.info((String)"connection profile \"{0}\" added.", (Object[])new Object[]{profile3.getName()});
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HostConnectionManagerListener.this.nav.addServer(eventConnProfile);
                        }
                    });
                }
            } else if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent && (profile = event.getConnectionProfile()).getConnectionDescriptor() == this.connectionDescriptor) {
                ZCeeUILogger.info((String)"connection profile \"{0}\" removed.", (Object[])new Object[]{profile.getName()});
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        HostConnectionManagerListener.this.nav.removeServer(eventConnProfile);
                    }
                });
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"event(ConnectionManagerEvent)", (Object[])new Object[0]);
    }
}

