/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.model;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.util.SimpleLock;
import com.ibm.zosconnect.ui.model.ZosConnectTreeParent;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.jobs.JobGroup;

public class ZosConnectServerNode
extends ZosConnectTreeParent {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean connected = false;
    private IConnection connection;
    private ConnectionProfile connectionProfile;
    private Map<String, SimpleLock> locks = new HashMap<String, SimpleLock>();
    private JobGroup jobGroup;

    public ZosConnectServerNode(String connName, ZosConnectTreeParent parent) {
        super(connName, parent);
        this.jobGroup = new JobGroup(connName, 1, 1);
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean getConnectedState() {
        return this.connected;
    }

    public ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setConnectionProfile(ConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
    }

    public boolean acquireLock(String name) {
        String lockName = this.getName() + ":" + name;
        SimpleLock lock = this.locks.get(lockName);
        if (lock == null) {
            lock = new SimpleLock(lockName);
            this.locks.put(lockName, lock);
        }
        lock.acquireLock();
        return true;
    }

    public boolean releaseLock(String name) {
        String lockName = this.getName() + ":" + name;
        SimpleLock lock = this.locks.get(lockName);
        if (lock == null) {
            return false;
        }
        lock.releaseLock(false);
        return true;
    }

    public JobGroup getJobGroup() {
        return this.jobGroup;
    }
}

