/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectServiceNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public abstract class ZosConnectHandler
extends AbstractHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static IStructuredSelection getSelection() {
        IStructuredSelection retVal = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            retVal = (IStructuredSelection)selection;
        }
        return retVal;
    }

    public static Object getSelectionFirstElement() {
        Object retVal = null;
        IStructuredSelection selection = ZosConnectHandler.getSelection();
        if (selection != null) {
            retVal = selection.getFirstElement();
        }
        return retVal;
    }

    public static <T> List<T> getSelectedElementsOfType(Class<T> type) {
        return ZosConnectHandler.getSelectedElementsOfType(type, false);
    }

    public static <T> List<T> getSelectedElementsOfType(Class<T> type, boolean searchUp) {
        ArrayList<Object> retVal;
        block5: {
            IStructuredSelection selection;
            block4: {
                TreePath[] paths;
                retVal = new ArrayList<Object>();
                selection = ZosConnectHandler.getSelection();
                if (!(selection instanceof ITreeSelection)) break block4;
                TreeSelection treeSel = (TreeSelection)selection;
                TreePath[] treePathArray = paths = treeSel.getPaths();
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    Object lastSeg = path.getLastSegment();
                    while (lastSeg != null) {
                        if (lastSeg.getClass() == type || ArrayUtils.contains((Object[])lastSeg.getClass().getInterfaces(), type)) {
                            if (retVal.contains(lastSeg)) break;
                            retVal.add(lastSeg);
                            break;
                        }
                        if (!searchUp) break;
                        path = path.getParentPath();
                        lastSeg = path.getLastSegment();
                    }
                    ++n2;
                }
                break block5;
            }
            if (selection == null) break block5;
            for (Object selected : selection) {
                if (selected.getClass() != type || retVal.contains(selected)) continue;
                retVal.add(selected);
            }
        }
        return retVal;
    }

    public static Map<ZosConnectServerNode, Boolean> getServerToggleMap(List<ZosConnectApiNode> apiNodes) {
        HashMap<ZosConnectServerNode, Boolean> retVal = new HashMap<ZosConnectServerNode, Boolean>();
        for (ZosConnectApiNode apiNode : apiNodes) {
            ZosConnectServerNode server = (ZosConnectServerNode)apiNode.getParent().getParent();
            if (retVal.containsKey(server)) continue;
            retVal.put(server, Boolean.FALSE);
        }
        return retVal;
    }

    public static LinkedHashMap<ZosConnectServerNode, List<ZosConnectApiNode>> getServer2ApisMap(List<ZosConnectApiNode> apiNodes) {
        LinkedHashMap<ZosConnectServerNode, List<ZosConnectApiNode>> server2Apis = new LinkedHashMap<ZosConnectServerNode, List<ZosConnectApiNode>>();
        for (ZosConnectApiNode apiNode : apiNodes) {
            ZosConnectServerNode server = (ZosConnectServerNode)apiNode.getParent().getParent();
            List<ZosConnectApiNode> apis = server2Apis.get(server);
            if (apis == null) {
                apis = new ArrayList<ZosConnectApiNode>();
                server2Apis.put(server, apis);
            }
            apis.add(apiNode);
        }
        return server2Apis;
    }

    public static LinkedHashMap<ZosConnectServerNode, List<ZosConnectServiceNode>> getServer2ServicesMap(List<ZosConnectServiceNode> serviceNodes) {
        LinkedHashMap<ZosConnectServerNode, List<ZosConnectServiceNode>> server2Services = new LinkedHashMap<ZosConnectServerNode, List<ZosConnectServiceNode>>();
        for (ZosConnectServiceNode serviceNode : serviceNodes) {
            ZosConnectServerNode server = (ZosConnectServerNode)serviceNode.getParent().getParent();
            List<ZosConnectServiceNode> services = server2Services.get(server);
            if (services == null) {
                services = new ArrayList<ZosConnectServiceNode>();
                server2Services.put(server, services);
            }
            services.add(serviceNode);
        }
        return server2Services;
    }
}

