/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.controllers.jetty.SwaggerUIController;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class TestApiExplorerHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = TestApiExplorerHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object firstElement;
        block5: {
            block4: {
                ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof ZosConnectServerNav) break block4;
                return null;
            }
            firstElement = TestApiExplorerHandler.getSelectionFirstElement();
            if (firstElement instanceof ZosConnectApiNode) break block5;
            return null;
        }
        try {
            ZosConnectApiNode api = (ZosConnectApiNode)firstElement;
            ZosConnectServerNode server = api.getServerNode();
            IZCeeAdminApiConnection connection = (IZCeeAdminApiConnection)server.getConnection();
            SwaggerUIController serverController = SwaggerUIController.getSingletonInstance();
            serverController.openApiExplorer(api.getApiDetail(), connection);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        ZCeeUILogger.entering((String)TAG, (String)"isEnabled()", (Object[])new Object[0]);
        List<ZosConnectApiNode> apis = TestApiExplorerHandler.getSelectedElementsOfType(ZosConnectApiNode.class);
        if (apis.size() == 1) {
            Iterator<ZosConnectApiNode> apisIt = apis.iterator();
            enabled = true;
            while (enabled && apisIt.hasNext()) {
                ZosConnectApiNode api = apisIt.next();
                ZosConnectServerNode server = api.getServerNode();
                if (server != null && server.getConnectedState()) continue;
                enabled = false;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"{0}:isEnabled()", (Object[])new Object[]{enabled});
        return enabled;
    }
}

