/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.jobs.StartApisJob;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import com.ibm.zosconnect.ui.util.AdminApiConnectionUIUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class StartApisHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = StartApisHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<ZosConnectApiNode> apiNodes;
        block7: {
            block6: {
                ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof ZosConnectServerNav) break block6;
                return null;
            }
            apiNodes = StartApisHandler.getSelectedElementsOfType(ZosConnectApiNode.class);
            if (!ListUtilz.isEmpty(apiNodes)) break block7;
            return null;
        }
        try {
            boolean sequentialJobExecution = AdminApiConnectionUIUtil.apisRefSameCredential(apiNodes);
            ZCeeUILogger.info((String)"sequentialJobExecution={0}", (Object[])new Object[]{sequentialJobExecution});
            ZosConnectServerNode firstServer = apiNodes.get(0).getServerNode();
            LinkedHashMap<ZosConnectServerNode, List<ZosConnectApiNode>> server2ApisMap = StartApisHandler.getServer2ApisMap(apiNodes);
            for (Map.Entry<ZosConnectServerNode, List<ZosConnectApiNode>> server2Apis : server2ApisMap.entrySet()) {
                StartApisJob startApisJob = new StartApisJob(server2Apis.getKey(), server2Apis.getValue());
                if (sequentialJobExecution) {
                    startApisJob.setJobGroup(firstServer.getJobGroup());
                }
                startApisJob.setUser(true);
                startApisJob.schedule();
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        ZCeeUILogger.entering((String)TAG, (String)"isEnabled()", (Object[])new Object[0]);
        List<ZosConnectApiNode> apis = StartApisHandler.getSelectedElementsOfType(ZosConnectApiNode.class);
        Iterator<ZosConnectApiNode> apisIt = apis.iterator();
        if (apisIt.hasNext()) {
            enabled = true;
            while (enabled && apisIt.hasNext()) {
                ZosConnectApiNode api = apisIt.next();
                ZosConnectServerNode server = api.getServerNode();
                if (server != null && server.getConnectedState() && api.isStatusStopped()) continue;
                enabled = false;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"{0}:isEnabled()", (Object[])new Object[]{enabled});
        return enabled;
    }
}

