/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import com.ibm.zosconnect.ui.util.AdminApiConnectionUIUtil;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshServersHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = RefreshServersHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<ZosConnectServerNode> servers;
        ZosConnectServerNav nav;
        block7: {
            IWorkbenchPart part;
            block6: {
                ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
                part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof ZosConnectServerNav) break block6;
                return null;
            }
            nav = (ZosConnectServerNav)part;
            servers = RefreshServersHandler.getSelectedElementsOfType(ZosConnectServerNode.class);
            if (!ListUtilz.isEmpty(servers)) break block7;
            return null;
        }
        try {
            boolean sequentialJobExecution = AdminApiConnectionUIUtil.serversRefSameCredential(servers);
            ZCeeUILogger.info((String)"sequentialJobExecution={0}", (Object[])new Object[]{sequentialJobExecution});
            ZosConnectServerNode firstServer = servers.get(0);
            for (ZosConnectServerNode server : servers) {
                if (sequentialJobExecution) {
                    nav.refreshServer(server, firstServer.getJobGroup());
                    continue;
                }
                nav.refreshServer(server);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        ZCeeUILogger.entering((String)TAG, (String)"isEnabled()", (Object[])new Object[0]);
        List<ZosConnectServerNode> servers = RefreshServersHandler.getSelectedElementsOfType(ZosConnectServerNode.class);
        Iterator<ZosConnectServerNode> serversIt = servers.iterator();
        if (serversIt.hasNext()) {
            enabled = true;
            while (enabled && serversIt.hasNext()) {
                ZosConnectServerNode server = serversIt.next();
                if (server != null && server.getConnectedState()) continue;
                enabled = false;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"{0}:isEnabled()", (Object[])new Object[]{enabled});
        return enabled;
    }
}

