/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.dialogs.ServiceSelectionDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportServiceHandler
implements IHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchPartSite site = part.getSite();
        ISelectionProvider selProvider = site.getSelectionProvider();
        ISelection selection = selProvider.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection treeSel = (TreeSelection)selection;
            TreePath[] paths = treeSel.getPaths();
            TreePath path = paths[0];
            Object lastSeg = path.getLastSegment();
            IProject proj = null;
            while (path != null) {
                if (lastSeg instanceof IProject) {
                    proj = (IProject)lastSeg;
                    break;
                }
                path = path.getParentPath();
                lastSeg = path.getLastSegment();
            }
            if (proj != null) {
                ApiProjectController apiProjectController = new ApiProjectController(proj);
                IFile packageXmlFile = proj.getFile("package.xml");
                ApiModelController apiModelController = null;
                try {
                    apiModelController = new ApiModelController(packageXmlFile, apiProjectController);
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                }
                ServiceSelectionDialog dialog = new ServiceSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), apiProjectController, apiModelController, true);
                dialog.open();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        IStructuredSelection selection = (IStructuredSelection)selectionService.getSelection();
        int numApis = selection.toList().size();
        return numApis == 1;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

