/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.connections.AdminApiConnectionUtil;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class DisconnectHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = DisconnectHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
        try {
            List<ZosConnectServerNode> servers = DisconnectHandler.getSelectedElementsOfType(ZosConnectServerNode.class);
            for (ZosConnectServerNode server : servers) {
                ConnectionProfile profile = server.getConnectionProfile();
                AdminApiConnectionUtil.doDisconnect((ConnectionProfile)profile);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e, (boolean)false);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        List<ZosConnectServerNode> servers = DisconnectHandler.getSelectedElementsOfType(ZosConnectServerNode.class);
        for (ZosConnectServerNode server : servers) {
            if (server.getConnectedState()) continue;
            return false;
        }
        return super.isEnabled();
    }
}

