/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.controllers.api.ApiDeployController;
import com.ibm.zosconnect.ui.dialogs.DeployApiDialog;
import com.ibm.zosconnect.ui.jobs.RefreshApisJob;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeployApiHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = DeployApiHandler.class.getName();
    private static final String NL = System.getProperty("line.separator");
    private IConnectionService connectionService = ConnectionsPlugin.getDefault().getConnectionService();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
        List<IProject> projects = DeployApiHandler.getSelectedElementsOfType(IProject.class, true);
        if (!ListUtilz.isEmpty(projects)) {
            this.displayDeployApiDialog(projects);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public void displayDeployApiDialog(IProject project) {
        ZCeeUILogger.entering((String)TAG, (String)"displayDeployApiDialog(project={0})", (Object[])new Object[]{project});
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(project);
        this.displayDeployApiDialog(projects);
        ZCeeUILogger.exiting((String)TAG, (String)"displayDeployApiDialog(IProject)", (Object[])new Object[0]);
    }

    public void displayDeployApiDialog(final List<IProject> projects) {
        ZCeeUILogger.entering((String)TAG, (String)"displayDeployApiDialog(projects={0})", (Object[])new Object[]{projects});
        IConnectable connectable = this.connectionService.getConnectable("com.ibm.zosconnect.ui.connections.category.adminapi");
        IConnection connection = connectable.getConnection();
        if (connection == null) {
            this.openDialog(projects);
            return;
        }
        ZosConnectServerNav nav = ZosConnectServerNav.getView();
        ZosConnectServerNode server = nav.getServer(connection);
        final RefreshApisJob refreshJob = new RefreshApisJob(server);
        refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (refreshJob.getException() == null) {
                            DeployApiHandler.this.openDialog(projects);
                        }
                    }
                });
            }
        });
        refreshJob.schedule();
        ZCeeUILogger.exiting((String)TAG, (String)"displayDeployApiDialog(List<IProject>)", (Object[])new Object[0]);
    }

    private void openDialog(List<IProject> projects) {
        ZCeeUILogger.entering((String)TAG, (String)"openDialog(projects={0})", (Object[])new Object[]{projects});
        boolean canDeploy = true;
        try {
            if (!this.checkDeployDirtyProjects(projects)) {
                canDeploy = false;
            }
            if (canDeploy && !this.checkDeployErrorMarkers(projects)) {
                canDeploy = false;
            }
            if (canDeploy) {
                ApiDeployController controller = new ApiDeployController(projects);
                DeployApiDialog dialog = new DeployApiDialog(XSwt.getActiveShell(), controller);
                dialog.open();
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        ZCeeUILogger.exiting((String)TAG, (String)"openDialog(List<IProject>)", (Object[])new Object[0]);
    }

    public boolean isEnabled() {
        return true;
    }

    private boolean checkDeployErrorMarkers(List<IProject> projects) throws CoreException {
        boolean checkDeploy = true;
        ArrayList<IMarker> duplicatePathsMarkers = new ArrayList<IMarker>();
        ArrayList<Status> childStatus = new ArrayList<Status>();
        for (IProject project : projects) {
            IFile packageXmlFile = project.getFile("package.xml");
            duplicatePathsMarkers.addAll(Arrays.asList(packageXmlFile.findMarkers("com.ibm.zosconnect.ui.apiDuplicatePathsProblemType", true, 2)));
        }
        if (duplicatePathsMarkers != null && duplicatePathsMarkers.size() > 0) {
            checkDeploy = false;
            for (IMarker currMarker : duplicatePathsMarkers) {
                String projectName = currMarker.getAttribute("projectName").toString();
                String message = currMarker.getAttribute("message").toString();
                String nextLine = projectName + Xlat.colon() + " " + message;
                childStatus.add(new Status(4, "com.ibm.zosconnect.ui.common", nextLine));
            }
            MultiStatus status = new MultiStatus("com.ibm.zosconnect.ui.common", 4, childStatus.toArray(new IStatus[0]), null, null);
            ErrorDialog.openError((Shell)XSwt.getActiveShell(), (String)Xlat.label((String)"DEPLOY_API_DLG_ERROR_TITLE"), (String)Xlat.error((String)"DEPLOY_UNDEPLOYABLE_PROJECTS"), (IStatus)status);
        }
        return checkDeploy;
    }

    private boolean checkDeployDirtyProjects(List<IProject> projects) throws CoreException {
        List dirtyProjects = WorkspaceUtil.getDirtyProjects(projects);
        if (dirtyProjects == null || dirtyProjects.isEmpty()) {
            return true;
        }
        boolean checkDeploy = true;
        Object[] projectNames = new String[dirtyProjects.size()];
        int i = 0;
        while (i < dirtyProjects.size()) {
            projectNames[i] = ((IProject)dirtyProjects.get(i)).getName();
            ++i;
        }
        if (dirtyProjects.size() == 1) {
            MessageDialog dialog = new MessageDialog(XSwt.getActiveShell(), Xlat.label((String)"DEPLOY_API_DLG_ERROR_TITLE"), MessageDialog.getDefaultImage(), Xlat.error((String)"DEPLOY_CONFIRM_API_DIRTY", (String[])new String[]{projectNames[0]}), 4, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
            checkDeploy = dialog.open() == 0;
        } else {
            StringBuilder message = new StringBuilder();
            message.append(Xlat.error((String)"DEPLOY_CONFIRM_APIS_DIRTY"));
            message.append(NL);
            message.append(NL);
            message.append(Xlat.error((String)"DEPLOY_DIRTY_API_PROJECTS", (String[])new String[]{StringUtils.join((Object[])projectNames, (String)", ")}));
            MessageDialog dialog = new MessageDialog(XSwt.getActiveShell(), Xlat.label((String)"DEPLOY_API_DLG_ERROR_TITLE"), MessageDialog.getDefaultImage(), message.toString(), 4, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
            checkDeploy = dialog.open() == 0;
        }
        return checkDeploy;
    }
}

