/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.menu.handlers;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.jobs.ConnectJob;
import com.ibm.zosconnect.ui.menu.handlers.ZosConnectHandler;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConnectHandler
extends ZosConnectHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ConnectHandler.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<ZosConnectServerNode> servers;
        block5: {
            block4: {
                ZCeeUILogger.entering((String)TAG, (String)"execute(event={0})", (Object[])new Object[]{event});
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                if (part instanceof ZosConnectServerNav) break block4;
                return null;
            }
            servers = ConnectHandler.getSelectedElementsOfType(ZosConnectServerNode.class);
            if (!ListUtilz.isEmpty(servers)) break block5;
            return null;
        }
        try {
            ZosConnectServerNode firstServer = servers.get(0);
            ConnectJob connectJob = new ConnectJob(firstServer, servers);
            connectJob.setJobGroup(firstServer.getJobGroup());
            connectJob.schedule();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e, (boolean)true);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"execute(ExecutionEvent)", (Object[])new Object[0]);
        return null;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        ZCeeUILogger.entering((String)TAG, (String)"isEnabled()", (Object[])new Object[0]);
        List<ZosConnectServerNode> servers = ConnectHandler.getSelectedElementsOfType(ZosConnectServerNode.class);
        Iterator<ZosConnectServerNode> serversIt = servers.iterator();
        if (serversIt.hasNext()) {
            enabled = true;
            while (enabled && serversIt.hasNext()) {
                ZosConnectServerNode server = serversIt.next();
                if (!server.getConnectedState()) continue;
                enabled = false;
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"{0}:isEnabled()", (Object[])new Object[]{enabled});
        return enabled;
    }
}

