/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.jobs;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.connections.AdminApiConnectionUtil;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApi;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.connections.utils.ZCeeAdminApiUtils;
import com.ibm.zosconnect.ui.jobs.AbstractApisJob;
import com.ibm.zosconnect.ui.model.ZosConnectApiNode;
import com.ibm.zosconnect.ui.model.ZosConnectApisFolder;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import com.ibm.zosconnect.ui.model.ZosConnectTreeObject;
import com.ibm.zosconnect.ui.nav.ZosConnectServerNav;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class RefreshApisJob
extends AbstractApisJob {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = RefreshApisJob.class.getName();
    private ZosConnectServerNode server;
    private List<ZosConnectTreeObject> apiNodes;
    private boolean addedApisFolder;
    private ZosConnectApisFolder apisFolder;

    public RefreshApisJob(ZosConnectServerNode server) {
        super(server, Xlat.description((String)"STATUS_REFRESHING_APIS", (String[])new String[]{AdminApiConnectionUtil.getServerNameWithHostAndPort((ConnectionProfile)server.getConnectionProfile())}));
        this.server = server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block32: {
            block31: {
                IZCeeAdminApiConnection connection;
                block30: {
                    block29: {
                        ZCeeUILogger.entering((String)TAG, (String)"run(monitor={0})", (Object[])new Object[]{monitor});
                        this.addedApisFolder = false;
                        this.apisFolder = null;
                        ConnectionProfile profile = this.server.getConnectionProfile();
                        connection = ZCeeAdminApiUtils.getConnection((ConnectionProfile)profile, (boolean)false);
                        if (connection != null && connection.isConnected()) break block29;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        try {
                            if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                                this.apisFolder.setRefreshing(false);
                                this.apisFolder.setChildren(this.apiNodes);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ZosConnectServerNav nav = ZosConnectServerNav.getView();
                                        if (nav != null) {
                                            nav.refreshServerViewNested(RefreshApisJob.this.apisFolder);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Throwable t) {
                            ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                        }
                        this.server.releaseLock(TAG);
                        monitor.done();
                        return iStatus;
                    }
                    if (this.server.acquireLock(TAG)) break block30;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    try {
                        if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                            this.apisFolder.setRefreshing(false);
                            this.apisFolder.setChildren(this.apiNodes);
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    catch (Throwable t) {
                        ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                    }
                    this.server.releaseLock(TAG);
                    monitor.done();
                    return iStatus;
                }
                try {
                    try {
                        monitor.worked(50);
                        this.apisFolder = (ZosConnectApisFolder)ArrayUtilz.getFirstElementOfType((Object[])this.server.getChildren(), ZosConnectApisFolder.class);
                        if (this.apisFolder == null) {
                            this.apisFolder = new ZosConnectApisFolder(this.server);
                            this.server.addChild(this.apisFolder);
                            this.addedApisFolder = true;
                        }
                        this.apisFolder.setRefreshing(true);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosConnectServerNav nav = ZosConnectServerNav.getView();
                                if (nav != null) {
                                    if (RefreshApisJob.this.addedApisFolder) {
                                        nav.refreshServerView(RefreshApisJob.this.server);
                                    } else {
                                        nav.refreshServerViewNested(RefreshApisJob.this.apisFolder);
                                    }
                                }
                            }
                        });
                        List apiList = connection.getApisWithDetails();
                        if (apiList != null && !apiList.isEmpty()) {
                            this.apiNodes = new ArrayList<ZosConnectTreeObject>(Math.max(10, apiList.size()));
                            for (Pair apiPair : apiList) {
                                ZosConnectApi api = (ZosConnectApi)apiPair.getLeft();
                                ZosConnectApiDetail apiDetail = (ZosConnectApiDetail)apiPair.getRight();
                                ZosConnectApiNode apiNode = new ZosConnectApiNode(api.getName(), this.apisFolder);
                                apiNode.setApi(api);
                                apiNode.setApiDetail(apiDetail);
                                apiNode.setParent(this.apisFolder);
                                this.apiNodes.add(apiNode);
                            }
                        } else {
                            this.apiNodes = new ArrayList<ZosConnectTreeObject>();
                        }
                        break block31;
                    }
                    catch (Exception e) {
                        this.setException(e);
                        this.apisFolder.removeChildren();
                        if (e instanceof ZosConnectUIException && ((ZosConnectUIException)e).isCausedByConnectivityException()) {
                            AdminApiConnectionUtil.doDisconnect((ConnectionProfile)this.server.getConnectionProfile());
                        }
                        try {
                            for (Job activeJob : this.getJobGroup().getActiveJobs()) {
                                if (!activeJob.belongsTo((Object)TAG)) continue;
                                activeJob.cancel();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ZCeeUILogger.error((Throwable)e);
                    ZCeeErrorDialog.openError((Exception)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                            this.apisFolder.setRefreshing(false);
                            this.apisFolder.setChildren(this.apiNodes);
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    catch (Throwable t) {
                        ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                    }
                    this.server.releaseLock(TAG);
                    monitor.done();
                    throw throwable;
                }
                try {
                    if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                        this.apisFolder.setRefreshing(false);
                        this.apisFolder.setChildren(this.apiNodes);
                        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (Throwable t) {
                    ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
                }
                this.server.releaseLock(TAG);
                monitor.done();
                break block32;
            }
            try {
                if (this.server.getConnection() != null && this.server.getConnection().isConnected()) {
                    this.apisFolder.setRefreshing(false);
                    this.apisFolder.setChildren(this.apiNodes);
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Throwable t) {
                ZCeeUILogger.info((String)t.getMessage(), (Object[])new Object[0]);
            }
            this.server.releaseLock(TAG);
            monitor.done();
        }
        ZCeeUILogger.entering((String)TAG, (String)"run(IProgressMonitor)", (Object[])new Object[0]);
        return Status.OK_STATUS;
    }

    @Override
    public String getFamily() {
        return TAG;
    }
}

