/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.jobs;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.preferences.ZosConnectPreferencesWrapper;
import com.ibm.zosconnect.ui.common.projects.ZCeeProjectConstants;
import com.ibm.zosconnect.ui.common.util.FileUtilz;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiStatus;
import com.ibm.zosconnect.ui.connections.utils.ZCeeAdminApiUtils;
import com.ibm.zosconnect.ui.controllers.api.ApiArchiveExportController;
import com.ibm.zosconnect.ui.controllers.api.ApiDeployController;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.jetty.SwaggerUIController;
import com.ibm.zosconnect.ui.dialogs.DeployApiResultsDialog;
import com.ibm.zosconnect.ui.jobs.AbstractApisJob;
import com.ibm.zosconnect.ui.jobs.RefreshApisJob;
import com.ibm.zosconnect.ui.model.ZosConnectDeployResult;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class DeployApisJob
extends AbstractApisJob {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG = DeployApisJob.class.getName();
    private ZosConnectPreferencesWrapper preferences = new ZosConnectPreferencesWrapper();
    private List<IProject> projects;
    private IZCeeAdminApiConnection connection;
    private ApiDeployController controller;
    private final String aarFileExt = ".aar";
    private ZosConnectServerNode server;
    private SwaggerUIController swaggerUI = SwaggerUIController.getSingletonInstance();

    public DeployApisJob(ZosConnectServerNode server, List<IProject> projects, IZCeeAdminApiConnection connection, ApiDeployController controller) {
        super(server, Xlat.label((String)"DEPLOY_API_PROGRESS_TITLE"));
        this.server = server;
        this.projects = projects;
        this.connection = connection;
        this.controller = controller;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        ZCeeUILogger.entering((String)DeployApisJob.TAG, (String)"run(monitor={0})", (Object[])new Object[]{monitor});
        deployResults = new Vector<ZosConnectDeployResult>();
        apiModelControllersMap = this.controller.getApiModelControllersMap();
        configuration = this.connection.getConfiguration();
        try {
            monitor.beginTask(Xlat.label((String)"DEPLOY_API_PROGRESS_TASK", (String[])new String[]{ZCeeAdminApiUtils.getServerNameWithHostAndPort((ConnectionConfiguration)configuration)}), this.projects.size() * 2);
            i = 0;
            if (true) ** GOTO lbl83
        }
        catch (Exception e) {
            this.setException(e);
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
            v0 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
            if (!securityError) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RefreshApisJob refreshApis = new RefreshApisJob(DeployApisJob.this.server);
                        refreshApis.setJobGroup(DeployApisJob.this.getJobGroup());
                        refreshApis.schedule();
                    }
                });
            } else {
                ZCeeUILogger.info((String)"skipped refreshing apis due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
            }
            monitor.done();
        }
        catch (Throwable var16_23) {
            v1 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
            if (!securityError) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            } else {
                ZCeeUILogger.info((String)"skipped refreshing apis due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
            }
            monitor.done();
            throw var16_23;
        }
lbl32:
        // 1 sources

        while (true) {
            v2 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
            if (!securityError) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            } else {
                ZCeeUILogger.info((String)"skipped refreshing apis due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
            }
            monitor.done();
            return var17_18;
        }
        {
            block21: {
                do {
                    proj = this.projects.get(i);
                    monitor.subTask(Xlat.label((String)"DEPLOY_API_PROGRESS_SUBTASK", (String[])new String[]{"\"" + proj.getName() + "\"" + Xlat.colon(), Integer.toString(i + 1), Integer.toString(this.projects.size())}));
                    WorkspaceUtil.clearAPIDeployProblemMarkers((IResource)proj);
                    outTempFile = FileUtilz.getTempFile((String)".aar");
                    outFileName = outTempFile.getAbsolutePath();
                    apiModelController = (ApiModelController)apiModelControllersMap.get(proj.getName());
                    apiExportController = new ApiArchiveExportController(proj);
                    apiExportController.setOutputFileName(outFileName);
                    apiExportController.createZipFile();
                    apiBytes = apiExportController.getZipFileBytes();
                    outTempFile.delete();
                    monitor.worked(1);
                    apiDetail = null;
                    uiException = null;
                    try {
                        exists = (Boolean)proj.getSessionProperty(ZCeeProjectConstants.PROP_API_EXISTS_ON_SERVER);
                        apiName = apiModelController.getApiTitle();
                        if (exists.booleanValue()) {
                            if (this.preferences.getStopAPIOnUpdate()) {
                                this.connection.stopApi(apiName);
                            }
                            apiDetail = this.preferences.getDeployAPIStarted() != false ? this.connection.updateApi(apiName, apiBytes, ZosConnectApiStatus.STARTED) : this.connection.updateApi(apiName, apiBytes, ZosConnectApiStatus.STOPPED);
                            this.swaggerUI.updateBrowser(apiDetail, this.connection);
                        } else {
                            apiDetail = this.preferences.getDeployAPIStarted() ? this.connection.createApi(apiBytes, ZosConnectApiStatus.STARTED) : this.connection.createApi(apiBytes, ZosConnectApiStatus.STOPPED);
                        }
                    }
                    catch (ZosConnectUIException e) {
                        ZCeeUILogger.error((Throwable)e);
                        WorkspaceUtil.addAPIDeployProblemMarker((IResource)proj, (ZosConnectUIException)e);
                        uiException = e;
                        this.setException((Exception)uiException);
                    }
                    deployResults.add(new ZosConnectDeployResult(apiModelController.getApiTitle(), apiModelController.getApiVersion(), apiModelController.getApiBasePath(), apiDetail, uiException));
                    monitor.worked(1);
                    if (uiException != null && uiException.isCausedBySecurityException()) break block21;
                    ++i;
lbl83:
                    // 2 sources

                    if (i >= this.projects.size()) break block21;
                } while (!monitor.isCanceled());
                var17_18 = Status.CANCEL_STATUS;
                ** continue;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DeployApiResultsDialog dialog = new DeployApiResultsDialog(deployResults, XSwt.getActiveShell(), DeployApisJob.this.connection);
                    dialog.open();
                }
            });
        }
        v3 = securityError = this.getException() instanceof ZosConnectUIException != false && ((ZosConnectUIException)this.getException()).isCausedBySecurityException() != false;
        if (!securityError) {
            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
        } else {
            ZCeeUILogger.info((String)"skipped refreshing apis due to security error: {0}.", (Throwable)this.getException(), (Object[])new Object[0]);
        }
        monitor.done();
        ZCeeUILogger.exiting((String)DeployApisJob.TAG, (String)"run(IProgressMonitor)", (Object[])new Object[0]);
        return Status.OK_STATUS;
    }

    @Override
    public String getFamily() {
        return TAG;
    }
}

