/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.jobs;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.zosconnect.ui.common.connections.AdminApiConnectionUtil;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.jobs.AbstractApisJob;
import com.ibm.zosconnect.ui.model.ZosConnectServerNode;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ConnectJob
extends AbstractApisJob {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ConnectJob.class.getName();
    private ZosConnectServerNode firstServer;
    private List<ZosConnectServerNode> servers;

    public ConnectJob(ZosConnectServerNode firstServer, List<ZosConnectServerNode> servers) {
        super(firstServer, Xlat.label((String)"CONNECT_PROGRESS_TITLE"));
        this.firstServer = firstServer;
        this.servers = servers;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        block10: {
            block11: {
                ZCeeUILogger.entering((String)TAG, (String)"run(monitor={0})", (Object[])new Object[]{monitor});
                try {
                    monitor.beginTask(Xlat.label((String)"CONNECT_PROGRESS_TASK"), this.servers.size());
                    int serverIdx = 0;
                    while (serverIdx < this.servers.size()) {
                        if (monitor.isCanceled()) {
                            iStatus = Status.CANCEL_STATUS;
                            break block10;
                        }
                        ZosConnectServerNode server = this.servers.get(serverIdx);
                        monitor.subTask(Xlat.label((String)"CONNECT_PROGRESS_SUBTASK", (String[])new String[]{"\"" + AdminApiConnectionUtil.getServerNameWithHostAndPort((ConnectionProfile)server.getConnectionProfile()) + "\"" + Xlat.colon(), Integer.toString(serverIdx + 1), Integer.toString(this.servers.size())}));
                        ConnectionProfile profile = server.getConnectionProfile();
                        AdminApiConnectionUtil.doConnect((ConnectionProfile)profile, (boolean)false);
                        monitor.worked(1);
                        ++serverIdx;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                {
                    catch (Exception e) {
                        this.setException(e);
                        try {
                            for (Job activeJob : this.firstServer.getJobGroup().getActiveJobs()) {
                                if (!activeJob.belongsTo((Object)TAG)) continue;
                                activeJob.cancel();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ZCeeUILogger.error((Throwable)e);
                    ZCeeErrorDialog.openError((Exception)e);
                    monitor.done();
                    break block11;
                    break;
                }
                monitor.done();
            }
            ZCeeUILogger.exiting((String)TAG, (String)"run(IProgressMonitor)", (Object[])new Object[0]);
            return Status.OK_STATUS;
        }
        monitor.done();
        return iStatus;
    }

    @Override
    public String getFamily() {
        return TAG;
    }
}

