/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors.listeners;

import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZCeeProjectConstants;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.editors.listeners.ApiProjectChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ApiProjectChangeReporter
implements IResourceChangeListener,
ZCeeProjectConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IProject project;
    private ApiProjectChangeListener listener;
    private PathType pathType;

    public ApiProjectChangeReporter(IProject project, PathType pathType, ApiProjectChangeListener listener) {
        this.project = project;
        this.pathType = pathType;
        this.listener = listener;
    }

    public void register() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void unregister() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            switch (event.getType()) {
                case 1: {
                    event.getDelta().accept((IResourceDeltaVisitor)new ApiProjectVisitor());
                }
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    private class ApiProjectVisitor
    implements IResourceDeltaVisitor {
        private ApiProjectVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            boolean inApiFolder = false;
            boolean isDesiredPathType = false;
            boolean isMappingXmlFile = false;
            MethodValues methodValue = null;
            IResource res = delta.getResource();
            if (res == null || res.getProject() != ApiProjectChangeReporter.this.project) {
                return true;
            }
            IPath resProjRelPath = res.getProjectRelativePath();
            if (resProjRelPath.segmentCount() > 0 && "api".equals(resProjRelPath.segment(0))) {
                inApiFolder = true;
            }
            if (inApiFolder && ApiProjectChangeReporter.this.pathType != null && resProjRelPath.segmentCount() > 3) {
                String apiPath1 = "/" + String.valueOf(resProjRelPath.removeFirstSegments(1).removeLastSegments(2));
                String apiPath2 = OpenApi2xUtil.stripQueryParameters((String)ApiProjectChangeReporter.this.pathType.getRelativePath());
                isDesiredPathType = StringUtils.equals((CharSequence)apiPath1, (CharSequence)apiPath2);
            }
            if (isDesiredPathType && res instanceof IFile && "mapping.xml".equals(res.getName())) {
                isMappingXmlFile = true;
                methodValue = MethodValues.valueOf((String)resProjRelPath.segment(resProjRelPath.segmentCount() - 2));
            }
            if (isMappingXmlFile) {
                switch (delta.getKind()) {
                    case 1: {
                        ApiProjectChangeReporter.this.listener.serviceMappingCreated((IFile)res, ApiProjectChangeReporter.this.pathType, methodValue);
                        break;
                    }
                    case 2: {
                        ApiProjectChangeReporter.this.listener.serviceMappingDeleted((IFile)res, ApiProjectChangeReporter.this.pathType, methodValue);
                        break;
                    }
                    case 4: {
                        ApiProjectChangeReporter.this.listener.serviceMappingChanged((IFile)res, ApiProjectChangeReporter.this.pathType, methodValue);
                    }
                }
            }
            return true;
        }
    }
}

