/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors.listeners;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.Listener2;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponseComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorPathComposite;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ApiEditorFocusChangeListener
extends Listener2 {
    private FormToolkit toolkit;
    private ApiEditorPathComposite selPath = null;
    private ApiEditorMethodComposite selMethod = null;
    private ApiEditorMethodResponseComposite selResponse = null;
    private boolean selPathChanged = false;
    private boolean selMethodChanged = false;
    private boolean selResponseChanged = false;
    private static final Color colorPath = XSwt.getColor((RGB)new RGB(240, 240, 240));
    private static final Color colorMethod = XSwt.getColor((RGB)new RGB(220, 220, 220));
    private static final Color colorResponse = XSwt.getColor((RGB)new RGB(200, 200, 200));
    private Color colorDefault;

    public ApiEditorFocusChangeListener(FormToolkit toolkit, Control owner) {
        super(owner);
        this.toolkit = toolkit;
    }

    public void dispose() {
    }

    public void handleEvent(Event event, Widget widget, Control owner) throws Exception {
        if (!(event.widget instanceof Control)) {
            return;
        }
        Control source = (Control)event.widget;
        if (!XSwt.isPainted((Control)source) || !this.isControlInOwner(source)) {
            return;
        }
        this.colorDefault = this.toolkit.getColors().getBackground();
        ApiEditorPathComposite newSelPath = this.getParentPathComposite(source);
        ApiEditorMethodComposite newSelMethod = this.getParentMethodComposite(source);
        ApiEditorMethodResponseComposite newSelResponse = this.getParentResponseComposite(source);
        if (newSelPath == null && newSelMethod == null && newSelResponse == null) {
            return;
        }
        ApiEditorPathComposite oldSelPath = this.selPath;
        this.selPathChanged = false;
        if (oldSelPath == null && newSelPath != null) {
            this.selPathChanged = true;
        } else if (oldSelPath != null && oldSelPath != newSelPath) {
            this.selPathChanged = true;
        }
        if (this.selPathChanged) {
            this.selPath = newSelPath;
            this.handleSelPathChanged(oldSelPath, newSelPath);
        }
        ApiEditorMethodComposite oldSelMethod = this.selMethod;
        this.selMethodChanged = false;
        if (oldSelMethod == null && newSelMethod != null) {
            this.selMethodChanged = true;
        } else if (oldSelMethod != null && oldSelMethod != newSelMethod && source != oldSelMethod.getLogicalParent().getLogicalParent().getImgAddMethod() && source != oldSelMethod.getLogicalParent().getLogicalParent().getImgTwistie() && (newSelMethod == null || source != newSelMethod.getImgMethodRemove())) {
            this.selMethodChanged = true;
        }
        if (this.selMethodChanged) {
            this.selMethod = newSelMethod;
            this.handleSelMethodChanged(oldSelMethod, newSelMethod);
        }
        ApiEditorMethodResponseComposite oldSelResponse = this.selResponse;
        this.selResponseChanged = false;
        if (oldSelResponse == null && newSelResponse != null) {
            this.selResponseChanged = true;
        } else if (oldSelResponse != null && oldSelResponse != newSelResponse && source != oldSelResponse.getLogicalParent().getImgAddResponse() && source != oldSelResponse.getLogicalParent().getImgMethodResponsesTwistie() && (newSelResponse == null || source != newSelResponse.getImgMethodResponseRemove())) {
            this.selResponseChanged = true;
        }
        if (this.selResponseChanged) {
            this.selResponse = newSelResponse;
            this.handleSelResponseChanged(oldSelResponse, newSelResponse);
        }
    }

    private void handleSelPathChanged(ApiEditorPathComposite oldSelPath, ApiEditorPathComposite newSelPath) {
        if (XSwt.isNotDisposed((Control)newSelPath)) {
            newSelPath.setBackground(colorPath);
            for (Control control : XSwt.getContentExclude((Composite)newSelPath, (Class[])new Class[]{Button.class, Text.class, StyledText.class})) {
                control.setBackground(colorPath);
            }
        }
        if (XSwt.isNotDisposed((Control)oldSelPath)) {
            oldSelPath.setBackground(this.colorDefault);
            for (Control control : XSwt.getContentExclude((Composite)oldSelPath, (Class[])new Class[]{Button.class, Text.class, StyledText.class})) {
                control.setBackground(this.colorDefault);
            }
        }
    }

    private void handleSelMethodChanged(ApiEditorMethodComposite oldSelMethod, ApiEditorMethodComposite newSelMethod) {
        if (XSwt.isNotDisposed((Control)newSelMethod)) {
            newSelMethod.setBackground(colorMethod);
            for (Control control : XSwt.getContentExclude((Composite)newSelMethod, (Class[])new Class[]{Button.class, Text.class, StyledText.class, ControlDecoration.class})) {
                control.setBackground(colorMethod);
            }
        }
        if (XSwt.isNotDisposed((Control)oldSelMethod)) {
            Color background = this.selPathChanged ? this.colorDefault : colorPath;
            oldSelMethod.setBackground(background);
            for (Control control : XSwt.getContentExclude((Composite)oldSelMethod, (Class[])new Class[]{Button.class, Text.class, StyledText.class, ControlDecoration.class})) {
                control.setBackground(background);
            }
        }
    }

    private void handleSelResponseChanged(ApiEditorMethodResponseComposite oldSelResponse, ApiEditorMethodResponseComposite newSelResponse) {
        if (XSwt.isNotDisposed((Control)newSelResponse)) {
            newSelResponse.setBackground(colorResponse);
            for (Control control : XSwt.getContentExclude((Composite)newSelResponse, (Class[])new Class[]{Button.class, Text.class, StyledText.class})) {
                control.setBackground(colorResponse);
            }
        }
        if (XSwt.isNotDisposed((Control)oldSelResponse)) {
            Color background = this.selPathChanged ? this.colorDefault : colorMethod;
            oldSelResponse.setBackground(background);
            for (Control control : XSwt.getContentExclude((Composite)oldSelResponse, (Class[])new Class[]{Button.class, Text.class, StyledText.class})) {
                control.setBackground(background);
            }
        }
    }

    private boolean isControlInOwner(Control control) {
        boolean retVal = false;
        if (!XSwt.isDisposed((Control)control) && XSwt.isPainted((Control)control)) {
            while (control != null && control != this.getOwner()) {
                control = control.getParent();
            }
            if (control == this.getOwner()) {
                retVal = true;
            }
        }
        return retVal;
    }

    private ApiEditorPathComposite getParentPathComposite(Control control) {
        ApiEditorPathComposite retVal = null;
        if (!XSwt.isDisposed((Control)control) && XSwt.isPainted((Control)control)) {
            while (control != null && !(control instanceof ApiEditorPathComposite) && control != this.getOwner()) {
                control = control.getParent();
            }
            if (control instanceof ApiEditorPathComposite) {
                retVal = (ApiEditorPathComposite)control;
            }
        }
        return retVal;
    }

    private ApiEditorMethodComposite getParentMethodComposite(Control control) {
        ApiEditorMethodComposite retVal = null;
        if (!XSwt.isDisposed((Control)control) && XSwt.isPainted((Control)control)) {
            while (control != null && !(control instanceof ApiEditorMethodComposite) && control != this.getOwner()) {
                control = control.getParent();
            }
            if (control instanceof ApiEditorMethodComposite) {
                retVal = (ApiEditorMethodComposite)control;
            }
        }
        return retVal;
    }

    private ApiEditorMethodResponseComposite getParentResponseComposite(Control control) {
        ApiEditorMethodResponseComposite retVal = null;
        if (!XSwt.isDisposed((Control)control) && XSwt.isPainted((Control)control)) {
            while (control != null && !(control instanceof ApiEditorMethodResponseComposite) && control != this.getOwner()) {
                control = control.getParent();
            }
            if (control instanceof ApiEditorMethodResponseComposite) {
                retVal = (ApiEditorMethodResponseComposite)control;
            }
        }
        return retVal;
    }

    public boolean isSelPathChanged() {
        return this.selPathChanged;
    }

    public void setSelPathChanged(boolean selPathChanged) {
        this.selPathChanged = selPathChanged;
    }

    public ApiEditorPathComposite getSelPath() {
        return this.selPath;
    }

    public ApiEditorMethodComposite getSelMethod() {
        return this.selMethod;
    }

    public ApiEditorMethodResponseComposite getSelResponse() {
        return this.selResponse;
    }
}

