/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors.listeners;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorFocusChangeListener;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;

public class ApiEditorCommandServiceListener
implements IExecutionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ApiEditorCommandServiceListener.class.getName();
    public static final String CommandID_Save = "org.eclipse.ui.file.save";
    public static final String CommandID_SaveAll = "org.eclipse.ui.file.saveAll";
    private ZosConnectApiEditor apiEditor;

    public ApiEditorCommandServiceListener(ZosConnectApiEditor apiEditor) {
        this.apiEditor = apiEditor;
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        ZCeeUILogger.entering((String)TAG, (String)"preExecute(commandId={0},event={1})", (Object[])new Object[]{commandId, event});
        if (CommandID_Save.equals(commandId) || CommandID_SaveAll.equals(commandId)) {
            try {
                ApiEditorFormPage formPage = this.apiEditor.getApiFormPage();
                ApiEditorFocusChangeListener focusListener = formPage.getApiEditorFocusChangeListener();
                formPage.setSelectedPathPriorToSave(focusListener.getSelPath());
                formPage.setSelectedMethodPriorToSave(focusListener.getSelMethod());
                formPage.setSelectedResponsePriorToSave(focusListener.getSelResponse());
            }
            catch (Exception e) {
                ZCeeUILogger.info((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"preExecute(String,ExecutionEvent)", (Object[])new Object[0]);
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
        ZCeeUILogger.entering((String)TAG, (String)"postExecuteSuccess(commandId={0},returnValue={1})", (Object[])new Object[]{commandId, returnValue});
        if (CommandID_Save.equals(commandId) || CommandID_SaveAll.equals(commandId)) {
            try {
                ApiEditorFormPage formPage = this.apiEditor.getApiFormPage();
                formPage.setSelectedPathPriorToSave(null);
                formPage.setSelectedMethodPriorToSave(null);
                formPage.setSelectedResponsePriorToSave(null);
            }
            catch (Exception e) {
                ZCeeUILogger.info((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        ZCeeUILogger.exiting((String)TAG, (String)"postExecuteSuccess(String,Object)", (Object[])new Object[0]);
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
        ZCeeUILogger.entering((String)TAG, (String)"postExecuteFailure(commandId={0},exception={1})", (Object[])new Object[]{commandId, exception});
        try {
            if (CommandID_Save.equals(commandId) || CommandID_SaveAll.equals(commandId)) {
                ApiEditorFormPage formPage = this.apiEditor.getApiFormPage();
                formPage.setSelectedPathPriorToSave(null);
                formPage.setSelectedMethodPriorToSave(null);
                formPage.setSelectedResponsePriorToSave(null);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.info((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        ZCeeUILogger.exiting((String)TAG, (String)"postExecuteFailure(String,ExecutionException)", (Object[])new Object[0]);
    }

    public void notHandled(String commandId, NotHandledException exception) {
        ZCeeUILogger.entering((String)TAG, (String)"notHandled(commandId={0},exception={1})", (Object[])new Object[]{commandId, exception});
        ZCeeUILogger.exiting((String)TAG, (String)"notHandled(String,NotHandledException)", (Object[])new Object[0]);
    }
}

