/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.ApiDocType;
import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.service.MappingMessageType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.mapping.service.ZosConnectServiceMapping;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.MappingFileUtilz;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.validation.ApiResponseValidationProblem;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.MappingRootController;
import com.ibm.zosconnect.ui.controllers.api.OpenApi2xController;
import com.ibm.zosconnect.ui.controllers.api.RelativePathBean;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.controllers.visitors.OpenApi2xVisitor;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponseComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponsesComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodsComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorPathComposite;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorCommandServiceListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorEventListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class ZosConnectApiEditor
extends FormEditor
implements IGotoMarker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String EDITOR_ID = "com.ibm.zosconnect.ui.apieditor";
    private static String NL = System.getProperty("line.separator");
    private ApiEditorFormPage apiFormPage;
    private ApiProjectController apiProjectController;
    private ApiModelController apiModelController;
    private OpenApi2xController openApi2xController;
    private ResourceTracker resourceTracker;
    private List<ApiEditorEventListener> editorEventListeners;
    private ApiEditorCommandServiceListener commandServiceListener;
    private IFile apiFile;
    private ISchedulingRule modifyRule = null;
    private ArrayList<RelativePathBean> relPathBeans;
    private boolean hasCapabilityErrors = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        String unknownCapabilities = Xlat.colon() + NL;
        boolean haveCapabilityErrors = false;
        try {
            this.apiFile = ((IFileEditorInput)input).getFile();
            IProject project = this.apiFile.getProject();
            IMarker[] capMarkers = project.findMarkers("com.ibm.zosconnect.ui.capabilitiesproblem", false, 0);
            int i = 0;
            while (i < capMarkers.length) {
                unknownCapabilities = unknownCapabilities + String.valueOf(capMarkers[i].getAttribute("message")) + NL;
                ++i;
            }
            if (capMarkers.length > 0) {
                haveCapabilityErrors = true;
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        if (haveCapabilityErrors) {
            String errorMsg = Xlat.error((String)"UNKNOWN_CAPABILITY_EDITOR", (String[])new String[]{unknownCapabilities});
            Status status = new Status(4, "com.ibm.zosconnect.ui", errorMsg);
            this.hasCapabilityErrors = true;
            throw new PartInitException((IStatus)status);
        }
        super.init(site, input);
        this.setTitleImage(XImg.icon((String)"zosconnect_api_16x16.gif"));
    }

    protected void setInput(IEditorInput input) {
        IFile editorInputFile;
        if (this.getEditorInput() != null) {
            editorInputFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            editorInputFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            editorInputFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            editorInputFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.setPartName(editorInputFile.getName());
            this.firePropertyChange(258);
            this.firePropertyChange(1);
        }
        this.apiFile = ((IFileEditorInput)input).getFile();
        try {
            this.apiProjectController = new ApiProjectController(this.apiFile.getProject());
            this.apiModelController = new ApiModelController(this.apiFile, this.apiProjectController);
            this.openApi2xController = new OpenApi2xController(this.apiProjectController, this.apiModelController);
            this.apiProjectController.setApiModelController(this.apiModelController);
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.modifyRule = ruleFactory.modifyRule((IResource)this.apiProjectController.getProject());
            this.commandServiceListener = new ApiEditorCommandServiceListener(this);
            ICommandService service = (ICommandService)this.getSite().getService(ICommandService.class);
            service.addExecutionListener((IExecutionListener)this.commandServiceListener);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void updatePartName() {
        String title;
        String apiTitle = "";
        if (this.apiModelController != null && !(title = StringUtils.trimToEmpty((String)this.apiModelController.getApiTitle())).isEmpty()) {
            apiTitle = title;
        }
        if ("".equals(apiTitle) && this.getEditorInput() != null && !(title = StringUtils.trimToEmpty((String)this.getEditorInput().getName())).isEmpty()) {
            apiTitle = title;
        }
        this.setPartName(MessageFormat.format("{0} API", apiTitle));
        this.firePropertyChange(1);
    }

    protected void addPages() {
        try {
            this.apiFormPage = new ApiEditorFormPage(this, "ApiEditorFormPage", Xlat.label((String)"APIEDIT_TITLE"));
            this.addPage((IFormPage)this.apiFormPage);
            this.updatePartName();
        }
        catch (PartInitException e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"doSave()", (Object[])new Object[0]);
        try {
            this.notifyEditorListenersBeforeSave();
            if (!this.apiFormPage.canLeaveThePage()) {
                String errorMsg = Xlat.error((String)"API_EDITOR_NOT_VALID_SAVE_ERROR");
                ApiEditorMessageDialog dialog = new ApiEditorMessageDialog(this.getSite().getShell(), false);
                dialog.openError(errorMsg);
                return;
            }
            SaveApiOperation saveApiOp = new SaveApiOperation(this.modifyRule);
            WorkspaceModifyDelegatingOperation workspaceOp = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)saveApiOp, this.modifyRule);
            workspaceOp.run(monitor);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"doSave()", (Object[])new Object[0]);
    }

    private void checkForDeletedMethods(IProgressMonitor monitor) throws Exception {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"checkForDeletedMethods()", (Object[])new Object[0]);
        monitor.beginTask(Xlat.description((String)"STATUS_CHECK_DELETED_METHODS"), -1);
        ArrayList<ApiEditorPathComposite> pathComposites = new ArrayList<ApiEditorPathComposite>();
        pathComposites.addAll(this.apiFormPage.getPathComposites());
        pathComposites.addAll(this.apiFormPage.getDeletedPathComposites());
        for (ApiEditorPathComposite pathComposite : pathComposites) {
            ApiEditorMethodsComposite methodsComposite = pathComposite.getMethodsComposite();
            for (ApiEditorMethodComposite methodComposite : methodsComposite.getDeletedMethodComposites()) {
                PathType savedPathType = pathComposite.getLastSavedPathType();
                PathType currPathType = pathComposite.getPathType();
                MethodType currMethodType = methodComposite.getMethodType();
                this.apiProjectController.handleMethodDeleted(savedPathType, currPathType, currMethodType);
            }
        }
        monitor.done();
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"checkForDeletedMethods()", (Object[])new Object[0]);
    }

    private Map<String, String> checkForEditedPaths(IProgressMonitor monitor) throws Exception {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedPaths()", (Object[])new Object[0]);
        monitor.beginTask(Xlat.description((String)"STATUS_CHECK_EDITED_PATHS"), -1);
        HashMap<String, String> newPathToOldPath = new HashMap<String, String>();
        this.relPathBeans = new ArrayList();
        for (ApiEditorPathComposite currPathComposite : this.apiFormPage.getPathComposites()) {
            RelativePathBean currPathBean = new RelativePathBean();
            this.relPathBeans.add(currPathBean);
            currPathBean.lastSavedPathType = currPathComposite.getLastSavedPathType();
            currPathBean.pathType = currPathComposite.getPathType();
            if (StringUtils.equals((CharSequence)currPathBean.pathType.getRelativePath(), (CharSequence)currPathBean.lastSavedPathType.getRelativePath())) continue;
            newPathToOldPath.put(OpenApi2xUtil.stripQueryParameters((String)currPathBean.pathType.getRelativePath()), OpenApi2xUtil.stripQueryParameters((String)currPathBean.lastSavedPathType.getRelativePath()));
        }
        this.apiProjectController.checkForEditedPaths(this.relPathBeans, monitor);
        monitor.done();
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedPaths()", (Object[])new Object[0]);
        return newPathToOldPath;
    }

    private Map<String, String> checkForEditedOperationIds(IProgressMonitor monitor) throws Exception {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedOperationIds()", (Object[])new Object[0]);
        monitor.beginTask(Xlat.description((String)"STATUS_CHECK_EDITED_OPID"), -1);
        HashMap<String, String> newOpIdToOldOpId = new HashMap<String, String>();
        ArrayList<RelativePathBean> pathBeans = new ArrayList<RelativePathBean>();
        for (ApiEditorPathComposite currPathComposite : this.apiFormPage.getPathComposites()) {
            RelativePathBean currPathBean = new RelativePathBean();
            pathBeans.add(currPathBean);
            currPathBean.lastSavedPathType = currPathComposite.getLastSavedPathType();
            currPathBean.pathType = currPathComposite.getPathType();
            block1: for (MethodType currMethodType : currPathBean.pathType.getMethod()) {
                for (MethodType savedMethodType : currPathBean.lastSavedPathType.getMethod()) {
                    if (savedMethodType.getType() != currMethodType.getType()) continue;
                    if (StringUtils.equals((CharSequence)currMethodType.getOperationId(), (CharSequence)savedMethodType.getOperationId())) continue block1;
                    newOpIdToOldOpId.put(currMethodType.getOperationId(), savedMethodType.getOperationId());
                    continue block1;
                }
            }
        }
        monitor.done();
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedOperationIds()", (Object[])new Object[0]);
        return newOpIdToOldOpId;
    }

    private Map<String, Map<Integer, Integer>> checkForEditedServiceMappings(IProgressMonitor monitor) throws Exception {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedServiceMappings()", (Object[])new Object[0]);
        monitor.beginTask(Xlat.description((String)"STATUS_UPDATE_SERVICE_MAPPINGS"), -1);
        HashMap<String, Map<Integer, Integer>> opIdToNewCodeToOldCode = new HashMap<String, Map<Integer, Integer>>();
        String editedBasePath = this.apiFormPage.getEditedBasePath();
        for (Map controllers : this.apiProjectController.getServiceMappingControllers().values()) {
            for (ServiceMappingController controller : controllers.values()) {
                ZosConnectServiceMapping serviceMapping;
                HashMap<Integer, Integer> newCodeToOldCode = new HashMap<Integer, Integer>();
                if (editedBasePath != null && !editedBasePath.equals(controller.getBasePath())) {
                    controller.setBasePath(editedBasePath);
                }
                if ((serviceMapping = controller.getServiceMapping()) != null && serviceMapping.getResponseMessages() != null) {
                    for (ResponseMessageType responseMessageType : serviceMapping.getResponseMessages()) {
                        Integer newResponseCode;
                        String oldMapFileLocation;
                        Integer oldResponseCode;
                        if (!controller.hasMapping((MappingMessageType)responseMessageType) || (oldResponseCode = Integer.valueOf(MappingFileUtilz.getResponseCodeFromMappingFileLocation((String)(oldMapFileLocation = ServiceMappingController.getMappingFileLocation((MappingMessageType)responseMessageType))))).equals(newResponseCode = responseMessageType.getCode())) continue;
                        IFile oldResponseMapFile = controller.getResponseMappingFile(responseMessageType);
                        IFile newResponseMapFile = controller.getResponseMappingFile(newResponseCode);
                        oldResponseMapFile.move(newResponseMapFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                        String newMapFileLocation = newResponseMapFile.getProjectRelativePath().toString();
                        controller.setMappingFileLocation((MappingMessageType)responseMessageType, newMapFileLocation.toString());
                        newCodeToOldCode.put(newResponseCode, oldResponseCode);
                    }
                }
                if (controller.isDirty()) {
                    controller.marshall();
                }
                if (newCodeToOldCode.isEmpty()) continue;
                opIdToNewCodeToOldCode.put(controller.getOperationId(), newCodeToOldCode);
            }
        }
        monitor.done();
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedServiceMappings()", (Object[])new Object[0]);
        return opIdToNewCodeToOldCode;
    }

    private void checkForEditedMessageMappings(IProgressMonitor monitor) throws Exception {
        ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedMessageMappings()", (Object[])new Object[0]);
        monitor.beginTask(Xlat.description((String)"STATUS_UPDATE_MAPPINGS"), -1);
        for (RelativePathBean currPathBean : this.relPathBeans) {
            for (MappingMessageType messageType : currPathBean.editedMessageMappings) {
                if (messageType.getMappingRootModel() == null) continue;
                String mapFileRelPath = ServiceMappingController.getMappingFileLocation((MappingMessageType)messageType);
                IFile mappingFile = this.apiProjectController.getProject().getFile(mapFileRelPath);
                if (!mappingFile.exists()) continue;
                MappingRootController.reloadMappingFile((IFile)mappingFile);
            }
        }
        monitor.done();
        ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"checkForEditedMessageMappings()", (Object[])new Object[0]);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public ApiEditorFormPage getApiFormPage() {
        return this.apiFormPage;
    }

    public IFile getApiFile() {
        return this.apiFile;
    }

    public IProject getProject() {
        return this.apiProjectController.getProject();
    }

    public boolean isDirty() {
        return this.apiFormPage.isDirty();
    }

    public ApiProjectController getApiProjectController() {
        return this.apiProjectController;
    }

    public ApiModelController getApiModelController() {
        return this.apiModelController;
    }

    public OpenApi2xController getOpenApi2xController() {
        return this.openApi2xController;
    }

    public void dispose() {
        if (this.commandServiceListener != null) {
            ICommandService service = (ICommandService)this.getSite().getService(ICommandService.class);
            service.removeExecutionListener((IExecutionListener)this.commandServiceListener);
            this.commandServiceListener = null;
        }
        if (!this.hasCapabilityErrors) {
            super.dispose();
            IFile editorInputFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            editorInputFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.resourceTracker = null;
            XSwt.dispose((FormPage)this.apiFormPage);
        }
    }

    private void closeEditor(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ZosConnectApiEditor.this.getSite().getPage().closeEditor((IEditorPart)ZosConnectApiEditor.this, save);
            }
        });
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    public void notifyEditorListenersBeforeSave() {
        for (ApiEditorEventListener editorEventListeners : this.getEditorEventListeners()) {
            editorEventListeners.beforeSave(this);
        }
    }

    public void notifyEditorListenersSave() {
        for (ApiEditorEventListener editorEventListeners : this.getEditorEventListeners()) {
            editorEventListeners.save(this);
        }
    }

    public void notifyEditorListenersFileMarkersChanged(IFile file) {
        for (ApiEditorEventListener editorEventListeners : this.getEditorEventListeners()) {
            editorEventListeners.fileMarkersChanged(file);
        }
    }

    public List<ApiEditorEventListener> getEditorEventListeners() {
        if (this.editorEventListeners == null) {
            this.editorEventListeners = new ArrayList<ApiEditorEventListener>();
        }
        return this.editorEventListeners;
    }

    public void gotoApiResponseProblem(IMarker marker) {
        String operationId = ApiResponseValidationProblem.getOperationId((IMarker)marker);
        Integer responseCode = ApiResponseValidationProblem.getResponseCode((IMarker)marker);
        if (StringUtils.isBlank((CharSequence)operationId) || responseCode == null || responseCode == -1) {
            return;
        }
        for (ApiEditorPathComposite cmpPath : this.apiFormPage.getPathComposites()) {
            ApiEditorMethodResponseComposite cmpMethodResponse;
            ApiEditorMethodResponsesComposite cmpMethodResponses;
            ApiEditorMethodComposite cmpMethod;
            ApiEditorMethodsComposite cmpMethods;
            if (!XSwt.isNotDisposed((Control)cmpPath) || !XSwt.isNotDisposed((Control)(cmpMethods = cmpPath.getCmpMethods())) || !XSwt.isNotDisposed((Control)(cmpMethod = cmpMethods.getMethodComposite(operationId))) || !XSwt.isNotDisposed((Control)(cmpMethodResponses = cmpMethod.getCmpMethodResponses())) || !XSwt.isNotDisposed((Control)(cmpMethodResponse = cmpMethodResponses.getMethodResponseComposite(responseCode)))) continue;
            cmpPath.expandApiMethodsSection(false);
            cmpMethod.expandMethodDetailSection(false);
            cmpMethodResponses.expandResponsesSection(false);
            XSwt.show((ScrolledForm)this.apiFormPage.getScrolledForm(), (Control)cmpMethodResponse);
            XSwt.focus((Control)cmpMethodResponse);
            cmpMethodResponse.handleEditResponse();
        }
    }

    public void gotoMarker(final IMarker marker) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ApiResponseValidationProblem.isType((IMarker)marker)) {
                        ZosConnectApiEditor.this.gotoApiResponseProblem(marker);
                    }
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
        });
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || delta.getResource() == null) {
                return true;
            }
            IProject deltaProject = ZosConnectApiEditor.this.apiProjectController.getProject();
            if (delta.getResource().getProject() != deltaProject) {
                return true;
            }
            if (!(delta.getResource() instanceof IFile)) {
                return true;
            }
            final IFile deltaFile = (IFile)delta.getResource();
            if (deltaFile.equals((Object)((IFileEditorInput)ZosConnectApiEditor.this.getEditorInput()).getFile())) {
                if (delta.getKind() == 2) {
                    if ((0x2000 & delta.getFlags()) == 0) {
                        if (!ZosConnectApiEditor.this.isDirty()) {
                            ZosConnectApiEditor.this.closeEditor(false);
                        }
                    } else {
                        final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                        Display display = ZosConnectApiEditor.this.getSite().getShell().getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosConnectApiEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                            }
                        });
                    }
                } else if (delta.getKind() == 4 && delta.getMarkerDeltas().length > 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ZosConnectApiEditor.this.notifyEditorListenersFileMarkersChanged(deltaFile);
                        }
                    });
                }
            } else if ("map".equals(deltaFile.getFileExtension())) {
                if (delta.getKind() == 4) {
                    if (delta.getMarkerDeltas().length > 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosConnectApiEditor.this.notifyEditorListenersFileMarkersChanged(deltaFile);
                            }
                        });
                    }
                } else if (delta.getKind() == 2) {
                    if ((0x2000 & delta.getFlags()) == 0 && delta.getMarkerDeltas().length > 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosConnectApiEditor.this.notifyEditorListenersFileMarkersChanged(deltaFile);
                            }
                        });
                    }
                } else if (delta.getKind() == 1 && (0x1000 & delta.getFlags()) == 0 && delta.getMarkerDeltas().length > 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ZosConnectApiEditor.this.notifyEditorListenersFileMarkersChanged(deltaFile);
                        }
                    });
                }
            }
            return false;
        }
    }

    private class SaveApiOperation
    extends WorkspaceModifyOperation {
        public SaveApiOperation(ISchedulingRule modifyRule) {
            super(modifyRule);
        }

        protected void execute(IProgressMonitor monitor) {
            ZCeeUILogger.entering((String)((Object)((Object)this)).getClass().getName(), (String)"execute()", (Object[])new Object[0]);
            monitor.subTask(Xlat.description((String)"STATUS_SAVING_API"));
            try {
                ZosConnectApiEditor.this.checkForDeletedMethods(monitor);
                Map<String, String> newPathToOldPath = ZosConnectApiEditor.this.checkForEditedPaths(monitor);
                Map<String, String> newOpIdToOldOpId = ZosConnectApiEditor.this.checkForEditedOperationIds(monitor);
                Map<String, Map<Integer, Integer>> opIdToNewCodeToOldCode = ZosConnectApiEditor.this.checkForEditedServiceMappings(monitor);
                IFile swaggerFile = ZosConnectApiEditor.this.openApi2xController.generateSwagger(new OpenApi2xVisitor(), newPathToOldPath, newOpIdToOldOpId, opIdToNewCodeToOldCode, monitor);
                ZosConnectApiEditor.this.apiModelController.addOrUpdateApiDoc(ApiDocType.SWAGGER, swaggerFile);
                ZosConnectApiEditor.this.apiModelController.marshall(monitor);
                ZosConnectApiEditor.this.checkForEditedMessageMappings(monitor);
                ZosConnectApiEditor.this.notifyEditorListenersSave();
                ZosConnectApiEditor.this.apiFormPage.setDirty(false);
                ZosConnectApiEditor.this.editorDirtyStateChanged();
                ZosConnectApiEditor.this.apiProjectController.pruneEmptyFolders();
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                ZCeeErrorDialog.openError((Exception)e);
            }
            ZCeeUILogger.exiting((String)((Object)((Object)this)).getClass().getName(), (String)"execute()", (Object[])new Object[0]);
        }
    }
}

