/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectInvalidInputException;
import com.ibm.zosconnect.ui.common.util.MessageManagerWrapper;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.api.ZosConnectApiModelUtil;
import com.ibm.zosconnect.ui.common.util.swt.FormCompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormImageHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormLabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormSectionBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormStyledTextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.ModifyListener2;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMethodDialog;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodsComposite;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorEventListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorPathModifyListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorWidgetUpdateListener;
import com.ibm.zosconnect.ui.util.PathValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ApiEditorPathComposite
extends Composite
implements ApiEditorEventListener,
ApiEditorPathModifyListener,
ApiEditorWidgetUpdateListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ApiEditorPathComposite.class.getName();
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private final FormToolkit toolkit;
    private PathType pathType;
    private Composite controlParent;
    private ApiEditorFormPage logicalParent;
    private ApiEditorPathComposite self;
    private ApiEditorMethodsComposite cmpMethods;
    private Composite cmpAddPath;
    private Composite cmpPath;
    private Composite cmpAddMethod;
    private StyledText txtPath;
    private Section sctMethods;
    private ImageHyperlink imgAddPath;
    private ImageHyperlink imgAddMethod;
    private ImageHyperlink imgTwistie;
    private ImageHyperlink imgMovePathUp;
    private ImageHyperlink imgMovePathDown;
    private ImageHyperlink imgPathRemove;
    private Label lblPathChanged;
    private Hyperlink lnkMethods;
    private int txtPathOffsetDelta;
    private PathType lastSavedPath;
    private MessageManagerWrapper messageMgr;
    private boolean committedPath = false;

    public ApiEditorPathComposite(Composite controlParent, ApiEditorFormPage logicalParent, PathType pathType, int index, FormToolkit toolkit) {
        super(controlParent, 0);
        this.controlParent = controlParent;
        this.logicalParent = logicalParent;
        this.pathType = pathType;
        this.toolkit = toolkit;
        this.self = this;
        this.getApiEditor().getEditorEventListeners().add(this.self);
        this.getLogicalParent().getPathComposites().add(index, this.self);
        this.getLogicalParent().getPathModifyListeners().add(this.self);
        this.getLogicalParent().getWidgetUpdateListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ApiEditorPathComposite.this.getLogicalParent().getPathComposites().remove(ApiEditorPathComposite.this.self);
                ApiEditorPathComposite.this.getApiEditor().getEditorEventListeners().remove(ApiEditorPathComposite.this.self);
                ApiEditorPathComposite.this.getLogicalParent().getPathModifyListeners().remove(ApiEditorPathComposite.this.self);
                ApiEditorPathComposite.this.getLogicalParent().getWidgetUpdateListeners().remove(ApiEditorPathComposite.this.self);
            }
        });
        this.messageMgr = new MessageManagerWrapper(this.getLogicalParent().getScrolledForm().getMessageManager());
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayoutBuilder().marginWidth(0).build());
        this.setLayoutData(new GridDataBuilder().verticalAlignment(128).grabExcessHorizontalSpace(true).build());
        toolkit.adapt((Composite)this.self);
        toolkit.paintBordersFor((Composite)this.self);
        if (!logicalParent.isFormContentCreated()) {
            this.committedPath = true;
        }
        this.createContent();
    }

    public void createContent() {
        this.cmpAddPath = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(2).verticalAlignment(128).grabExcessHorizontalSpace(true).build((Composite)this);
        this.imgAddPath = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-add@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_ADD_PATH")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                int selfIndex = ApiEditorPathComposite.this.getLogicalParent().getApiPathCompositeIndex(ApiEditorPathComposite.this.self);
                String newRelativePath = ApiEditorPathComposite.this.generateUniqueRelativePath(ApiEditorPathComposite.this.logicalParent);
                PathType newApiPath = ApiModelController.createNewApiPath();
                newApiPath.setRelativePath(newRelativePath);
                ApiEditorPathComposite.this.getApiModelController().addApiPathAfter(newApiPath, ApiEditorPathComposite.this.pathType);
                ApiEditorPathComposite newPath = new ApiEditorPathComposite(ApiEditorPathComposite.this.controlParent, ApiEditorPathComposite.this.getLogicalParent(), newApiPath, selfIndex + 1, ApiEditorPathComposite.this.toolkit);
                newPath.moveBelow((Control)ApiEditorPathComposite.this.self);
                newPath.setFocus();
                ApiEditorPathComposite.this.getLogicalParent().setDirty(true);
                XSwt.layout((Composite)ApiEditorPathComposite.this.controlParent, (boolean)true);
                XSwt.reflow((ScrolledForm)ApiEditorPathComposite.this.getLogicalParent().getScrolledForm());
                XSwt.show((ScrolledForm)ApiEditorPathComposite.this.getLogicalParent().getScrolledForm(), (Control)newPath);
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgAddPath, (String)"icon-add-hover@x1.png");
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgAddPath, (String)"icon-add@x1.png");
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build(this.cmpAddPath);
        Composite compPathUpDown = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(4).verticalAlignment(0x1000000).grabExcessHorizontalSpace(true).horizontalSpacing(MaxFieldDecorationWidth).build(this.cmpAddPath);
        new FormLabelBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_LABEL_PATH")).horizontalAlignment(16384).verticalAlignment(0x1000000).build(compPathUpDown);
        this.imgMovePathUp = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-move-up@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_MOVE_PATH_UP", (String[])new String[]{XSwt.getText((StyledText)this.txtPath)})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorPathComposite.this.getLogicalParent().isFirstPath(ApiEditorPathComposite.this.self)) {
                    ApiEditorPathComposite.this.getLogicalParent().movePathUp(ApiEditorPathComposite.this.self);
                } else {
                    ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(ApiEditorPathComposite.this.getShell(), true);
                    messageDialog.openInfo(Xlat.description((String)"INFO_PATH_ALREADY_FIRST", (String[])new String[]{XSwt.getText((StyledText)ApiEditorPathComposite.this.txtPath)}));
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorPathComposite.this.getLogicalParent().isFirstPath(ApiEditorPathComposite.this.self)) {
                    XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgMovePathUp, (String)"icon-move-up-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgMovePathUp, (String)"icon-move-up@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).grabExcessHorizontalSpace(true).build(compPathUpDown);
        this.imgMovePathDown = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-move-down@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_MOVE_PATH_DOWN", (String[])new String[]{XSwt.getText((StyledText)this.txtPath)})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorPathComposite.this.getLogicalParent().isLastPath(ApiEditorPathComposite.this.self)) {
                    ApiEditorPathComposite.this.getLogicalParent().movePathDown(ApiEditorPathComposite.this.self);
                } else {
                    ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(ApiEditorPathComposite.this.getShell(), true);
                    messageDialog.openInfo(Xlat.description((String)"INFO_PATH_ALREADY_LAST", (String[])new String[]{XSwt.getText((StyledText)ApiEditorPathComposite.this.txtPath)}));
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorPathComposite.this.getLogicalParent().isLastPath(ApiEditorPathComposite.this.self)) {
                    XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgMovePathDown, (String)"icon-move-down-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgMovePathDown, (String)"icon-move-down@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build(compPathUpDown);
        this.imgPathRemove = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-delete@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_REMOVE_PATH", (String[])new String[]{XSwt.getText((StyledText)this.txtPath)})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(ApiEditorPathComposite.this.getShell(), false);
                if (ApiEditorPathComposite.this.getApiModelController().getApiPaths().size() == 1) {
                    messageDialog.openInfo(Xlat.description((String)"INFO_AT_LEAST_ONE_PATH"));
                } else if (messageDialog.openConfirm(Xlat.description((String)"CONFIRM_DELETE_PATH", (String[])new String[]{XSwt.getText((StyledText)ApiEditorPathComposite.this.txtPath)}))) {
                    ApiEditorPathComposite.this.messageMgr.removeMessages((Control)ApiEditorPathComposite.this.txtPath);
                    ApiEditorPathComposite.this.getApiModelController().removeApiPath(ApiEditorPathComposite.this.pathType);
                    ApiEditorPathComposite.this.getLogicalParent().getDeletedPathComposites().add(ApiEditorPathComposite.this.self);
                    ApiEditorPathComposite.this.cmpMethods.getDeletedMethodComposites().addAll(ApiEditorPathComposite.this.cmpMethods.getMethodComposites());
                    ApiEditorPathComposite.this.getLogicalParent().setDirty(true);
                    ApiEditorPathComposite.this.dispose();
                    ApiEditorPathComposite.this.getLogicalParent().notifyApiPathListeners(ApiEditorPathComposite.this.self);
                    ApiEditorPathComposite.this.getLogicalParent().notifyWidgetUpdateListeners();
                    XSwt.reflow((ScrolledForm)ApiEditorPathComposite.this.getLogicalParent().getScrolledForm());
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgPathRemove, (String)"icon-delete-hover@x1.png");
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgPathRemove, (String)"icon-delete@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build(compPathUpDown);
        new FormLabelBuilder(this.toolkit).build(this.cmpAddPath);
        this.cmpPath = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(2).horizontalAlignment(16384).build(this.cmpAddPath);
        this.txtPath = (StyledText)new FormStyledTextBuilder(this.toolkit).text(this.pathType.getRelativePath(), "/").toolTipText(this.pathType.getRelativePath(), "/").leftMargin(5).listener((VerifyListener)new VerifyListener2((Control)this.cmpPath){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
                ApiEditorPathComposite.this.txtPathOffsetDelta = 0;
                if (event.end - event.start == 0 && StringUtils.equals((CharSequence)event.text, (CharSequence)"{")) {
                    event.text = "{}";
                    ApiEditorPathComposite.this.txtPathOffsetDelta = -1;
                }
            }
        }).listener((ModifyListener)new ModifyListener2((Control)this.cmpPath){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                if (ApiEditorPathComposite.this.txtPathOffsetDelta != 0) {
                    ApiEditorPathComposite.this.txtPath.setCaretOffset(Math.max(0, ApiEditorPathComposite.this.txtPath.getCaretOffset() + ApiEditorPathComposite.this.txtPathOffsetDelta));
                    ApiEditorPathComposite.this.txtPathOffsetDelta = 0;
                    ApiEditorPathComposite.this.highlightApiPathSyntax();
                } else {
                    ApiEditorPathComposite.this.validateAndHighlightApiPath();
                }
                String updatedPath = XSwt.getTrimText((StyledText)ApiEditorPathComposite.this.txtPath);
                ApiEditorPathComposite.this.pathType.setRelativePath(updatedPath);
                if (!ApiEditorPathComposite.this.committedPath) {
                    ApiEditorPathComposite.this.lastSavedPath.setRelativePath(updatedPath);
                }
                ApiEditorPathComposite.this.updateTooltipPathText();
                ApiEditorPathComposite.this.getLogicalParent().setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessHorizontalSpace(true).widthHint(500).build(this.cmpPath);
        this.lastSavedPath = ZosConnectApiModelUtil.clone((PathType)this.pathType);
        this.lblPathChanged = (Label)new FormLabelBuilder(this.toolkit).image(XImg.icon((String)"change_obj.png")).marginLeft(5).visible(Boolean.valueOf(false)).build(this.cmpPath);
        new FormLabelBuilder(this.toolkit).build(this.cmpAddPath);
        this.cmpAddMethod = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(3).marginTop(5).marginBottom(5).marginHeight(0).verticalSpacing(0).horizontalAlignment(16384).verticalAlignment(0x1000000).verticalIndent(5).build(this.cmpAddPath);
        this.imgAddMethod = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-add@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_ADD_METHOD", (String[])new String[]{this.getPathText()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorPathComposite.this.cmpMethods.hasAllMethods()) {
                    ApiEditorMethodDialog methodDialog = new ApiEditorMethodDialog(ApiEditorPathComposite.this.imgAddMethod.getShell(), ApiEditorPathComposite.this.cmpMethods);
                    methodDialog.open();
                } else {
                    ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(ApiEditorPathComposite.this.getShell(), false);
                    messageDialog.openInfo(Xlat.description((String)"INFO_ALL_METHODS_ALREADY_ADDED"));
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorPathComposite.this.cmpMethods.hasAllMethods()) {
                    XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgAddMethod, (String)"icon-add-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorPathComposite.this.imgAddMethod, (String)"icon-add@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build(this.cmpAddMethod);
        this.lnkMethods = (Hyperlink)new FormHyperlinkBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_LABEL_METHOD")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.isExpanded((Section)ApiEditorPathComposite.this.sctMethods)) {
                    ApiEditorPathComposite.this.collapseApiMethodsSection(false);
                } else {
                    ApiEditorPathComposite.this.expandApiMethodsSection(false);
                }
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build(this.cmpAddMethod);
        this.imgTwistie = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).toolTipText(Xlat.description((String)"TOOLTIP_HIDE_SHOW_METHODS", (String[])new String[]{this.getPathText()})).image(XImg.icon((String)"arrow_down_big.png")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.isExpanded((Section)ApiEditorPathComposite.this.sctMethods)) {
                    ApiEditorPathComposite.this.collapseApiMethodsSection(false);
                } else {
                    ApiEditorPathComposite.this.expandApiMethodsSection(false);
                }
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build(this.cmpAddMethod);
        new FormLabelBuilder(this.toolkit).build(this.cmpAddPath);
        this.sctMethods = (Section)new FormSectionBuilder(this.toolkit).style(Integer.valueOf(20512)).verticalAlignment(128).horizontalIndent(30).build(this.cmpAddPath);
        this.cmpMethods = new ApiEditorMethodsComposite((Composite)this.sctMethods, this, this.toolkit, 0);
        this.sctMethods.setClient((Control)this.cmpMethods);
        this.validateAndHighlightApiPath();
        this.updateTooltipPathText();
    }

    private void validateAndHighlightApiPath() {
        this.validateApiPathsAreUnique();
        try {
            PathValidator.validateHighlightApiPathSyntax(this.txtPath, true, true);
            this.messageMgr.removeMessage((Object)"INVALID_API_PATH_ERROR", (Control)this.txtPath);
        }
        catch (ZosConnectInvalidInputException e) {
            this.messageMgr.addMessage((Object)"INVALID_API_PATH_ERROR", e.getMessage(), null, 3, (Control)this.txtPath);
        }
        this.getLogicalParent().notifyApiPathListeners(this.self);
        this.getLogicalParent().notifyWidgetUpdateListeners();
    }

    private void validateApiPathsAreUnique() {
        String pathText = XSwt.getTrimText((StyledText)this.txtPath);
        this.pathType.setRelativePath(pathText);
        if (this.hasDuplicateApiPaths(pathText)) {
            this.messageMgr.addMessage((Object)"DUPLICATE_API_PATH_ERROR", Xlat.error((String)"DUPLICATE_API_PATH_ERROR", (String[])new String[]{pathText}), null, 3, (Control)this.txtPath);
        } else {
            this.messageMgr.removeMessage((Object)"DUPLICATE_API_PATH_ERROR", (Control)this.txtPath);
        }
    }

    private void highlightApiPathSyntax() {
        try {
            PathValidator.validateHighlightApiPathSyntax(this.txtPath, false, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateTooltipPathText() {
        this.updateTxtPathTooltip();
        String pathText = StringUtils.trimToEmpty((String)this.pathType.getRelativePath()).replace("&", "&&&");
        XSwt.setTooltipText((Control)this.imgMovePathUp, (String)Xlat.description((String)"TOOLTIP_MOVE_PATH_UP", (String[])new String[]{pathText}));
        XSwt.setTooltipText((Control)this.imgMovePathDown, (String)Xlat.description((String)"TOOLTIP_MOVE_PATH_DOWN", (String[])new String[]{pathText}));
        XSwt.setTooltipText((Control)this.imgPathRemove, (String)Xlat.description((String)"TOOLTIP_REMOVE_PATH", (String[])new String[]{pathText}));
        XSwt.setTooltipText((Control)this.imgAddMethod, (String)Xlat.description((String)"TOOLTIP_ADD_METHOD", (String[])new String[]{pathText}));
    }

    private void updateTxtPathTooltip() {
        String savedPath;
        String pendingPath = StringUtils.trimToEmpty((String)this.pathType.getRelativePath()).replace("&", "&&&");
        if (!StringUtils.equals((CharSequence)pendingPath, (CharSequence)(savedPath = StringUtils.trimToEmpty((String)this.lastSavedPath.getRelativePath()).replace("&", "&&&")))) {
            XSwt.setTooltipText((Control)this.txtPath, (String)pendingPath);
            XSwt.setTooltipText((Control)this.lblPathChanged, (String)Xlat.description((String)"TOOLTIP_PENDING_VALUE", (String[])new String[]{pendingPath, savedPath}));
            XSwt.setVisible((Control)this.lblPathChanged, (boolean)true);
        } else {
            XSwt.setTooltipText((Control)this.txtPath, (String)pendingPath);
            XSwt.setTooltipText((Control)this.lblPathChanged, (String)"");
            XSwt.setVisible((Control)this.lblPathChanged, (boolean)false);
        }
    }

    private String getPathToCompare(String path) {
        int questionMark = path.indexOf(63);
        if (questionMark != -1) {
            path = path.substring(0, questionMark);
        }
        if (path.indexOf("{") != -1) {
            path = StringUtils.replacePattern((String)path, (String)"\\{[^\\}\\/]+\\}", (String)"{PP}");
        }
        return path;
    }

    private boolean hasDuplicateApiPaths(String text) {
        List<ApiEditorPathComposite> paths = this.getLogicalParent().getPathComposites();
        String comparePath = this.getPathToCompare(text);
        int selfIndex = this.getLogicalParent().getApiPathCompositeIndex(this);
        int i = 0;
        while (i < paths.size()) {
            ApiEditorPathComposite nextPath = paths.get(i);
            if (i != selfIndex) {
                String currPath = this.getPathToCompare(nextPath.pathType.getRelativePath());
                String prevPath = this.getPathToCompare(nextPath.lastSavedPath.getRelativePath());
                if (currPath.equals(comparePath) || prevPath.equals(comparePath)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void collapseApiMethodsSection(boolean collapseNested) {
        XImg.setIcon((ImageHyperlink)this.imgTwistie, (String)"arrow_right_big.png");
        if (collapseNested) {
            for (ApiEditorMethodComposite cmpMethod : this.cmpMethods.getMethodComposites()) {
                if (!XSwt.isNotDisposed((Control)cmpMethod)) continue;
                if (XSwt.isNotDisposed((Control)cmpMethod.getCmpMethodDescription())) {
                    cmpMethod.getCmpMethodDescription().collapseDescriptionSection(false);
                }
                if (XSwt.isNotDisposed((Control)cmpMethod.getCmpMethodResponses())) {
                    cmpMethod.getCmpMethodResponses().collapseResponsesSection(false);
                }
                cmpMethod.collapseMethodDetailSection(false);
            }
        }
        XSwt.collapse((Section)this.sctMethods);
    }

    public void expandApiMethodsSection(boolean expandNested) {
        XImg.setIcon((ImageHyperlink)this.imgTwistie, (String)"arrow_down_big.png");
        if (expandNested) {
            for (ApiEditorMethodComposite cmpMethod : this.cmpMethods.getMethodComposites()) {
                if (!XSwt.isNotDisposed((Control)cmpMethod)) continue;
                if (XSwt.isNotDisposed((Control)cmpMethod.getCmpMethodDescription())) {
                    cmpMethod.getCmpMethodDescription().expandDescriptionSection(false);
                }
                if (XSwt.isNotDisposed((Control)cmpMethod.getCmpMethodResponses())) {
                    cmpMethod.getCmpMethodResponses().expandResponsesSection(false);
                }
                cmpMethod.expandMethodDetailSection(false);
            }
        }
        XSwt.expand((Section)this.sctMethods);
    }

    public ApiEditorFormPage getLogicalParent() {
        return this.logicalParent;
    }

    public ZosConnectApiEditor getApiEditor() {
        return this.getLogicalParent().getApiEditor();
    }

    public ApiModelController getApiModelController() {
        return this.getApiEditor().getApiModelController();
    }

    public ApiProjectController getApiProjectController() {
        return this.getApiEditor().getApiProjectController();
    }

    public boolean setFocus() {
        ApiEditorPathComposite selectedPathPriorToSave = this.getLogicalParent().getSelectedPathPriorToSave();
        if (!XSwt.isNotDisposed((Control)selectedPathPriorToSave)) {
            XSwt.focus((Control)this.txtPath);
        }
        return true;
    }

    public String toString() {
        String retVal = XSwt.getText((StyledText)this.txtPath);
        if (retVal == null) {
            retVal = super.toString();
        }
        return retVal;
    }

    @Override
    public void beforeSave(ZosConnectApiEditor editor) {
        this.validateAndHighlightApiPath();
    }

    @Override
    public void save(ZosConnectApiEditor editor) {
        this.lastSavedPath = ZosConnectApiModelUtil.clone((PathType)this.pathType);
        this.committedPath = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ApiEditorPathComposite.this.updateTxtPathTooltip();
            }
        });
    }

    @Override
    public void fileMarkersChanged(IFile file) {
    }

    public PathType getLastSavedPathType() {
        return this.lastSavedPath;
    }

    public ApiEditorMethodsComposite getMethodsComposite() {
        return this.cmpMethods;
    }

    public List<MethodType> getMethods() {
        List<Object> methods = new ArrayList<MethodType>();
        if (this.pathType != null && this.pathType.getMethod() != null) {
            methods = this.pathType.getMethod();
        }
        return methods;
    }

    public int getMethodCount() {
        return this.getMethods().size();
    }

    @Override
    public void modify(ApiEditorPathComposite modified) {
        this.validateApiPathsAreUnique();
    }

    @Override
    public void updateWidgetEnablements(boolean enabled) {
        XSwt.setEnabled((Control)this.imgMovePathDown, (boolean)enabled);
        XSwt.setEnabled((Control)this.imgMovePathUp, (boolean)enabled);
        XSwt.setEnabled((Control)this.imgPathRemove, (boolean)enabled);
        XSwt.setEnabled((Control)this.imgAddMethod, (boolean)enabled);
        XSwt.setEnabled((Control)this.imgAddPath, (boolean)enabled);
    }

    private String generateUniqueRelativePath(ApiEditorFormPage parentFormPage) {
        boolean hasDuplicate = true;
        int n = 0;
        String uniquePathBase = "/newPath";
        Object potentiallyUniquePath = "";
        List<ApiEditorPathComposite> paths = this.getLogicalParent().getPathComposites();
        do {
            hasDuplicate = false;
            potentiallyUniquePath = uniquePathBase + ++n;
            int i = 0;
            while (i < paths.size() && !hasDuplicate) {
                ApiEditorPathComposite nextPath = paths.get(i);
                String currPath = this.getPathToCompare(nextPath.pathType.getRelativePath());
                String prevPath = this.getPathToCompare(nextPath.lastSavedPath.getRelativePath());
                hasDuplicate = currPath.equals(potentiallyUniquePath) || prevPath.equals(potentiallyUniquePath);
                ++i;
            }
        } while (hasDuplicate);
        return potentiallyUniquePath;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public String getPathText() {
        return this.pathType.getRelativePath();
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public ApiEditorMethodsComposite getCmpMethods() {
        return this.cmpMethods;
    }

    public Composite getCmpAddPath() {
        return this.cmpAddPath;
    }

    public Composite getCmpPath() {
        return this.cmpPath;
    }

    public Composite getCmpAddMethod() {
        return this.cmpAddMethod;
    }

    public StyledText getTxtPath() {
        return this.txtPath;
    }

    public Section getSctMethods() {
        return this.sctMethods;
    }

    public ImageHyperlink getImgAddPath() {
        return this.imgAddPath;
    }

    public ImageHyperlink getImgAddMethod() {
        return this.imgAddMethod;
    }

    public ImageHyperlink getImgTwistie() {
        return this.imgTwistie;
    }

    public ImageHyperlink getImgMovePathUp() {
        return this.imgMovePathUp;
    }

    public ImageHyperlink getImgMovePathDown() {
        return this.imgMovePathDown;
    }

    public ImageHyperlink getImgPathRemove() {
        return this.imgPathRemove;
    }

    public Hyperlink getLnkMethods() {
        return this.lnkMethods;
    }

    public void updateMethodsHyperlink() {
        int methodCount = this.getMethodCount();
        if (methodCount > 0) {
            XSwt.setText((Hyperlink)this.lnkMethods, (String)Xlat.label((String)"APIEDIT_LABEL_METHOD_NUM", (Object[])new Object[]{methodCount}));
        } else {
            XSwt.setText((Hyperlink)this.lnkMethods, (String)Xlat.label((String)"APIEDIT_LABEL_METHOD"));
        }
    }

    public boolean isCommittedPath() {
        return this.committedPath;
    }
}

