/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorPathComposite;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorEventListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorMethodsModifyListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorWidgetUpdateListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ApiEditorMethodsComposite
extends Composite
implements ApiEditorEventListener,
ApiEditorWidgetUpdateListener,
ApiEditorMethodsModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite controlParent;
    private ApiEditorPathComposite logicalParent;
    private FormToolkit toolkit;
    private ApiEditorMethodsComposite self;
    private List<ApiEditorMethodComposite> methodComposites;
    private Map<MethodValues, ApiEditorMethodComposite> methodCompositesMap;
    private List<ApiEditorMethodComposite> deletedMethodComposites;
    private IMessageManager messageMgr;

    public ApiEditorMethodsComposite(Composite controlParent, ApiEditorPathComposite logicalParent, FormToolkit toolkit, int style) {
        super(controlParent, style);
        this.controlParent = controlParent;
        this.logicalParent = logicalParent;
        this.toolkit = toolkit;
        this.messageMgr = this.getParentFormPage().getScrolledForm().getMessageManager();
        this.methodComposites = new ArrayList<ApiEditorMethodComposite>();
        this.methodCompositesMap = new HashMap<MethodValues, ApiEditorMethodComposite>();
        this.deletedMethodComposites = new ArrayList<ApiEditorMethodComposite>();
        this.self = this;
        this.getApiEditor().getEditorEventListeners().add(this.self);
        this.getParentFormPage().getMethodsModifyListeners().add(this.self);
        this.getParentFormPage().getWidgetUpdateListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ApiEditorMethodsComposite.this.getApiEditor().getEditorEventListeners().remove(ApiEditorMethodsComposite.this.self);
                ApiEditorMethodsComposite.this.getParentFormPage().getMethodsModifyListeners().remove(ApiEditorMethodsComposite.this.self);
                ApiEditorMethodsComposite.this.getParentFormPage().getWidgetUpdateListeners().remove(ApiEditorMethodsComposite.this.self);
            }
        });
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayoutBuilder().marginHeight(0).marginWidth(0).verticalSpacing(0).build());
        this.setLayoutData(new GridDataBuilder().verticalIndent(15).build());
        PathType pathType = logicalParent.getPathType();
        for (MethodType methodType : pathType.getMethod()) {
            String operationId;
            if (!StringUtils.isBlank((CharSequence)methodType.getZosConnectServiceRef()) && (operationId = StringUtils.trimToEmpty((String)methodType.getOperationId())).isEmpty()) {
                operationId = this.getApiModelController().getUniqueOperationId(methodType);
                methodType.setOperationId(operationId);
                this.getParentFormPage().setDirty(true);
            }
            this.addMethod(methodType, false, false);
        }
        this.validate();
    }

    public void addNewMethod(MethodValues type) throws Exception {
        PathType pathType = this.logicalParent.getPathType();
        MethodType methodType = this.getApiModelController().addPathMethod(pathType, type);
        this.addMethod(methodType, true, true);
        this.getParentFormPage().setDirty(true);
    }

    private void addMethod(MethodType methodType, boolean setFocus, boolean show) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        ServiceArchiveController serviceArchiveController = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)methodType.getZosConnectServiceRef())) {
                serviceArchiveController = this.getApiProjectController().getServiceArchiveController(methodType.getZosConnectServiceRef());
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        ServiceMappingController serviceMappingController = this.getServiceMappingController(this.logicalParent.getPathType(), methodType, serviceArchiveController);
        ApiEditorMethodComposite cmpMethod = new ApiEditorMethodComposite(this, this, methodType, serviceMappingController, this.toolkit);
        this.methodComposites.add(cmpMethod);
        this.methodCompositesMap.put(methodType.getType(), cmpMethod);
        this.logicalParent.updateMethodsHyperlink();
        XSwt.layout((Composite)this, (boolean)true);
        XSwt.expand((Section)this.logicalParent.getSctMethods());
        XSwt.reflow((ScrolledForm)this.getScrolledForm());
        if (show) {
            XSwt.show((ScrolledForm)this.getScrolledForm(), (Control)cmpMethod);
        }
        if (setFocus) {
            XSwt.focus((Control)cmpMethod.getTxtMethodService());
        }
    }

    public void removeMethod(MethodType method) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        ApiEditorMethodComposite methodComposite = this.methodCompositesMap.get(method.getType());
        if (methodComposite == null) {
            return;
        }
        this.getApiModelController().removePathMethod(this.logicalParent.getPathType(), method.getType());
        this.deletedMethodComposites.add(methodComposite);
        this.methodComposites.remove(methodComposite);
        this.methodCompositesMap.remove(method.getType());
        methodComposite.dispose();
        this.getParentFormPage().setDirty(true);
        this.logicalParent.updateMethodsHyperlink();
        XSwt.layout((Composite)methodComposite.getControlParent(), (boolean)true);
        XSwt.reflow((ScrolledForm)this.getScrolledForm());
    }

    public boolean hasPOSTMethod() {
        ApiEditorMethodComposite cmpMethodPOST = this.methodCompositesMap.get(MethodValues.POST);
        return cmpMethodPOST != null && XSwt.isNotDisposed((Control)cmpMethodPOST);
    }

    public boolean hasGETMethod() {
        ApiEditorMethodComposite cmpMethodGET = this.methodCompositesMap.get(MethodValues.GET);
        return cmpMethodGET != null && XSwt.isNotDisposed((Control)cmpMethodGET);
    }

    public boolean hasPUTMethod() {
        ApiEditorMethodComposite cmpMethodPUT = this.methodCompositesMap.get(MethodValues.PUT);
        return cmpMethodPUT != null && XSwt.isNotDisposed((Control)cmpMethodPUT);
    }

    public boolean hasDELETEMethod() {
        ApiEditorMethodComposite cmpMethodDELETE = this.methodCompositesMap.get(MethodValues.DELETE);
        return cmpMethodDELETE != null && XSwt.isNotDisposed((Control)cmpMethodDELETE);
    }

    public boolean hasPATCHMethod() {
        ApiEditorMethodComposite cmpMethodPATCH = this.methodCompositesMap.get(MethodValues.PATCH);
        return cmpMethodPATCH != null && XSwt.isNotDisposed((Control)cmpMethodPATCH);
    }

    public boolean hasHEADMethod() {
        ApiEditorMethodComposite cmpMethodHEAD = this.methodCompositesMap.get(MethodValues.HEAD);
        return cmpMethodHEAD != null && XSwt.isNotDisposed((Control)cmpMethodHEAD);
    }

    public boolean hasAllMethods() {
        return this.hasPOSTMethod() && this.hasGETMethod() && this.hasPUTMethod() && this.hasDELETEMethod() && this.hasPATCHMethod() && this.hasHEADMethod();
    }

    public ApiEditorFormPage getParentFormPage() {
        return this.logicalParent.getLogicalParent();
    }

    public ScrolledForm getScrolledForm() {
        return this.getParentFormPage().getScrolledForm();
    }

    public ZosConnectApiEditor getApiEditor() {
        return this.getParentFormPage().getApiEditor();
    }

    public ApiProjectController getApiProjectController() {
        return this.getParentFormPage().getApiEditor().getApiProjectController();
    }

    public ApiModelController getApiModelController() {
        return this.getParentFormPage().getApiEditor().getApiModelController();
    }

    public ServiceMappingController getServiceMappingController(PathType pathType, MethodType methodType, ServiceArchiveController serviceArchiveController) {
        return this.getApiProjectController().getServiceMappingController(pathType, methodType, serviceArchiveController);
    }

    public ApiEditorPathComposite getLogicalParent() {
        return this.logicalParent;
    }

    public boolean isFirstMethod(ApiEditorMethodComposite method) {
        return ListUtilz.isFirstMember(this.methodComposites, (Object)method);
    }

    public boolean isLastMethod(ApiEditorMethodComposite method) {
        return ListUtilz.isLastMember(this.methodComposites, (Object)method);
    }

    public void moveMethodUp(ApiEditorMethodComposite composite) {
        int sourceIndex = this.methodComposites.indexOf(composite);
        int targetIndex = sourceIndex - 1;
        if (sourceIndex == -1 || sourceIndex == 0 || targetIndex < 0) {
            return;
        }
        ApiEditorMethodComposite targetMethod = this.methodComposites.get(targetIndex);
        this.methodComposites.set(targetIndex, composite);
        this.methodComposites.set(sourceIndex, targetMethod);
        composite.getTxtMethodService().setFocus();
        composite.moveAbove((Control)targetMethod);
        this.getApiModelController().moveMethodUp(this.logicalParent.getPathType(), composite.getMethodType());
        this.getParentFormPage().setDirty(true);
        XSwt.layout((Composite)this, (boolean)true);
        XSwt.expand((Section)this.logicalParent.getSctMethods());
    }

    public void moveMethodDown(ApiEditorMethodComposite composite) {
        int sourceIndex = this.methodComposites.indexOf(composite);
        int targetIndex = sourceIndex + 1;
        if (sourceIndex == -1 || sourceIndex == this.methodComposites.size() - 1 || targetIndex >= this.methodComposites.size()) {
            return;
        }
        ApiEditorMethodComposite targetComposite = this.methodComposites.get(targetIndex);
        this.methodComposites.set(targetIndex, composite);
        this.methodComposites.set(sourceIndex, targetComposite);
        composite.getTxtMethodService().setFocus();
        composite.moveBelow((Control)targetComposite);
        this.getApiModelController().moveMethodDown(this.logicalParent.getPathType(), composite.getMethodType());
        this.getParentFormPage().setDirty(true);
        XSwt.layout((Composite)this, (boolean)true);
        XSwt.expand((Section)this.logicalParent.getSctMethods());
    }

    public List<ApiEditorMethodComposite> getDeletedMethodComposites() {
        return this.deletedMethodComposites;
    }

    @Override
    public void beforeSave(ZosConnectApiEditor editor) {
    }

    @Override
    public void save(ZosConnectApiEditor editor) {
        this.deletedMethodComposites.clear();
    }

    @Override
    public void fileMarkersChanged(IFile file) {
    }

    @Override
    public void modify(ApiEditorMethodsComposite methods, MethodValues methodValue) {
        this.validate();
    }

    public void validate() {
        Map<String, Integer> opIdMap = this.getOpIdsWithCount();
        if (this.hasPOSTMethod()) {
            this.validateOpId(this.methodCompositesMap.get(MethodValues.POST), opIdMap);
        }
        if (this.hasGETMethod()) {
            this.validateOpId(this.methodCompositesMap.get(MethodValues.GET), opIdMap);
        }
        if (this.hasPUTMethod()) {
            this.validateOpId(this.methodCompositesMap.get(MethodValues.PUT), opIdMap);
        }
        if (this.hasDELETEMethod()) {
            this.validateOpId(this.methodCompositesMap.get(MethodValues.DELETE), opIdMap);
        }
        if (this.hasPATCHMethod()) {
            this.validateOpId(this.methodCompositesMap.get(MethodValues.PATCH), opIdMap);
        }
        if (this.hasHEADMethod()) {
            this.validateOpId(this.methodCompositesMap.get(MethodValues.HEAD), opIdMap);
        }
    }

    private void validateOpId(ApiEditorMethodComposite cmpMethod, Map<String, Integer> opIdMap) {
        String opIdText = XSwt.getTrimText((Text)cmpMethod.getTxtMethodOperationId());
        boolean isServiceRefSet = StringUtils.isNotBlank((CharSequence)cmpMethod.getMethodType().getZosConnectServiceRef());
        this.clearDuplicateOpId(cmpMethod);
        if (isServiceRefSet && opIdMap.containsKey(opIdText) && opIdMap.get(opIdText) > 1) {
            this.flagDuplicateOpId(opIdText, cmpMethod);
        }
        this.clearEmptyOpId(cmpMethod);
        if (isServiceRefSet && StringUtils.isBlank((CharSequence)opIdText)) {
            this.flagEmptyOpId(cmpMethod);
        }
    }

    private void flagEmptyOpId(ApiEditorMethodComposite cmpMethod) {
        this.messageMgr.addMessage((Object)"BLANK_OPERATION_ID_ERROR", Xlat.error((String)"BLANK_OPERATION_ID_ERROR", (String[])new String[]{this.logicalParent.getPathType().getRelativePath(), cmpMethod.getMethodType().getType().toString()}), null, 3, (Control)cmpMethod.getTxtMethodOperationId());
        XSwt.setForeground((Text)cmpMethod.getTxtMethodOperationId(), (int)3);
    }

    private void clearEmptyOpId(ApiEditorMethodComposite cmpMethod) {
        this.messageMgr.removeMessage((Object)"BLANK_OPERATION_ID_ERROR", (Control)cmpMethod.getTxtMethodOperationId());
        XSwt.setForeground((Text)cmpMethod.getTxtMethodOperationId(), (Color)this.toolkit.getColors().getForeground());
    }

    private void flagDuplicateOpId(String opIdText, ApiEditorMethodComposite cmpMethod) {
        this.messageMgr.addMessage((Object)"DUPLICATE_OPERATION_ID_ERROR", Xlat.error((String)"DUPLICATE_OPERATION_ID_ERROR", (String[])new String[]{opIdText, this.logicalParent.getPathType().getRelativePath(), cmpMethod.getMethodType().getType().toString()}), null, 3, (Control)cmpMethod.getTxtMethodOperationId());
        XSwt.setForeground((Text)cmpMethod.getTxtMethodOperationId(), (int)3);
    }

    private void clearDuplicateOpId(ApiEditorMethodComposite cmpMethod) {
        this.messageMgr.removeMessage((Object)"DUPLICATE_OPERATION_ID_ERROR", (Control)cmpMethod.getTxtMethodOperationId());
        XSwt.setForeground((Text)cmpMethod.getTxtMethodOperationId(), (Color)this.toolkit.getColors().getForeground());
    }

    private Map<String, Integer> getOpIdsWithCount() {
        HashMap<String, Integer> opIdsMap = new HashMap<String, Integer>();
        ApiModelController apiModelController = this.getApiModelController();
        for (PathType pathType : apiModelController.getApiPaths()) {
            for (MethodType methodType : pathType.getMethod()) {
                String operationId = StringUtils.trimToEmpty((String)methodType.getOperationId());
                Integer count = (Integer)opIdsMap.get(operationId);
                if (count == null) {
                    opIdsMap.put(operationId, new Integer(1));
                    continue;
                }
                count = new Integer(count + 1);
                opIdsMap.put(operationId, count);
            }
        }
        return opIdsMap;
    }

    @Override
    public void updateWidgetEnablements(boolean enabled) {
        if (this.hasPOSTMethod()) {
            this.updateWidgetEnablement(this.methodCompositesMap.get(MethodValues.POST), enabled);
        }
        if (this.hasGETMethod()) {
            this.updateWidgetEnablement(this.methodCompositesMap.get(MethodValues.GET), enabled);
        }
        if (this.hasPUTMethod()) {
            this.updateWidgetEnablement(this.methodCompositesMap.get(MethodValues.PUT), enabled);
        }
        if (this.hasDELETEMethod()) {
            this.updateWidgetEnablement(this.methodCompositesMap.get(MethodValues.DELETE), enabled);
        }
        if (this.hasPATCHMethod()) {
            this.updateWidgetEnablement(this.methodCompositesMap.get(MethodValues.PATCH), enabled);
        }
        if (this.hasHEADMethod()) {
            this.updateWidgetEnablement(this.methodCompositesMap.get(MethodValues.HEAD), enabled);
        }
    }

    private void updateWidgetEnablement(ApiEditorMethodComposite composite, boolean enabled) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        XSwt.setEnabled((Control)composite.getImgMethodMoveUp(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getImgMethodMoveDown(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getImgMethodRemove(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getBtnMethodService(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getBtnEditMapping(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getTxtMethodService(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getCmpMethodDescription().getTxtMethodSummary(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getCmpMethodDescription().getTxtMethodDescription(), (boolean)enabled);
    }

    public ApiEditorMethodComposite getMethodComposite(String operationId) {
        if (StringUtils.isNotBlank((CharSequence)operationId)) {
            for (ApiEditorMethodComposite cmpMethod : this.methodComposites) {
                if (!StringUtils.equals((CharSequence)operationId, (CharSequence)cmpMethod.getMethodType().getOperationId())) continue;
                return cmpMethod;
            }
        }
        return null;
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public List<ApiEditorMethodComposite> getMethodComposites() {
        return this.methodComposites;
    }
}

