/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.FormCompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormImageHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormLabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormSectionBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.dialogs.AddOrEditResponseDialog;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponseComposite;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorWidgetUpdateListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ApiEditorMethodResponsesComposite
extends Composite
implements ApiEditorWidgetUpdateListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite controlParent;
    private ApiEditorMethodComposite logicalParent;
    private FormToolkit toolkit;
    private List<ApiEditorMethodResponseComposite> responseComposites;
    private LinkedHashMap<Integer, ApiEditorMethodResponseComposite> responseCodeToCompositeMap;
    private LinkedHashMap<ResponseMessageType, ApiEditorMethodResponseComposite> responseMessageToComposite;
    private ApiEditorMethodResponsesComposite self;
    private Composite cmpMethodResponsesClient;
    private Composite cmpMethodResponsesClientCodes;
    private ImageHyperlink imgMethodResponsesTwistie;
    private ImageHyperlink imgAddResponse;
    private Hyperlink lnkResponses;
    private Section sctMethodResponses;
    private boolean initial = true;

    public ApiEditorMethodResponsesComposite(Composite controlParent, ApiEditorMethodComposite logicalParent, FormToolkit toolkit) {
        super(controlParent, 0);
        this.controlParent = controlParent;
        this.logicalParent = logicalParent;
        this.toolkit = toolkit;
        this.self = this;
        this.getParentFormPage().getWidgetUpdateListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ApiEditorMethodResponsesComposite.this.getParentFormPage().getWidgetUpdateListeners().remove(ApiEditorMethodResponsesComposite.this.self);
            }
        });
        this.responseComposites = new ArrayList<ApiEditorMethodResponseComposite>();
        this.responseCodeToCompositeMap = new LinkedHashMap();
        this.responseMessageToComposite = new LinkedHashMap();
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayoutBuilder().numColumns(2).marginWidth(0).marginHeight(0).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).verticalIndent(15).build());
        this.createContent();
        this.initial = false;
    }

    public void createContent() {
        this.imgMethodResponsesTwistie = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).toolTipText(Xlat.description((String)"TOOLTIP_HIDE_SHOW_METHOD_RESPONSES", (String[])new String[]{this.logicalParent.getMethodName()})).image(XImg.icon((String)"arrow_right_big.png")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.isExpanded((Section)ApiEditorMethodResponsesComposite.this.sctMethodResponses)) {
                    ApiEditorMethodResponsesComposite.this.collapseResponsesSection(true);
                } else {
                    ApiEditorMethodResponsesComposite.this.expandResponsesSection(true);
                }
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build((Composite)this);
        this.lnkResponses = (Hyperlink)new FormHyperlinkBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_LABEL_RESPONSES")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.isExpanded((Section)ApiEditorMethodResponsesComposite.this.sctMethodResponses)) {
                    ApiEditorMethodResponsesComposite.this.collapseResponsesSection(true);
                } else {
                    ApiEditorMethodResponsesComposite.this.expandResponsesSection(true);
                }
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build((Composite)this);
        new FormLabelBuilder(this.toolkit).horizontalAlignment(16384).heightHint(0).build((Composite)this);
        this.sctMethodResponses = (Section)new FormSectionBuilder(this.toolkit).style(Integer.valueOf(20576)).grabExcessHorizontalSpace(true).build((Composite)this);
        this.cmpMethodResponsesClient = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(1).marginHeight(0).marginWidth(0).verticalSpacing(5).build((Composite)this.sctMethodResponses);
        this.cmpMethodResponsesClientCodes = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(1).marginHeight(0).marginWidth(0).grabExcessHorizontalSpace(true).horizontalSpan(2).verticalIndent(5).build(this.cmpMethodResponsesClient);
        for (ResponseMessageType responseMessage : this.getResponseMessages()) {
            this.addResponse(responseMessage);
        }
        Composite cmpAddResponse = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(2).marginHeight(0).marginWidth(0).verticalIndent(5).build(this.cmpMethodResponsesClient);
        this.imgAddResponse = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).toolTipText(Xlat.description((String)"TOOLTIP_ADD_RESPONSE", (String[])new String[]{this.logicalParent.getMethodName()})).image(XImg.icon((String)"icon-add@x1.png")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.getText((Text)ApiEditorMethodResponsesComposite.this.logicalParent.getTxtMethodService()).isEmpty()) {
                    new ApiEditorMessageDialog(ApiEditorMethodResponsesComposite.this.getShell(), false).openInfo(Xlat.description((String)"INFO_ASSIGN_SERVICE_FOR_RESPONSES"));
                    return;
                }
                AddOrEditResponseDialog dialog = new AddOrEditResponseDialog(ApiEditorMethodResponsesComposite.this.getShell(), ApiEditorMethodResponsesComposite.this.self, Xlat.label((String)"APIDLG_TITLE_ADD_RESPONSE"), ApiEditorMethodResponsesComposite.this.toolkit);
                if (dialog.open() == 0) {
                    ApiEditorMethodResponsesComposite.this.addNewResponse(dialog);
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodResponsesComposite.this.imgAddResponse, (String)"icon-add-hover@x1.png");
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodResponsesComposite.this.imgAddResponse, (String)"icon-add@x1.png");
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build(cmpAddResponse);
        new FormLabelBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_LABEL_ADD_RESPONSE")).horizontalAlignment(16384).verticalAlignment(0x1000000).build(cmpAddResponse);
        this.sctMethodResponses.setClient((Control)this.cmpMethodResponsesClient);
        this.sctMethodResponses.setExpanded(false);
    }

    public void expandResponsesSection(boolean updateFocus) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        XImg.setIcon((ImageHyperlink)this.imgMethodResponsesTwistie, (String)"arrow_down_big.png");
        XSwt.expand((Section)this.sctMethodResponses);
        XSwt.focus((Control)this.imgMethodResponsesTwistie);
        if (updateFocus) {
            XSwt.show((ScrolledForm)this.getScrolledForm(), (Control)this.sctMethodResponses);
            XSwt.focus((Control)((Control)ListUtilz.getLastMember(this.responseComposites)));
        }
    }

    public void collapseResponsesSection(boolean updateFocus) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        XImg.setIcon((ImageHyperlink)this.imgMethodResponsesTwistie, (String)"arrow_right_big.png");
        XSwt.collapse((Section)this.sctMethodResponses);
        if (updateFocus) {
            XSwt.focus((Control)this.imgMethodResponsesTwistie);
        }
    }

    public void addNewResponse(AddOrEditResponseDialog dialog) {
        ResponseMessageType responseMessage = new ResponseMessageType();
        ServiceMappingController controller = this.getServiceMappingController();
        controller.addResponseMessage(responseMessage);
        controller.setCode(responseMessage, dialog.getResponseCode());
        controller.setDescription(responseMessage, dialog.getDescription());
        responseMessage.setBooleanExpression(dialog.getExpression());
        ApiEditorMethodResponseComposite responseComposite = this.addResponse(responseMessage);
        this.moveResponseUp(responseComposite);
        this.getParentFormPage().setDirty(true);
    }

    public ApiEditorMethodResponseComposite addResponse(ResponseMessageType responseMessage) {
        if (XSwt.isDisposed((Control)this.self)) {
            return null;
        }
        ApiEditorMethodResponseComposite responseComposite = new ApiEditorMethodResponseComposite(this.cmpMethodResponsesClientCodes, this, responseMessage, this.toolkit);
        this.responseComposites.add(responseComposite);
        this.responseCodeToCompositeMap.put(responseMessage.getCode(), responseComposite);
        this.responseMessageToComposite.put(responseMessage, responseComposite);
        this.updateResponsesHyperlink();
        XSwt.layout((Composite)this.cmpMethodResponsesClientCodes, (boolean)true);
        XSwt.reflow((ScrolledForm)this.getScrolledForm());
        XSwt.focus((Control)responseComposite);
        return responseComposite;
    }

    public void removeResponse(ResponseMessageType responseMessage) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        ApiEditorMethodResponseComposite responseComposite = this.responseMessageToComposite.get(responseMessage);
        if (responseComposite == null) {
            return;
        }
        this.responseComposites.remove(responseComposite);
        this.responseCodeToCompositeMap.remove(responseComposite.getResponseCode());
        this.responseMessageToComposite.remove(responseComposite.getResponseMessageType());
        this.getServiceMappingController().removeResponseMessage(responseComposite.getResponseMessageType());
        responseComposite.dispose();
        if (!this.initial) {
            this.getParentFormPage().setDirty(true);
        }
        this.updateResponsesHyperlink();
        XSwt.layout((Composite)this.cmpMethodResponsesClientCodes, (boolean)true);
        XSwt.reflow((ScrolledForm)this.getScrolledForm());
        XSwt.focus((Control)this.getFirstResponse());
    }

    public void moveResponseUp(ApiEditorMethodResponseComposite composite) {
        int sourceIndex = this.responseComposites.indexOf(composite);
        int targetIndex = sourceIndex - 1;
        if (sourceIndex == -1 || sourceIndex == 0 || targetIndex < 0) {
            return;
        }
        ApiEditorMethodResponseComposite targetComposite = this.responseComposites.get(targetIndex);
        this.responseComposites.set(targetIndex, composite);
        this.responseComposites.set(sourceIndex, targetComposite);
        ServiceMappingController serviceMappingController = composite.getServiceMappingController();
        serviceMappingController.moveResponseUp(composite.getResponseMessageType());
        composite.moveAbove((Control)targetComposite);
        if (!this.initial) {
            this.getParentFormPage().setDirty(true);
        }
        XSwt.layout((Composite)this.cmpMethodResponsesClientCodes, (boolean)true);
        XSwt.expand((Section)this.sctMethodResponses);
    }

    public void moveResponseDown(ApiEditorMethodResponseComposite composite) {
        int sourceModelIndex = this.responseComposites.indexOf(composite);
        int targetModelIndex = sourceModelIndex + 1;
        if (sourceModelIndex == -1 || sourceModelIndex == this.responseComposites.size() - 1 || targetModelIndex >= this.responseComposites.size()) {
            return;
        }
        ApiEditorMethodResponseComposite targetComposite = this.responseComposites.get(targetModelIndex);
        this.responseComposites.set(targetModelIndex, composite);
        this.responseComposites.set(sourceModelIndex, targetComposite);
        ServiceMappingController serviceMappingController = composite.getServiceMappingController();
        serviceMappingController.moveResponseDown(composite.getResponseMessageType());
        composite.moveBelow((Control)targetComposite);
        if (!this.initial) {
            this.getParentFormPage().setDirty(true);
        }
        XSwt.layout((Composite)this.cmpMethodResponsesClientCodes, (boolean)true);
        XSwt.expand((Section)this.sctMethodResponses);
    }

    public boolean isFirstResponse(ApiEditorMethodResponseComposite cmpMethodResponse) {
        return ListUtilz.isFirstMember(this.responseComposites, (Object)cmpMethodResponse);
    }

    public boolean isLastResponse(ApiEditorMethodResponseComposite cmpMethodResponse) {
        return ListUtilz.isLastMember(this.responseComposites, (Object)cmpMethodResponse);
    }

    public ApiEditorMethodResponseComposite getLastResponse() {
        return (ApiEditorMethodResponseComposite)ListUtilz.getLastMember(this.responseComposites);
    }

    public boolean is2ndToLastResponse(ApiEditorMethodResponseComposite cmpMethodResponse) {
        int responseIdx;
        int responseCnt = this.responseComposites.size();
        return responseCnt - ((responseIdx = this.responseComposites.indexOf(cmpMethodResponse)) + 1) == 1;
    }

    public ApiEditorMethodResponseComposite get2ndToLastResponse() {
        int responseIdx = Math.max(0, this.responseComposites.size() - 2);
        return this.responseComposites.get(responseIdx);
    }

    public ApiEditorFormPage getParentFormPage() {
        return this.logicalParent.getParentFormPage();
    }

    public ScrolledForm getScrolledForm() {
        return this.getParentFormPage().getScrolledForm();
    }

    public ZosConnectApiEditor getApiEditor() {
        return this.logicalParent.getApiEditor();
    }

    @Override
    public void updateWidgetEnablements(boolean enabled) {
        XSwt.setEnabled((Control)this.imgAddResponse, (boolean)enabled);
        for (ApiEditorMethodResponseComposite composite : this.responseComposites) {
            try {
                this.updateWidgetEnablement(composite, enabled);
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
        }
    }

    private void updateWidgetEnablement(ApiEditorMethodResponseComposite composite, boolean enabled) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        XSwt.setEnabled((Control)composite.getBtnEditResponse(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getBtnEditMapping(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getTxtDescription(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getBtnDefault(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getImgMethodResponseMoveUp(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getImgMethodResponseMoveDown(), (boolean)enabled);
        XSwt.setEnabled((Control)composite.getImgMethodResponseRemove(), (boolean)enabled);
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public ApiEditorMethodComposite getLogicalParent() {
        return this.logicalParent;
    }

    public ServiceMappingController getServiceMappingController() {
        return this.logicalParent.getServiceMappingController();
    }

    public boolean isDefaultResponseCode(Integer responseCode) {
        return this.logicalParent.isDefaultResponseCode(responseCode);
    }

    public boolean setDefaultResponseCode(Integer responseCode) {
        return this.logicalParent.setDefaultResponseCode(responseCode);
    }

    public List<Integer> getDefinedResponseCodes() {
        return this.logicalParent.getDefinedResponseCodes();
    }

    public ApiEditorMethodResponseComposite getFirstResponse() {
        return (ApiEditorMethodResponseComposite)ListUtilz.getFirstMember(this.responseComposites);
    }

    public List<ResponseMessageType> getResponseMessages() {
        return this.getServiceMappingController().getResponseMessages();
    }

    public Integer getResponseMessageCount() {
        return this.getResponseMessages().size();
    }

    public ApiEditorMethodResponseComposite getMethodResponseComposite(Integer responseCode) {
        if (responseCode != null) {
            for (ApiEditorMethodResponseComposite cmpMethodResponse : this.responseComposites) {
                if (!responseCode.equals(cmpMethodResponse.getResponseCode())) continue;
                return cmpMethodResponse;
            }
        }
        return null;
    }

    public ImageHyperlink getImgAddResponse() {
        return this.imgAddResponse;
    }

    public ImageHyperlink getImgMethodResponsesTwistie() {
        return this.imgMethodResponsesTwistie;
    }

    public Section getSctMethodResponses() {
        return this.sctMethodResponses;
    }

    public void updateResponsesHyperlink() {
        int responseCount = this.getResponseMessageCount();
        if (responseCount > 0) {
            XSwt.setText((Hyperlink)this.lnkResponses, (String)Xlat.label((String)"APIEDIT_LABEL_RESPONSES_NUM", (Object[])new Object[]{this.getResponseMessageCount()}));
        } else {
            XSwt.setText((Hyperlink)this.lnkResponses, (String)Xlat.label((String)"APIEDIT_LABEL_RESPONSES"));
        }
    }

    public List<ApiEditorMethodResponseComposite> getResponseComposites() {
        return this.responseComposites;
    }
}

