/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.service.MappingMessageType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.rules.BooleanExpression;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.FormButtonBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormImageHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormLabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormTextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.MenuItemBuilder;
import com.ibm.zosconnect.ui.common.util.swt.ModifyListener2;
import com.ibm.zosconnect.ui.common.util.swt.SelectionAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.common.validation.ApiResponseValidationProblem;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.dialogs.AddOrEditResponseDialog;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponsesComposite;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorEventListener;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;

public class ApiEditorMethodResponseComposite
extends Composite
implements ApiEditorEventListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private Composite controlParent;
    private ApiEditorMethodResponsesComposite logicalParent;
    private ResponseMessageType responseMessageType;
    private FormToolkit toolkit;
    private ApiEditorMethodResponseComposite self;
    private Button btnDefault;
    private Button btnEditResponse;
    private Button btnEditMapping;
    private Label lblResponseCode;
    private Label lblRulesPreview;
    private ImageHyperlink imgMethodResponseMoveUp;
    private ImageHyperlink imgMethodResponseMoveDown;
    private ImageHyperlink imgMethodResponseRemove;
    private Label imgDefault;
    private Text txtDescription;
    private ControlDecoration cd_btnEditResponse;
    private ControlDecoration cd_btnEditMapping;
    private Menu menuBtnEditResponse;
    private Menu menuBtnEditMapping;

    public ApiEditorMethodResponseComposite(Composite controlParent, ApiEditorMethodResponsesComposite responsesParent, ResponseMessageType responseMessage, FormToolkit toolkit) {
        super(controlParent, 0);
        this.controlParent = controlParent;
        this.logicalParent = responsesParent;
        this.responseMessageType = responseMessage;
        this.toolkit = toolkit;
        this.self = this;
        this.getApiEditor().getEditorEventListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ApiEditorMethodResponseComposite.this.getApiEditor().getEditorEventListeners().remove(ApiEditorMethodResponseComposite.this.self);
            }
        });
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayoutBuilder().numColumns(8).marginWidth(0).marginHeight(5).horizontalSpacing(MaxFieldDecorationWidth).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(1).build());
        this.createContent();
        this.validate();
    }

    public void createContent() {
        this.imgDefault = (Label)new FormLabelBuilder(this.toolkit).image(XImg.icon((String)"circle_check.png")).toolTipText(Xlat.description((String)"TOOLTIP_DEFAULT_RESPONSE")).verticalAlignment(0x1000000).visible(Boolean.valueOf(this.isDefaultResponseCode(this.getResponseCode()))).build((Composite)this);
        this.lblResponseCode = (Label)new FormLabelBuilder(this.toolkit).text(this.getResponseCodeAsString()).verticalAlignment(0x1000000).build((Composite)this);
        this.txtDescription = (Text)new FormTextBuilder(this.toolkit).text(this.getResponseMessageType().getDescription()).listener((VerifyListener)new VerifyListener2((Control)this.self){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)this.self){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ApiEditorMethodResponseComposite.this.getServiceMappingController().setDescription(ApiEditorMethodResponseComposite.this.responseMessageType, XSwt.getText((Text)ApiEditorMethodResponseComposite.this.txtDescription));
                ApiEditorMethodResponseComposite.this.getParentFormPage().setDirty(true);
            }
        }).style(Integer.valueOf(2048)).widthHint(250).grabExcessHorizontalSpace(true).build((Composite)this);
        this.btnEditResponse = (Button)new FormButtonBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_BUTTON_RESPONSE")).toolTipText(Xlat.description((String)"TOOLTIP_EDIT_RESPONSE", (String[])new String[]{this.getResponseCodeAsString()})).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                ApiEditorMethodResponseComposite.this.createAndDisplayResponseButtonMenu();
            }
        }).build((Composite)this);
        this.cd_btnEditResponse = new ControlDecoration((Control)this.btnEditResponse, 17408);
        this.btnEditMapping = (Button)new FormButtonBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_BUTTON_MAPPING")).toolTipText(Xlat.description((String)"TOOLTIP_EDIT_RESPONSE_MAPPING", (String[])new String[]{this.getResponseCodeAsString()})).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                ApiEditorMethodResponseComposite.this.createAndDisplayMappingButtonMenu();
            }
        }).build((Composite)this);
        this.cd_btnEditMapping = new ControlDecoration((Control)this.btnEditMapping, 17408);
        this.imgMethodResponseMoveUp = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-move-up@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_INCREASE_RESPONSE_PRECEDENCE", (String[])new String[]{this.getResponseCodeAsString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (ApiEditorMethodResponseComposite.this.logicalParent.isFirstResponse(ApiEditorMethodResponseComposite.this.self)) {
                    new ApiEditorMessageDialog(ApiEditorMethodResponseComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_RESPONSE_ALREADY_HIGHEST", (String[])new String[]{ApiEditorMethodResponseComposite.this.getResponseCodeAsString()}));
                } else if (ApiEditorMethodResponseComposite.this.isDefaultResponseCode(ApiEditorMethodResponseComposite.this.getResponseCode())) {
                    ApiEditorMethodResponseComposite oldDefault = ApiEditorMethodResponseComposite.this.self;
                    ApiEditorMethodResponseComposite newDefault = ApiEditorMethodResponseComposite.this.logicalParent.get2ndToLastResponse();
                    ApiEditorMethodResponseComposite.this.handleSetResponseAsDefault(oldDefault, newDefault);
                    XSwt.focus((Control)ApiEditorMethodResponseComposite.this.self);
                } else {
                    ApiEditorMethodResponseComposite.this.logicalParent.moveResponseUp(ApiEditorMethodResponseComposite.this.self);
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodResponseComposite.this.logicalParent.isFirstResponse(ApiEditorMethodResponseComposite.this.self)) {
                    XImg.setIcon((ImageHyperlink)ApiEditorMethodResponseComposite.this.imgMethodResponseMoveUp, (String)"icon-move-up-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodResponseComposite.this.imgMethodResponseMoveUp, (String)"icon-move-up@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
        this.imgMethodResponseMoveDown = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-move-down@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_DECREASE_RESPONSE_PRECEDENCE", (String[])new String[]{this.getResponseCodeAsString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (ApiEditorMethodResponseComposite.this.logicalParent.isLastResponse(ApiEditorMethodResponseComposite.this.self)) {
                    new ApiEditorMessageDialog(ApiEditorMethodResponseComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_RESPONSE_ALREADY_LOWEST", (String[])new String[]{ApiEditorMethodResponseComposite.this.getResponseCodeAsString()}));
                } else if (ApiEditorMethodResponseComposite.this.logicalParent.is2ndToLastResponse(ApiEditorMethodResponseComposite.this.self)) {
                    ApiEditorMethodResponseComposite oldDefault = ApiEditorMethodResponseComposite.this.logicalParent.getLastResponse();
                    ApiEditorMethodResponseComposite newDefault = ApiEditorMethodResponseComposite.this.self;
                    ApiEditorMethodResponseComposite.this.handleSetResponseAsDefault(oldDefault, newDefault);
                } else {
                    ApiEditorMethodResponseComposite.this.logicalParent.moveResponseDown(ApiEditorMethodResponseComposite.this.self);
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodResponseComposite.this.logicalParent.isLastResponse(ApiEditorMethodResponseComposite.this.self)) {
                    XImg.setIcon((ImageHyperlink)ApiEditorMethodResponseComposite.this.imgMethodResponseMoveDown, (String)"icon-move-down-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodResponseComposite.this.imgMethodResponseMoveDown, (String)"icon-move-down@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
        this.imgMethodResponseRemove = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-delete@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_DELETE_RESPONSE", (String[])new String[]{this.getResponseCodeAsString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (ApiEditorMethodResponseComposite.this.isDefaultResponseCode(ApiEditorMethodResponseComposite.this.getResponseCode())) {
                    new ApiEditorMessageDialog(ApiEditorMethodResponseComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_RESPONSE_DEFAULT_DELETE", (String[])new String[]{ApiEditorMethodResponseComposite.this.getResponseCodeAsString()}));
                    return;
                }
                ApiEditorMessageDialog dialog = new ApiEditorMessageDialog(XSwt.getActiveShell(), true);
                if (!dialog.openConfirm(Xlat.description((String)"CONFIRM_DELETE_RESP_CODE", (Object[])new Object[]{ApiEditorMethodResponseComposite.this.getResponseCode()}))) {
                    return;
                }
                ApiEditorMethodResponseComposite.this.logicalParent.removeResponse(ApiEditorMethodResponseComposite.this.getResponseMessageType());
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodResponseComposite.this.isDefaultResponseCode(ApiEditorMethodResponseComposite.this.getResponseCode())) {
                    XImg.setIcon((ImageHyperlink)ApiEditorMethodResponseComposite.this.imgMethodResponseRemove, (String)"icon-delete-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodResponseComposite.this.imgMethodResponseRemove, (String)"icon-delete@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
        this.validate();
    }

    private void createAndDisplayResponseButtonMenu() {
        Integer responseCode = this.responseMessageType.getCode();
        XSwt.dispose((Menu)this.menuBtnEditResponse);
        this.menuBtnEditResponse = new Menu((Control)this.btnEditResponse);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_EDIT_RESP_CODE", (Object[])new Object[]{responseCode})).image(XImg.icon((String)"edit.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (XSwt.getText((Text)ApiEditorMethodResponseComposite.this.logicalParent.getLogicalParent().getTxtMethodService()).isEmpty()) {
                    new ApiEditorMessageDialog(ApiEditorMethodResponseComposite.this.getShell(), false).openInfo(Xlat.description((String)"INFO_ASSIGN_SERVICE_FOR_RESPONSES"));
                    return;
                }
                ApiEditorMethodResponseComposite.this.handleEditResponse();
            }
        }).build((Widget)this.menuBtnEditResponse);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_SET_DFLT_RESP_CODE", (Object[])new Object[]{responseCode})).image(XImg.icon((String)"circle_check.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                ApiEditorMethodResponseComposite.this.handleSetResponseAsDefault(ApiEditorMethodResponseComposite.this.logicalParent.getLastResponse(), ApiEditorMethodResponseComposite.this.self);
            }
        }).enabled(Boolean.valueOf(!this.logicalParent.isLastResponse(this.self))).build((Widget)this.menuBtnEditResponse);
        XSwt.setVisible((Menu)this.menuBtnEditResponse, (boolean)true);
    }

    public void handleEditResponse() {
        AddOrEditResponseDialog dialog = new AddOrEditResponseDialog(this.getShell(), this.logicalParent, this.self, Xlat.label((String)"APIDLG_TITLE_EDIT_RESPONSE", (String[])new String[]{this.getResponseCodeAsString()}), this.toolkit);
        if (dialog.open() == 0) {
            int oldResponseCode = this.getResponseCode();
            int newResponseCode = dialog.getResponseCode();
            if (this.isDefaultResponseCode(oldResponseCode)) {
                this.setDefaultResponseCode(newResponseCode);
            }
            String newDescription = dialog.getDescription();
            XSwt.setText((Label)this.lblResponseCode, (Integer)newResponseCode);
            XSwt.setText((Text)this.txtDescription, (String)newDescription);
            ServiceMappingController controller = this.getServiceMappingController();
            controller.setCode(this.responseMessageType, Integer.valueOf(newResponseCode));
            controller.setDescription(this.responseMessageType, newDescription);
            controller.setBooleanExpression(this.responseMessageType, dialog.getExpression());
            this.getParentFormPage().setDirty(true);
            this.updateTooltips();
            XSwt.layout((Composite)this.self, (boolean)true);
            XSwt.reflow((ScrolledForm)this.getScrolledForm());
        }
    }

    private void handleSetResponseAsDefault(ApiEditorMethodResponseComposite oldDefault, ApiEditorMethodResponseComposite newDefault) {
        this.setDefaultResponseCode(newDefault.getResponseCode());
        this.getParentFormPage().setDirty(true);
        while (!this.logicalParent.isLastResponse(newDefault)) {
            this.logicalParent.moveResponseDown(newDefault);
        }
        XSwt.setVisible((Control)oldDefault.imgDefault, (boolean)false);
        XSwt.setVisible((Control)newDefault.imgDefault, (boolean)true);
        XSwt.layout((Composite)oldDefault, (boolean)true);
        XSwt.layout((Composite)newDefault, (boolean)true);
        XSwt.reflow((ScrolledForm)this.getScrolledForm());
        XSwt.focus((Control)newDefault.btnEditResponse);
    }

    private boolean verifyParentFormPageNotDirty() {
        if (this.getParentFormPage().isDirty()) {
            ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(XSwt.getActiveShell(), false);
            if (messageDialog.openConfirm(Xlat.description((String)"INFO_LAUNCH_MAPPING"))) {
                this.getApiEditor().doSave((IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            return false;
        }
        return true;
    }

    private void createAndDisplayMappingButtonMenu() throws Exception {
        final Integer responseCode = this.responseMessageType.getCode();
        XSwt.dispose((Menu)this.menuBtnEditMapping);
        this.menuBtnEditMapping = new Menu((Control)this.btnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_OPEN_RESP_CODE_MAP", (Object[])new Object[]{responseCode})).image(XImg.icon((String)"icon-open-resp-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                IFile responseMappingFile;
                if (XSwt.getText((Text)ApiEditorMethodResponseComposite.this.logicalParent.getLogicalParent().getTxtMethodService()).isEmpty()) {
                    new ApiEditorMessageDialog(ApiEditorMethodResponseComposite.this.getShell(), false).openInfo(Xlat.description((String)"INFO_ASSIGN_SERVICE_FOR_MAPPING"));
                    return;
                }
                if (!ApiEditorMethodResponseComposite.this.verifyParentFormPageNotDirty()) {
                    return;
                }
                if (ApiEditorMethodResponseComposite.this.generateResponseMappingFile(ApiEditorMethodResponseComposite.this.responseMessageType)) {
                    ApiEditorMethodResponseComposite.this.generateServiceMapping(true);
                    ApiEditorMethodResponseComposite.this.reloadResponseMapping(ApiEditorMethodResponseComposite.this.responseMessageType);
                }
                if ((responseMappingFile = ApiEditorMethodResponseComposite.this.getResponseMappingFile(ApiEditorMethodResponseComposite.this.responseMessageType)).exists()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                XSwt.getActivePage().openEditor((IEditorInput)new FileEditorInput(responseMappingFile), "com.ibm.msl.mapping.internal.ui.editor.MappingEditor");
                            }
                            catch (PartInitException e) {
                                ZCeeUILogger.error((Throwable)e);
                            }
                        }
                    });
                }
            }
        }).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_CLEAR_RESP_CODE_MAP", (Object[])new Object[]{responseCode})).image(XImg.icon((String)"icon-clear-resp-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodResponseComposite.this.verifyParentFormPageNotDirty()) {
                    return;
                }
                ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(ApiEditorMethodResponseComposite.this.getShell(), false);
                if (messageDialog.openConfirm(Xlat.description((String)"CONFIRM_CLEAR_RESP_CODE_MAP", (Object[])new Object[]{responseCode}))) {
                    ApiEditorMethodResponseComposite.this.getServiceMappingController().deleteResponseMapping(ApiEditorMethodResponseComposite.this.responseMessageType);
                }
            }
        }).enabled(Boolean.valueOf(this.hasResponseMapping(this.responseMessageType))).build((Widget)this.menuBtnEditMapping);
        XSwt.setVisible((Menu)this.menuBtnEditMapping, (boolean)true);
    }

    public void updateTooltips() {
        XSwt.setTooltipText((Control)this.btnEditResponse, (String)Xlat.description((String)"TOOLTIP_EDIT_RESPONSE", (String[])new String[]{this.getResponseCodeAsString()}));
        XSwt.setTooltipText((Control)this.btnEditMapping, (String)Xlat.description((String)"TOOLTIP_EDIT_RESPONSE_MAPPING", (String[])new String[]{this.getResponseCodeAsString()}));
        XSwt.setTooltipText((Control)this.imgMethodResponseMoveUp, (String)Xlat.description((String)"TOOLTIP_INCREASE_RESPONSE_PRECEDENCE", (String[])new String[]{this.getResponseCodeAsString()}));
        XSwt.setTooltipText((Control)this.imgMethodResponseMoveDown, (String)Xlat.description((String)"TOOLTIP_DECREASE_RESPONSE_PRECEDENCE", (String[])new String[]{this.getResponseCodeAsString()}));
        XSwt.setTooltipText((Control)this.imgMethodResponseRemove, (String)Xlat.description((String)"TOOLTIP_DELETE_RESPONSE", (String[])new String[]{this.getResponseCodeAsString()}));
    }

    public ApiEditorMethodResponsesComposite getLogicalParent() {
        return this.logicalParent;
    }

    public ApiEditorFormPage getParentFormPage() {
        return this.logicalParent.getParentFormPage();
    }

    public ScrolledForm getScrolledForm() {
        return this.getParentFormPage().getScrolledForm();
    }

    public ZosConnectApiEditor getApiEditor() {
        return this.getParentFormPage().getApiEditor();
    }

    public ServiceMappingController getServiceMappingController() {
        return this.logicalParent.getLogicalParent().getServiceMappingController();
    }

    public PathType getPathType() {
        return this.logicalParent.getLogicalParent().getPathType();
    }

    public MethodType getMethodType() {
        return this.logicalParent.getLogicalParent().getMethodType();
    }

    public ApiProjectController getApiProjectController() {
        return this.logicalParent.getLogicalParent().getApiProjectController();
    }

    public ApiModelController getApiModelController() {
        return this.logicalParent.getLogicalParent().getApiModelController();
    }

    public ServiceArchiveController getServiceArchiveController() {
        return this.getServiceMappingController().getServiceArchiveController();
    }

    public boolean isDefaultResponseCode(Integer responseCode) {
        return this.logicalParent.getLogicalParent().isDefaultResponseCode(responseCode);
    }

    public boolean setDefaultResponseCode(Integer responseCode) {
        return this.logicalParent.getLogicalParent().setDefaultResponseCode(responseCode);
    }

    public Integer getDefaultResponseCode() {
        return this.logicalParent.getLogicalParent().getDefaultResponseCode();
    }

    public List<Integer> getDefinedResponseCodes() {
        return this.logicalParent.getLogicalParent().getDefinedResponseCodes();
    }

    public boolean hasResponseMapping(ResponseMessageType responseMessageType) throws Exception {
        return this.getServiceMappingController().hasMapping((MappingMessageType)responseMessageType);
    }

    public boolean generateResponseMappingFile(ResponseMessageType responseMessageType) throws Exception {
        return this.getServiceMappingController().generateResponseMappingFile(responseMessageType);
    }

    public IFile getResponseMappingFile(ResponseMessageType responseMessageType) throws Exception {
        return this.getServiceMappingController().getResponseMappingFile(responseMessageType);
    }

    public void generateServiceMapping(boolean marshall) throws Exception {
        this.getServiceMappingController().updateServiceMapping(marshall);
    }

    public void reloadResponseMapping(ResponseMessageType responseMessageType) throws Exception {
        this.getServiceMappingController().reloadResponseMapping(responseMessageType);
    }

    public IFile getPackageXmlFile() {
        return this.getApiModelController().getPackageXmlFile();
    }

    public String getOperationId() {
        return this.getServiceMappingController().getOperationId();
    }

    public Integer getResponseCode() {
        Integer responseCode = null;
        if (this.responseMessageType != null) {
            responseCode = this.responseMessageType.getCode();
        }
        return responseCode;
    }

    public String getDescription() {
        String description = null;
        if (this.responseMessageType != null) {
            description = this.responseMessageType.getDescription();
        }
        return StringUtils.trimToEmpty(description);
    }

    public String getResponseCodeAsString() {
        String responseCodeStr = "";
        Integer responseCode = this.getResponseCode();
        if (responseCode != null) {
            responseCodeStr = String.valueOf(responseCode);
        }
        return responseCodeStr;
    }

    public String getDefaultResponseCodeAsString() {
        String defaultRespCodeStr = "";
        Integer defaultRespCode = this.getDefaultResponseCode();
        if (defaultRespCode != null) {
            defaultRespCodeStr = String.valueOf(defaultRespCode);
        }
        return defaultRespCodeStr;
    }

    public ResponseMessageType getResponseMessageType() {
        return this.responseMessageType;
    }

    public BooleanExpression getBooleanExpression() {
        return this.responseMessageType.getBooleanExpression();
    }

    public IFile getMappingFile() throws Exception {
        IFile mappingFile = null;
        if (this.getServiceMappingController().hasMapping((MappingMessageType)this.responseMessageType)) {
            mappingFile = this.getServiceMappingController().getResponseMappingFile(this.responseMessageType);
        }
        return mappingFile;
    }

    public Button getBtnDefault() {
        return this.btnDefault;
    }

    public Label getLblResponseCode() {
        return this.lblResponseCode;
    }

    public Text getTxtDescription() {
        return this.txtDescription;
    }

    public Button getBtnEditResponse() {
        return this.btnEditResponse;
    }

    public Button getBtnEditMapping() {
        return this.btnEditMapping;
    }

    public ImageHyperlink getImgMethodResponseMoveUp() {
        return this.imgMethodResponseMoveUp;
    }

    public ImageHyperlink getImgMethodResponseMoveDown() {
        return this.imgMethodResponseMoveDown;
    }

    public ImageHyperlink getImgMethodResponseRemove() {
        return this.imgMethodResponseRemove;
    }

    public Label getLblRulesPreview() {
        return this.lblRulesPreview;
    }

    public boolean getFocus() {
        return XSwt.hasFocus((Control)this.txtDescription);
    }

    public boolean setFocus() {
        return XSwt.focus((Control)this.txtDescription);
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public void validate() {
        try {
            if (!this.isDefaultResponseCode(this.getResponseCode()) && ApiResponseValidationProblem.hasErrorMarkers((IFile)this.getPackageXmlFile(), (String)this.getOperationId(), (Integer)this.getResponseCode())) {
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_btnEditResponse, (String)Xlat.error((String)"RESPONSE_HAS_ERRORS", (Object[])new Object[]{this.getResponseCode()}));
            } else {
                XSwt.hideFieldDecoration((ControlDecoration)this.cd_btnEditResponse);
            }
            if (MappingValidationProblem2.hasErrorMarkers((IFile)this.getMappingFile())) {
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_btnEditMapping, (String)Xlat.error((String)"RESPONSE_MAPPPING_HAS_ERRORS", (Object[])new Object[]{this.getResponseCode()}));
            } else {
                XSwt.hideFieldDecoration((ControlDecoration)this.cd_btnEditMapping);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    @Override
    public void beforeSave(ZosConnectApiEditor editor) {
    }

    @Override
    public void save(ZosConnectApiEditor editor) {
    }

    @Override
    public void fileMarkersChanged(IFile file) {
        this.validate();
    }
}

