/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.MethodType;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.api.mapping.service.MappingMessageType;
import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.FormButtonBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormCompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormImageHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormLabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormSectionBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormTextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.MenuItemBuilder;
import com.ibm.zosconnect.ui.common.util.swt.ModifyListener2;
import com.ibm.zosconnect.ui.common.util.swt.MouseAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.MouseTrackAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.SelectionAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.OpenApi2xController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.dialogs.ServiceSelectionDialog;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodDescriptionComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponsesComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodsComposite;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorEventListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

public class ApiEditorMethodComposite
extends Composite
implements ApiEditorEventListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private Composite controlParent;
    private ApiEditorMethodsComposite logicalParent;
    private MethodType methodType;
    private ServiceMappingController serviceMappingController;
    private FormToolkit toolkit;
    private ApiEditorMethodComposite self;
    private ApiEditorMethodResponsesComposite cmpMethodResponses;
    private ApiEditorMethodDescriptionComposite cmpMethodDescription;
    private Button btnMethodService;
    private Button btnEditMapping;
    private Composite cmpMethodDetail;
    private Composite cmpMethodDetailClient;
    private ImageHyperlink imgMethodTwistie;
    private ImageHyperlink imgMethodRemove;
    private ImageHyperlink imgMethodMoveUp;
    private ImageHyperlink imgMethodMoveDown;
    private ImageHyperlink imgMethod;
    private Text txtMethodService;
    private Text txtMethodOperationId;
    private Section sctMethodDetail;
    private ControlDecoration cd_btnEditMapping;
    public Menu menuBtnEditMapping;

    public ApiEditorMethodComposite(Composite controlParent, ApiEditorMethodsComposite logicalParent, MethodType methodType, ServiceMappingController serviceMappingController, FormToolkit toolkit) {
        super(controlParent, 0);
        this.controlParent = controlParent;
        this.logicalParent = logicalParent;
        this.methodType = methodType;
        this.serviceMappingController = serviceMappingController;
        this.toolkit = toolkit;
        this.self = this;
        this.getApiEditor().getEditorEventListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ApiEditorMethodComposite.this.getApiEditor().getEditorEventListeners().remove(ApiEditorMethodComposite.this.self);
            }
        });
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayoutBuilder().numColumns(8).marginWidth(5).marginHeight(5).verticalSpacing(0).horizontalSpacing(MaxFieldDecorationWidth).build());
        this.setLayoutData(new GridDataBuilder().widthHint(725).build());
        this.createContent();
        this.validate();
    }

    public void createContent() {
        this.addImgMethodDetailsTwistie();
        this.addImgMethod();
        this.addTxtMethodService();
        this.addBtnMethodService();
        this.addBtnMethodMapping();
        this.addImgMethodMoveUp();
        this.addImgMethodMoveDown();
        this.addImgMethodRemove();
        this.addCmpMethodDetail();
        this.addMethodResponsesSection();
        this.addMethodDocumentationSection();
    }

    private void addCmpMethodDetail() {
        new FormLabelBuilder(this.toolkit).horizontalAlignment(16384).verticalAlignment(0x1000000).heightHint(1).build((Composite)this);
        this.cmpMethodDetail = (Composite)new FormCompositeBuilder(this.toolkit).marginWidth(0).marginHeight(0).verticalSpacing(0).horizontalSpan(7).grabExcessHorizontalSpace(true).build((Composite)this);
        this.sctMethodDetail = (Section)new FormSectionBuilder(this.toolkit).style(Integer.valueOf(20576)).grabExcessHorizontalSpace(true).build(this.cmpMethodDetail);
        this.cmpMethodDetailClient = (Composite)new FormCompositeBuilder(this.toolkit).marginHeight(5).marginWidth(0).verticalSpacing(0).grabExcessHorizontalSpace(true).build((Composite)this.sctMethodDetail);
        new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_OPERATION_ID")).grabExcessHorizontalSpace(true).build(this.cmpMethodDetailClient);
        this.txtMethodOperationId = (Text)new FormTextBuilder(this.toolkit).text(this.methodType.getOperationId()).listener((VerifyListener)new VerifyListener2((Control)this.cmpMethodDetailClient){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)this.cmpMethodDetailClient){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                String operationId = XSwt.getTrimText((Text)ApiEditorMethodComposite.this.txtMethodOperationId);
                ApiEditorMethodComposite.this.methodType.setOperationId(operationId);
                ApiEditorMethodComposite.this.getParentFormPage().setDirty(true);
                ApiEditorMethodComposite.this.getParentFormPage().notifyApiMethodsListeners(ApiEditorMethodComposite.this.logicalParent, ApiEditorMethodComposite.this.methodType.getType());
                ApiEditorMethodComposite.this.getParentFormPage().notifyWidgetUpdateListeners();
            }
        }).style(Integer.valueOf(2048)).grabExcessHorizontalSpace(true).verticalIndent(5).build(this.cmpMethodDetailClient);
        this.sctMethodDetail.setClient((Control)this.cmpMethodDetailClient);
        this.sctMethodDetail.setExpanded(false);
    }

    private void addImgMethodDetailsTwistie() {
        this.imgMethodTwistie = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).toolTipText(Xlat.description((String)"TOOLTIP_HIDE_SHOW_METHOD_DETAIL", (String[])new String[]{this.getMethodName()})).image(XImg.icon((String)"arrow_right_big.png")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.isExpanded((Section)ApiEditorMethodComposite.this.sctMethodDetail)) {
                    ApiEditorMethodComposite.this.collapseMethodDetailSection(true);
                } else {
                    ApiEditorMethodComposite.this.expandMethodDetailSection(true);
                }
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addImgMethod() {
        this.imgMethod = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)(this.methodType.getType().toString() + ".png"))).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{this.methodType.getType().toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (XSwt.isExpanded((Section)ApiEditorMethodComposite.this.sctMethodDetail)) {
                    ApiEditorMethodComposite.this.collapseMethodDetailSection(true);
                } else {
                    ApiEditorMethodComposite.this.expandMethodDetailSection(true);
                }
            }
        }).listener((MouseTrackAdapter)new MouseTrackAdapter2((Control)this.self){
            final Image normal;
            final Image linked;
            Image currImage;
            {
                this.normal = XImg.icon((String)(ApiEditorMethodComposite.this.methodType.getType().toString() + ".png"));
                this.linked = XImg.icon((String)(ApiEditorMethodComposite.this.methodType.getType().toString() + "_link_hover.png"));
                this.currImage = null;
            }

            public void mouseEnter(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.linked) {
                    XSwt.setImage((ImageHyperlink)ApiEditorMethodComposite.this.imgMethod, (Image)this.linked);
                    this.currImage = this.linked;
                }
            }

            public void mouseExit(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.normal) {
                    XSwt.setImage((ImageHyperlink)ApiEditorMethodComposite.this.imgMethod, (Image)this.normal);
                    this.currImage = this.normal;
                }
            }

            public void mouseHover(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.linked) {
                    XSwt.setImage((ImageHyperlink)ApiEditorMethodComposite.this.imgMethod, (Image)this.linked);
                    this.currImage = this.linked;
                }
            }
        }).build((Composite)this);
    }

    private void addTxtMethodService() {
        this.txtMethodService = (Text)new FormTextBuilder(this.toolkit).text(this.methodType.getZosConnectServiceRef()).toolTipText(Xlat.description((String)"TOOLTIP_ZOSCONNECT_SERVICE_FOR_METHOD", (String[])new String[]{this.methodType.getType().toString()})).listener((MouseListener)new MouseAdapter2((Control)this.self){

            public void mouseDoubleClick(MouseEvent event, Control owner) throws Exception {
                ApiEditorMethodComposite.this.createAndDisplayServiceSelectionDialog();
            }
        }).style(Integer.valueOf(2056)).background(this.toolkit.getColors().getBackground()).grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addBtnMethodService() {
        this.btnMethodService = (Button)new FormButtonBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_BUTTON_SERVICE")).toolTipText(Xlat.description((String)"TOOLTIP_SELECT_ZOSCONNECT_SERVICE_FOR_METHOD", (String[])new String[]{this.methodType.getType().toString()})).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                ApiEditorMethodComposite.this.createAndDisplayServiceSelectionDialog();
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void createAndDisplayServiceSelectionDialog() throws Exception {
        ServiceSelectionDialog dialog = new ServiceSelectionDialog(this.getShell(), this.getApiProjectController(), this.getApiModelController(), false);
        if (dialog.open() == 0) {
            ApiEditorMessageDialog messageDialog;
            ServiceArchiveController serviceArchiveController = dialog.getSelectedService();
            String selectedServiceName = serviceArchiveController.getServiceName();
            String currentServiceName = XSwt.getText((Text)this.txtMethodService);
            if (!StringUtils.isBlank((CharSequence)currentServiceName) && !StringUtils.equals((CharSequence)currentServiceName, (CharSequence)selectedServiceName) && this.serviceMappingController.hasMappings() && !(messageDialog = new ApiEditorMessageDialog(XSwt.getActiveShell(), false)).openWarning(Xlat.description((String)"WARNING_CHANGE_SERVICE", (String[])new String[]{currentServiceName, selectedServiceName}))) {
                return;
            }
            XSwt.setText((Text)this.txtMethodService, (String)selectedServiceName);
            this.methodType.setZosConnectServiceRef(selectedServiceName);
            String operationId = XSwt.getTrimText((Text)this.txtMethodOperationId);
            if (StringUtils.isBlank((CharSequence)operationId)) {
                operationId = this.getApiModelController().getUniqueOperationId(this.methodType);
                this.methodType.setOperationId(operationId);
                XSwt.setText((Text)this.txtMethodOperationId, (String)operationId);
            }
            ServiceMappingController serviceMappingController = this.getServiceMappingController(this.getPathType(), this.methodType, serviceArchiveController);
            serviceMappingController.updateServiceMapping(false);
            this.getParentFormPage().setDirty(true);
        }
    }

    private void addBtnMethodMapping() {
        this.btnEditMapping = (Button)new FormButtonBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_BUTTON_MAPPING")).toolTipText(Xlat.description((String)"TOOLTIP_EDIT_SERVICE_INTERFACE_MAPPING_FOR_METHOD", (String[])new String[]{this.methodType.getType().toString()})).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ApiEditorMethodComposite.this.txtMethodService.getText().isEmpty()) {
                    new ApiEditorMessageDialog(ApiEditorMethodComposite.this.getShell(), false).openInfo(Xlat.description((String)"INFO_ASSIGN_SERVICE_FOR_MAPPING"));
                    return;
                }
                ApiEditorMethodComposite.this.createAndDisplayMappingButtonMenu();
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build((Composite)this);
        this.cd_btnEditMapping = new ControlDecoration((Control)this.btnEditMapping, 17408);
    }

    private void createAndDisplayMappingButtonMenu() throws Exception {
        XSwt.dispose((Menu)this.menuBtnEditMapping);
        this.menuBtnEditMapping = new Menu((Control)this.btnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_OPEN_REQ_MAP")).image(XImg.icon((String)"icon-open-req-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ApiEditorMethodComposite.this.verifyParentFormPageNotDirty()) {
                    ApiEditorMethodComposite.this.handleOpenRequestMapping();
                }
            }
        }).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_OPEN_DFLT_RESP_MAP")).image(XImg.icon((String)"icon-open-resp-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ApiEditorMethodComposite.this.verifyParentFormPageNotDirty()) {
                    ApiEditorMethodComposite.this.handleOpenDefaultResponseMapping();
                }
            }
        }).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_OPEN_BOTH_MAPS")).image(XImg.icon((String)"icon-open-both-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ApiEditorMethodComposite.this.verifyParentFormPageNotDirty()) {
                    ApiEditorMethodComposite.this.handleOpenRequestMapping();
                    ApiEditorMethodComposite.this.handleOpenDefaultResponseMapping();
                }
            }
        }).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().style(Integer.valueOf(2)).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_DEFINE_RESP_CODES")).image(XImg.icon((String)"icon-define-responses@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                ApiEditorMethodComposite.this.expandMethodDetailSection(true);
                ApiEditorMethodComposite.this.cmpMethodResponses.expandResponsesSection(true);
            }
        }).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().style(Integer.valueOf(2)).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_CLEAR_REQ_MAP")).image(XImg.icon((String)"icon-clear-req-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ApiEditorMethodComposite.this.verifyParentFormPageNotDirty()) {
                    ApiEditorMethodComposite.this.handleClearRequestMapping();
                }
            }
        }).enabled(Boolean.valueOf(this.serviceMappingController.hasRequestMapping())).build((Widget)this.menuBtnEditMapping);
        new MenuItemBuilder().text(Xlat.label((String)"MAPPING_BUTTON_CLEAR_DFLT_RESP_MAP")).image(XImg.icon((String)"icon-clear-resp-map@x1.png")).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ApiEditorMethodComposite.this.verifyParentFormPageNotDirty()) {
                    ApiEditorMethodComposite.this.handleClearDefaultResponseMapping();
                }
            }
        }).enabled(Boolean.valueOf(this.serviceMappingController.hasMapping((MappingMessageType)this.serviceMappingController.getDefaultResponseMessage()))).build((Widget)this.menuBtnEditMapping);
        XSwt.setVisible((Menu)this.menuBtnEditMapping, (boolean)true);
    }

    private boolean verifyParentFormPageNotDirty() {
        if (this.getParentFormPage().isDirty()) {
            ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(XSwt.getActiveShell(), false);
            if (messageDialog.openConfirm(Xlat.description((String)"INFO_LAUNCH_MAPPING"))) {
                this.getApiEditor().doSave((IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            return false;
        }
        return true;
    }

    private void handleOpenRequestMapping() throws Exception {
        IFile requestMappingFile;
        boolean requestMapCreated = this.serviceMappingController.generateRequestMapFile();
        this.serviceMappingController.updateServiceMapping(true);
        if (requestMapCreated) {
            this.serviceMappingController.reloadRequestMapping();
        }
        if ((requestMappingFile = this.serviceMappingController.getRequestMappingFile()).exists()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        XSwt.getActivePage().openEditor((IEditorInput)new FileEditorInput(requestMappingFile), "com.ibm.msl.mapping.internal.ui.editor.MappingEditor");
                    }
                    catch (PartInitException e) {
                        ZCeeUILogger.error((Throwable)e);
                    }
                }
            });
        }
    }

    private void handleOpenDefaultResponseMapping() throws Exception {
        IFile responseMappingFile;
        ResponseMessageType responseMessageType = this.serviceMappingController.getDefaultResponseMessage();
        boolean responseMapCreated = this.serviceMappingController.generateResponseMappingFile(responseMessageType);
        this.serviceMappingController.updateServiceMapping(true);
        if (responseMapCreated) {
            this.serviceMappingController.reloadResponseMapping(responseMessageType);
        }
        if ((responseMappingFile = this.serviceMappingController.getResponseMappingFile(responseMessageType)).exists()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        XSwt.getActivePage().openEditor((IEditorInput)new FileEditorInput(responseMappingFile), "com.ibm.msl.mapping.internal.ui.editor.MappingEditor");
                    }
                    catch (PartInitException e) {
                        ZCeeUILogger.error((Throwable)e);
                    }
                }
            });
        }
    }

    private void handleClearRequestMapping() throws Exception {
        if (new ApiEditorMessageDialog(XSwt.getActiveShell(), false).openConfirm(Xlat.description((String)"CONFIRM_CLEAR_REQ_MAP"))) {
            this.serviceMappingController.deleteRequestMapping();
        }
    }

    private void handleClearDefaultResponseMapping() throws Exception {
        if (new ApiEditorMessageDialog(XSwt.getActiveShell(), false).openConfirm(Xlat.description((String)"CONFIRM_CLEAR_DFLT_RESP_MAP"))) {
            this.serviceMappingController.deleteDefaultResponseMapping();
        }
    }

    private void addImgMethodMoveUp() {
        this.imgMethodMoveUp = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-move-up@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_MOVE_METHOD_UP", (String[])new String[]{this.methodType.getType().toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodComposite.this.logicalParent.isFirstMethod(ApiEditorMethodComposite.this.self)) {
                    ApiEditorMethodComposite.this.logicalParent.moveMethodUp(ApiEditorMethodComposite.this.self);
                } else {
                    new ApiEditorMessageDialog(ApiEditorMethodComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_METHOD_ALREADY_FIRST", (String[])new String[]{ApiEditorMethodComposite.this.methodType.getType().toString()}));
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodComposite.this.logicalParent.isFirstMethod(ApiEditorMethodComposite.this.self)) {
                    XImg.setIcon((ImageHyperlink)ApiEditorMethodComposite.this.imgMethodMoveUp, (String)"icon-move-up-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodComposite.this.imgMethodMoveUp, (String)"icon-move-up@x1.png");
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addImgMethodMoveDown() {
        this.imgMethodMoveDown = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-move-down@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_MOVE_METHOD_DOWN", (String[])new String[]{this.methodType.getType().toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodComposite.this.logicalParent.isLastMethod(ApiEditorMethodComposite.this.self)) {
                    ApiEditorMethodComposite.this.logicalParent.moveMethodDown(ApiEditorMethodComposite.this.self);
                } else {
                    ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(ApiEditorMethodComposite.this.getShell(), true);
                    messageDialog.openInfo(Xlat.description((String)"INFO_METHOD_ALREADY_LAST", (String[])new String[]{ApiEditorMethodComposite.this.methodType.getType().toString()}));
                }
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                if (!ApiEditorMethodComposite.this.logicalParent.isLastMethod(ApiEditorMethodComposite.this.self)) {
                    XImg.setIcon((ImageHyperlink)ApiEditorMethodComposite.this.imgMethodMoveDown, (String)"icon-move-down-hover@x1.png");
                }
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodComposite.this.imgMethodMoveDown, (String)"icon-move-down@x1.png");
            }
        }).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addImgMethodRemove() {
        this.imgMethodRemove = (ImageHyperlink)new FormImageHyperlinkBuilder(this.toolkit).image(XImg.icon((String)"icon-delete@x1.png")).toolTipText(Xlat.description((String)"TOOLTIP_REMOVE_METHOD", (String[])new String[]{this.methodType.getType().toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                if (!new ApiEditorMessageDialog(XSwt.getActiveShell(), true).openConfirm(Xlat.description((String)"CONFIRM_DELETE_METHOD", (String[])new String[]{ApiEditorMethodComposite.this.methodType.getType().toString()}))) {
                    return;
                }
                ApiEditorMethodComposite.this.logicalParent.removeMethod(ApiEditorMethodComposite.this.methodType);
            }

            public void linkEntered(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodComposite.this.imgMethodRemove, (String)"icon-delete-hover@x1.png");
            }

            public void linkExited(HyperlinkEvent event, Control owner) throws Exception {
                XImg.setIcon((ImageHyperlink)ApiEditorMethodComposite.this.imgMethodRemove, (String)"icon-delete@x1.png");
            }
        }).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addMethodResponsesSection() {
        this.cmpMethodResponses = new ApiEditorMethodResponsesComposite(this.cmpMethodDetailClient, this, this.toolkit);
    }

    private void addMethodDocumentationSection() {
        this.cmpMethodDescription = new ApiEditorMethodDescriptionComposite(this.cmpMethodDetailClient, this, this.toolkit);
    }

    public void expandMethodDetailSection(boolean updateFocus) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        XSwt.setImage((ImageHyperlink)this.imgMethodTwistie, (Image)XImg.icon((String)"arrow_down_big.png"));
        XSwt.expand((Section)this.sctMethodDetail);
        if (updateFocus) {
            XSwt.focus((Control)this.imgMethodTwistie);
            XSwt.show((ScrolledForm)this.getScrolledForm(), (Control)this.sctMethodDetail);
        }
    }

    public void collapseMethodDetailSection(boolean updateFocus) {
        if (XSwt.isDisposed((Control)this.self)) {
            return;
        }
        XImg.setIcon((ImageHyperlink)this.imgMethodTwistie, (String)"arrow_right_big.png");
        XSwt.collapse((Section)this.sctMethodDetail);
        if (updateFocus) {
            XSwt.focus((Control)this.imgMethodTwistie);
        }
    }

    public ApiEditorFormPage getParentFormPage() {
        return this.logicalParent.getParentFormPage();
    }

    public ScrolledForm getScrolledForm() {
        return this.getParentFormPage().getScrolledForm();
    }

    public ZosConnectApiEditor getApiEditor() {
        return this.getParentFormPage().getApiEditor();
    }

    public ApiProjectController getApiProjectController() {
        return this.getApiEditor().getApiProjectController();
    }

    public ServiceMappingController getServiceMappingController(PathType pathType, MethodType methodType, ServiceArchiveController serviceArchiveController) throws Exception {
        return this.getApiProjectController().getServiceMappingController(pathType, methodType, serviceArchiveController);
    }

    public ApiModelController getApiModelController() {
        return this.getApiEditor().getApiModelController();
    }

    public OpenApi2xController getOpenApi2xController() {
        return this.getApiEditor().getOpenApi2xController();
    }

    public PathType getPathType() {
        return this.logicalParent.getLogicalParent().getPathType();
    }

    public Text getTxtMethodService() {
        return this.txtMethodService;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public String getMethodName() {
        return this.methodType.getType().toString();
    }

    public ApiEditorMethodResponsesComposite getCmpMethodResponses() {
        return this.cmpMethodResponses;
    }

    public Text getTxtMethodOperationId() {
        return this.txtMethodOperationId;
    }

    public Button getBtnMethodService() {
        return this.btnMethodService;
    }

    public Button getBtnEditMapping() {
        return this.btnEditMapping;
    }

    public ImageHyperlink getImgMethodTwistie() {
        return this.imgMethodTwistie;
    }

    public ImageHyperlink getImgMethodRemove() {
        return this.imgMethodRemove;
    }

    public ImageHyperlink getImgMethodMoveUp() {
        return this.imgMethodMoveUp;
    }

    public ImageHyperlink getImgMethodMoveDown() {
        return this.imgMethodMoveDown;
    }

    public ImageHyperlink getImgMethod() {
        return this.imgMethod;
    }

    public ApiEditorMethodDescriptionComposite getCmpMethodDescription() {
        return this.cmpMethodDescription;
    }

    public ServiceMappingController getServiceMappingController() {
        return this.serviceMappingController;
    }

    public boolean setDefaultResponseCode(Integer responseCode) {
        boolean isSet = false;
        if (responseCode != null && this.serviceMappingController != null) {
            isSet = this.serviceMappingController.setDefaultResponseCode(responseCode);
        }
        return isSet;
    }

    public boolean isDefaultResponseCode(Integer responseCode) {
        boolean isDefault = false;
        if (responseCode != null && this.serviceMappingController != null) {
            isDefault = this.serviceMappingController.isDefaultResponseCode(responseCode);
        }
        return isDefault;
    }

    public List<Integer> getDefinedResponseCodes() {
        List<Integer> definedResponseCodes = new ArrayList<Integer>();
        if (this.serviceMappingController != null) {
            definedResponseCodes = this.serviceMappingController.getDefinedResponseCodes();
        }
        return definedResponseCodes;
    }

    public Integer getDefaultResponseCode() {
        Integer defaultResponseCode = null;
        if (this.serviceMappingController != null) {
            defaultResponseCode = this.serviceMappingController.getDefaultResponseCode();
        }
        return defaultResponseCode;
    }

    public IFile getRequestMappingFile() throws Exception {
        IFile mappingFile = null;
        if (this.getServiceMappingController().hasRequestMapping()) {
            mappingFile = this.getServiceMappingController().getRequestMappingFile();
        }
        return mappingFile;
    }

    public IFile getDefaultResponseMappingFile() throws Exception {
        IFile mappingFile = null;
        if (this.getServiceMappingController().hasDefaultResponseMapping()) {
            mappingFile = this.getServiceMappingController().getDefaultResponseMappingFile();
        }
        return mappingFile;
    }

    public ApiEditorMethodsComposite getLogicalParent() {
        return this.logicalParent;
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public void validate() {
        try {
            boolean requestHasErrors = MappingValidationProblem2.hasErrorMarkers((IFile)this.getRequestMappingFile());
            boolean responseHasErrors = MappingValidationProblem2.hasErrorMarkers((IFile)this.getDefaultResponseMappingFile());
            if (requestHasErrors && responseHasErrors) {
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_btnEditMapping, (String)Xlat.error((String)"REQUEST_DFLTRESP_MAPPING_HAVE_ERRORS"));
            } else if (requestHasErrors) {
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_btnEditMapping, (String)Xlat.error((String)"REQUEST_MAPPING_HAS_ERRORS"));
            } else if (responseHasErrors) {
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_btnEditMapping, (String)Xlat.error((String)"DEFAULT_RESPONSE_MAPPING_HAS_ERRORS"));
            } else {
                XSwt.hideFieldDecoration((ControlDecoration)this.cd_btnEditMapping);
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    @Override
    public void beforeSave(ZosConnectApiEditor editor) {
    }

    @Override
    public void save(ZosConnectApiEditor editor) {
    }

    @Override
    public void fileMarkersChanged(IFile file) {
        this.validate();
    }
}

