/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.editors;

import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.api.PathType;
import com.ibm.zosconnect.ui.common.exceptions.ZosConnectInvalidInputException;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.FormCompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormLabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormSectionBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormStyledTextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormTextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.ModifyListener2;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.common.validation.PosixPortableValidator;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponseComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodsComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorPathComposite;
import com.ibm.zosconnect.ui.editors.ZosConnectApiEditor;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorEventListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorFocusChangeListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorMethodsModifyListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorPathModifyListener;
import com.ibm.zosconnect.ui.editors.listeners.ApiEditorWidgetUpdateListener;
import com.ibm.zosconnect.ui.menu.handlers.DeployApiHandler;
import com.ibm.zosconnect.ui.menu.handlers.ExportApiHandler;
import com.ibm.zosconnect.ui.util.PathValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ApiEditorFormPage
extends FormPage
implements ApiEditorEventListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private FormToolkit toolkit;
    private ScrolledForm scrolledForm;
    private Composite mainComposite;
    private Section sctnDescribeApi;
    private Section sctnContactInfo;
    private Label lblTitle;
    private Label lblName;
    private Label lblDescription;
    private Label lblBasePath;
    private Label lblUrl;
    private Label lblVersion;
    private Label lblEmail;
    private Text txtDescription;
    private StyledText txtTitle;
    private StyledText txtName;
    private StyledText txtBasePath;
    private StyledText txtUrl;
    private StyledText txtVersion;
    private StyledText txtEmail;
    private List<ApiEditorPathComposite> pathComposites = new ArrayList<ApiEditorPathComposite>();
    private boolean dirty;
    private String lastSavedBasePath;
    private List<ApiEditorPathComposite> deletedPathComposites;
    private List<ApiEditorPathModifyListener> pathModifyListeners = new ArrayList<ApiEditorPathModifyListener>();
    private List<ApiEditorMethodsModifyListener> methodsModifyListeners = new ArrayList<ApiEditorMethodsModifyListener>();
    private List<ApiEditorWidgetUpdateListener> widgetUpdateListeners = new ArrayList<ApiEditorWidgetUpdateListener>();
    private IMessageManager messageMgr;
    private MenuManager menuMgr = new MenuManager();
    private Exception createContentException;
    private ApiEditorFocusChangeListener apiEditorFocusChangeListener;
    private ApiEditorPathComposite selectedPathPriorToSave;
    private ApiEditorMethodComposite selectedMethodPriorToSave;
    private ApiEditorMethodResponseComposite selectedResponsePriorToSave;
    private boolean formContentCreated;

    public ApiEditorFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.deletedPathComposites = new ArrayList<ApiEditorPathComposite>();
        this.getApiEditor().getEditorEventListeners().add(this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.createContentException = null;
        this.formContentCreated = false;
        try {
            this.createFormContent2(managedForm);
            this.formContentCreated = true;
        }
        catch (Exception e) {
            this.createContentException = e;
        }
    }

    private void createFormContent2(IManagedForm managedForm) throws Exception {
        String initialBasePath;
        this.toolkit = managedForm.getToolkit();
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(Xlat.label((String)"APIEDIT_TITLE"));
        this.scrolledForm.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                XSwt.reflow((ScrolledForm)ApiEditorFormPage.this.scrolledForm);
            }

            public void controlMoved(ControlEvent arg0) {
                XSwt.reflow((ScrolledForm)ApiEditorFormPage.this.scrolledForm);
            }
        });
        this.scrolledForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ApiEditorFormPage.this.unhookApiEditorFocusChangeListener();
            }
        });
        this.scrolledForm.setAlwaysShowScrollBars(true);
        this.messageMgr = this.scrolledForm.getMessageManager();
        this.messageMgr.setAutoUpdate(true);
        this.messageMgr.removeAllMessages();
        Composite body = this.scrolledForm.getBody();
        this.toolkit.decorateFormHeading(this.scrolledForm.getForm());
        this.toolkit.paintBordersFor(body);
        body.setLayout((Layout)new GridLayoutBuilder().marginTop(10).build());
        this.mainComposite = (Composite)new FormCompositeBuilder(this.toolkit).marginWidth(0).marginHeight(0).build(body);
        this.sctnDescribeApi = (Section)new FormSectionBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_GROUP_DESCRIBE_API")).expanded(Boolean.valueOf(true)).style(Integer.valueOf(258)).verticalAlignment(0x1000000).grabExcessHorizontalSpace(true).build(this.mainComposite);
        Composite sctnDescribeApiClient = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(4).horizontalSpacing(10).marginTop(5).verticalSpacing(10).marginBottom(10).grabExcessHorizontalSpace(true).widthHint(925).build((Composite)this.sctnDescribeApi);
        this.sctnDescribeApi.setClient((Control)sctnDescribeApiClient);
        this.lblTitle = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_NAME")).verticalAlignment(0x1000000).build(sctnDescribeApiClient);
        this.txtTitle = (StyledText)new FormStyledTextBuilder(this.toolkit).text(this.getApiModelController().getApiTitle()).listener((VerifyListener)new VerifyListener2((Control)sctnDescribeApiClient){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)sctnDescribeApiClient){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                String errMsg = PosixPortableValidator.validate((String)XSwt.getTrimText((StyledText)ApiEditorFormPage.this.txtTitle), (PosixPortableValidator.MessageInsertType)PosixPortableValidator.MessageInsertType.API);
                if (errMsg != null) {
                    ApiEditorFormPage.this.messageMgr.addMessage((Object)"txtTitle", errMsg, null, 3, (Control)ApiEditorFormPage.this.txtTitle);
                } else {
                    ApiEditorFormPage.this.messageMgr.removeMessage((Object)"txtTitle", (Control)ApiEditorFormPage.this.txtTitle);
                }
                ApiEditorFormPage.this.getApiModelController().setApiTitle(XSwt.getTrimText((StyledText)ApiEditorFormPage.this.txtTitle));
                ApiEditorFormPage.this.getApiEditor().updatePartName();
                ApiEditorFormPage.this.notifyWidgetUpdateListeners();
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessVerticalSpace(true).horizontalIndent(5).widthHint(300).build(sctnDescribeApiClient);
        int fontHeight = XSwt.getFontHeight((Control)this.txtTitle);
        this.lblDescription = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_DESCRIPTION")).horizontalAlignment(16384).verticalAlignment(128).grabExcessHorizontalSpace(true).verticalSpan(3).build(sctnDescribeApiClient);
        this.txtDescription = (Text)new FormTextBuilder(this.toolkit).text(this.getApiModelController().getApiDescription()).listener((VerifyListener)new VerifyListener2((Control)sctnDescribeApiClient){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)sctnDescribeApiClient){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ApiEditorFormPage.this.getApiModelController().setApiDescription(ApiEditorFormPage.this.txtDescription.getText());
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2626)).horizontalAlignment(16384).grabExcessHorizontalSpace(true).verticalSpan(3).horizontalIndent(5).widthHint(350).heightHint(fontHeight * 5).build(sctnDescribeApiClient);
        this.lblBasePath = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_BASE_PATH")).verticalAlignment(0x1000000).build(sctnDescribeApiClient);
        this.lastSavedBasePath = initialBasePath = this.getApiModelController().getApiBasePath();
        this.txtBasePath = (StyledText)new FormStyledTextBuilder(this.toolkit).text(initialBasePath).listener((VerifyListener)new VerifyListener2((Control)sctnDescribeApiClient){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)sctnDescribeApiClient){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                try {
                    PathValidator.validateHighlightBasePathSyntax(ApiEditorFormPage.this.txtBasePath);
                    ApiEditorFormPage.this.messageMgr.removeMessage((Object)"txtBasePath", (Control)ApiEditorFormPage.this.txtBasePath);
                }
                catch (ZosConnectInvalidInputException e) {
                    ApiEditorFormPage.this.messageMgr.addMessage((Object)"txtBasePath", e.getMessage(), null, 3, (Control)ApiEditorFormPage.this.txtBasePath);
                }
                ApiEditorFormPage.this.getApiModelController().setApiBasePath(ApiEditorFormPage.this.txtBasePath.getText());
                ApiEditorFormPage.this.notifyWidgetUpdateListeners();
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessVerticalSpace(true).horizontalIndent(5).widthHint(300).build(sctnDescribeApiClient);
        this.lblVersion = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_VERSION")).verticalAlignment(0x1000000).build(sctnDescribeApiClient);
        this.txtVersion = (StyledText)new FormStyledTextBuilder(this.toolkit).text(this.getApiModelController().getApiVersion()).toolTipText(Xlat.label((String)"APIEDIT_LABEL_VERSION_TOOLTIP")).listener((VerifyListener)new VerifyListener2((Control)sctnDescribeApiClient){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)sctnDescribeApiClient){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ApiEditorFormPage.this.getApiModelController().setApiVersion(ApiEditorFormPage.this.txtVersion.getText());
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessVerticalSpace(true).horizontalIndent(5).widthHint(300).build(sctnDescribeApiClient);
        this.sctnContactInfo = (Section)new FormSectionBuilder(this.toolkit).text(Xlat.label((String)"APIEDIT_GROUP_CONTACTINFO")).expanded(Boolean.valueOf(true)).style(Integer.valueOf(42)).verticalAlignment(0x1000000).grabExcessHorizontalSpace(true).horizontalSpan(4).build(sctnDescribeApiClient);
        this.sctnContactInfo.setExpanded(false);
        this.sctnContactInfo.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ApiEditorFormPage.this.vAlignDescribeApiTextControls();
            }
        });
        Composite compContactInfo = (Composite)new FormCompositeBuilder(this.toolkit).numColumns(2).horizontalSpacing(10).marginTop(5).verticalSpacing(10).marginBottom(10).grabExcessHorizontalSpace(true).build((Composite)this.sctnContactInfo);
        this.sctnContactInfo.setClient((Control)compContactInfo);
        this.lblName = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_NAME2")).verticalAlignment(0x1000000).build(compContactInfo);
        this.txtName = (StyledText)new FormStyledTextBuilder(this.toolkit).text(this.getApiModelController().getContactName()).listener((VerifyListener)new VerifyListener2((Control)compContactInfo){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)compContactInfo){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ApiEditorFormPage.this.getApiModelController().setContactName(XSwt.getTrimText((StyledText)ApiEditorFormPage.this.txtName));
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessVerticalSpace(true).horizontalIndent(20).widthHint(300).build(compContactInfo);
        this.lblUrl = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABE_URL")).verticalAlignment(0x1000000).build(compContactInfo);
        this.txtUrl = (StyledText)new FormStyledTextBuilder(this.toolkit).text(this.getApiModelController().getContactURL()).listener((VerifyListener)new VerifyListener2((Control)compContactInfo){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)compContactInfo){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                try {
                    PathValidator.validateHighlightContactUrl(ApiEditorFormPage.this.txtUrl);
                    ApiEditorFormPage.this.messageMgr.removeMessage((Object)"txtUrl", (Control)ApiEditorFormPage.this.txtUrl);
                }
                catch (ZosConnectInvalidInputException e) {
                    ApiEditorFormPage.this.messageMgr.addMessage((Object)"txtUrl", e.getMessage(), null, 3, (Control)ApiEditorFormPage.this.txtUrl);
                }
                ApiEditorFormPage.this.getApiModelController().setContactURL(XSwt.getTrimText((StyledText)ApiEditorFormPage.this.txtUrl));
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessVerticalSpace(true).horizontalIndent(20).widthHint(300).build(compContactInfo);
        this.lblEmail = (Label)new FormLabelBuilder(this.toolkit).text(Xlat.labelWithColon((String)"APIEDIT_LABEL_EMAIL")).verticalAlignment(0x1000000).build(compContactInfo);
        this.txtEmail = (StyledText)new FormStyledTextBuilder(this.toolkit).text(this.getApiModelController().getContactEmail()).listener((VerifyListener)new VerifyListener2((Control)compContactInfo){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)compContactInfo){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ApiEditorFormPage.this.getApiModelController().setContactEmail(XSwt.getTrimText((StyledText)ApiEditorFormPage.this.txtEmail));
                ApiEditorFormPage.this.setDirty(true);
            }
        }).style(Integer.valueOf(2052)).horizontalAlignment(16384).verticalAlignment(0x1000000).grabExcessVerticalSpace(true).horizontalIndent(20).widthHint(300).build(compContactInfo);
        IToolBarManager toolbarMgr = this.scrolledForm.getToolBarManager();
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"APIEDIT_BUTTON_DEPLOY_API"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/deploy_api_16.gif")){

            public void run() {
                DeployApiHandler deployHandler = new DeployApiHandler();
                deployHandler.displayDeployApiDialog(ApiEditorFormPage.this.getProject());
            }
        });
        toolbarMgr.update(true);
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"EXPRT_API_DLG_TITLE"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/zosconnectee_export_aar_16.png")){

            public void run() {
                ExportApiHandler exportHandler = new ExportApiHandler();
                exportHandler.displayExportApiDialog(ApiEditorFormPage.this.getProject());
            }
        });
        toolbarMgr.update(true);
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"APIEDIT_BUTTON_EXPAND_ALL"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/expanddetails.gif")){

            public void run() {
                for (ApiEditorPathComposite path : ApiEditorFormPage.this.pathComposites) {
                    path.expandApiMethodsSection(true);
                }
                XSwt.expand((Section)ApiEditorFormPage.this.sctnDescribeApi);
            }
        });
        toolbarMgr.update(true);
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"APIEDIT_BUTTON_COLLAPSE_ALL"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/collapsedetails.gif")){

            public void run() {
                for (ApiEditorPathComposite path : ApiEditorFormPage.this.pathComposites) {
                    path.collapseApiMethodsSection(true);
                }
                XSwt.collapse((Section)ApiEditorFormPage.this.sctnDescribeApi);
            }
        });
        toolbarMgr.update(true);
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"HELP"), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/xx_help16.gif")){

            public void run() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.zosconnect.ui.apieditor");
            }
        });
        toolbarMgr.update(true);
        this.toolkit.decorateFormHeading(this.scrolledForm.getForm());
        this.scrolledForm.getForm().addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter());
        List apiPaths = this.getApiModelController().getApiPaths();
        int index = 0;
        while (index < apiPaths.size()) {
            new ApiEditorPathComposite(this.getMainComposite(), this, (PathType)apiPaths.get(index), index, this.toolkit);
            ++index;
        }
        if (this.isDirty()) {
            this.getApiEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        }
        XSwt.focus((Control)this.txtTitle);
        try {
            PathValidator.validateHighlightBasePathSyntax(this.txtBasePath);
            this.messageMgr.removeMessage((Object)"txtBasePath");
        }
        catch (ZosConnectInvalidInputException e) {
            this.messageMgr.addMessage((Object)"txtBasePath", e.getMessage(), null, 3, (Control)this.txtBasePath);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.scrolledForm, "com.ibm.zosconnect.ui.apieditor");
        this.getEditorSite().setSelectionProvider(this.getEditor().getEditorSite().getSelectionProvider());
        this.hookApiEditorFocusChangeListener();
    }

    public List<ApiEditorPathComposite> getPathComposites() {
        return this.pathComposites;
    }

    public int getApiPathCompositeIndex(ApiEditorPathComposite apiPathComposite) {
        return this.pathComposites.indexOf(apiPathComposite);
    }

    public ScrolledForm getScrolledForm() {
        return this.scrolledForm;
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }

    public ZosConnectApiEditor getApiEditor() {
        ZosConnectApiEditor retVal = null;
        FormEditor editor = this.getEditor();
        if (editor instanceof ZosConnectApiEditor) {
            retVal = (ZosConnectApiEditor)editor;
        }
        return retVal;
    }

    private ApiModelController getApiModelController() {
        return this.getApiEditor().getApiModelController();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.firePropertyChange(257);
        }
        this.getApiEditor().editorDirtyStateChanged();
    }

    public boolean isFirstPath(ApiEditorPathComposite path) {
        return ListUtilz.isFirstMember(this.pathComposites, (Object)path);
    }

    public boolean isLastPath(ApiEditorPathComposite path) {
        return ListUtilz.isLastMember(this.pathComposites, (Object)path);
    }

    public void movePathUp(ApiEditorPathComposite sourcePath) {
        if (this.pathComposites == null || this.pathComposites.isEmpty() || this.isFirstPath(sourcePath)) {
            return;
        }
        int sourcePathIndex = this.pathComposites.indexOf(sourcePath);
        int targetPathIndex = sourcePathIndex - 1;
        ApiEditorPathComposite targetPath = this.pathComposites.get(targetPathIndex);
        sourcePath.moveAbove((Control)targetPath);
        this.pathComposites.set(sourcePathIndex, targetPath);
        this.pathComposites.set(targetPathIndex, sourcePath);
        this.getApiModelController().movePathUp(sourcePath.getPathType());
        this.setDirty(true);
        XSwt.layout((Composite)this.mainComposite, (boolean)true);
        XSwt.reflow((ScrolledForm)this.scrolledForm);
        XSwt.show((ScrolledForm)this.scrolledForm, (Control)sourcePath);
        XSwt.focus((Control)sourcePath);
    }

    public void movePathDown(ApiEditorPathComposite sourcePath) {
        if (this.pathComposites == null || this.pathComposites.isEmpty() || this.isLastPath(sourcePath)) {
            return;
        }
        int sourcePathIndex = this.pathComposites.indexOf(sourcePath);
        int targetPathIndex = sourcePathIndex + 1;
        ApiEditorPathComposite targetPath = this.pathComposites.get(targetPathIndex);
        sourcePath.moveBelow((Control)targetPath);
        this.pathComposites.set(sourcePathIndex, targetPath);
        this.pathComposites.set(targetPathIndex, sourcePath);
        this.getApiModelController().movePathDown(sourcePath.getPathType());
        this.setDirty(true);
        XSwt.layout((Composite)this.mainComposite, (boolean)true);
        XSwt.reflow((ScrolledForm)this.scrolledForm);
        XSwt.show((ScrolledForm)this.scrolledForm, (Control)sourcePath);
        XSwt.focus((Control)sourcePath);
    }

    public void hookApiEditorFocusChangeListener() {
        if (this.apiEditorFocusChangeListener == null) {
            this.apiEditorFocusChangeListener = new ApiEditorFocusChangeListener(this.toolkit, (Control)this.getScrolledForm());
            Display.getDefault().addFilter(15, (Listener)this.apiEditorFocusChangeListener);
        }
    }

    public void unhookApiEditorFocusChangeListener() {
        if (this.apiEditorFocusChangeListener != null) {
            Display.getDefault().removeFilter(15, (Listener)this.apiEditorFocusChangeListener);
            this.apiEditorFocusChangeListener.dispose();
            this.apiEditorFocusChangeListener = null;
        }
    }

    private ApiEditorPathComposite getParentPathComposite(Control control) {
        ApiEditorPathComposite retVal = null;
        if (!XSwt.isDisposed((Control)control) && XSwt.isPainted((Control)control)) {
            while (control != null && !(control instanceof ApiEditorPathComposite) && control != this.mainComposite) {
                control = control.getParent();
            }
            if (control instanceof ApiEditorPathComposite) {
                retVal = (ApiEditorPathComposite)control;
            }
        }
        return retVal;
    }

    public boolean canLeaveThePage() {
        boolean retVal = true;
        if (!StringUtils.isBlank((CharSequence)this.scrolledForm.getMessage())) {
            retVal = false;
        }
        return retVal;
    }

    public void notifyApiPathListeners(ApiEditorPathComposite modified) {
        for (ApiEditorPathModifyListener listener : this.getPathModifyListeners()) {
            listener.modify(modified);
        }
    }

    public List<ApiEditorPathModifyListener> getPathModifyListeners() {
        if (this.pathModifyListeners == null) {
            this.pathModifyListeners = new ArrayList<ApiEditorPathModifyListener>();
        }
        return this.pathModifyListeners;
    }

    public void notifyApiMethodsListeners(ApiEditorMethodsComposite compMethods, MethodValues methodValue) {
        for (ApiEditorMethodsModifyListener listener : this.getMethodsModifyListeners()) {
            listener.modify(compMethods, methodValue);
        }
    }

    public List<ApiEditorMethodsModifyListener> getMethodsModifyListeners() {
        if (this.methodsModifyListeners == null) {
            this.methodsModifyListeners = new ArrayList<ApiEditorMethodsModifyListener>();
        }
        return this.methodsModifyListeners;
    }

    public void notifyWidgetUpdateListeners() {
        for (ApiEditorWidgetUpdateListener listener : this.getWidgetUpdateListeners()) {
            listener.updateWidgetEnablements(this.canLeaveThePage());
        }
        XSwt.reflow((ScrolledForm)this.getScrolledForm());
    }

    public List<ApiEditorWidgetUpdateListener> getWidgetUpdateListeners() {
        if (this.widgetUpdateListeners == null) {
            this.widgetUpdateListeners = new ArrayList<ApiEditorWidgetUpdateListener>();
        }
        return this.widgetUpdateListeners;
    }

    public String getEditedBasePath() {
        String retVal = null;
        String currentEditedBasePath = this.getApiModelController().getApiBasePath();
        if (this.lastSavedBasePath != null && !this.lastSavedBasePath.equals(currentEditedBasePath)) {
            retVal = currentEditedBasePath;
        }
        return retVal;
    }

    @Override
    public void beforeSave(ZosConnectApiEditor editor) {
    }

    @Override
    public void save(ZosConnectApiEditor editor) {
        this.lastSavedBasePath = this.getApiModelController().getApiBasePath();
        this.deletedPathComposites.clear();
        if (!this.txtTitle.isDisposed()) {
            this.txtTitle.setText(this.txtTitle.getText().trim());
        }
        this.dirty = false;
    }

    @Override
    public void fileMarkersChanged(IFile file) {
    }

    public List<ApiEditorPathComposite> getDeletedPathComposites() {
        return this.deletedPathComposites;
    }

    public ApiProjectController getApiProjectController() {
        return this.getApiEditor().getApiProjectController();
    }

    public IProject getProject() {
        return this.getApiProjectController().getProject();
    }

    public Exception getCreateContentException() {
        return this.createContentException;
    }

    public ApiEditorFocusChangeListener getApiEditorFocusChangeListener() {
        return this.apiEditorFocusChangeListener;
    }

    public ApiEditorPathComposite getSelectedPathPriorToSave() {
        return this.selectedPathPriorToSave;
    }

    public void setSelectedPathPriorToSave(ApiEditorPathComposite selectedPath) {
        this.selectedPathPriorToSave = selectedPath;
    }

    public ApiEditorMethodComposite getSelectedMethodPriorToSave() {
        return this.selectedMethodPriorToSave;
    }

    public void setSelectedMethodPriorToSave(ApiEditorMethodComposite selectedMethod) {
        this.selectedMethodPriorToSave = selectedMethod;
    }

    public ApiEditorMethodResponseComposite getSelectedResponsePriorToSave() {
        return this.selectedResponsePriorToSave;
    }

    public void setSelectedResponsePriorToSave(ApiEditorMethodResponseComposite selectedResponse) {
        this.selectedResponsePriorToSave = selectedResponse;
    }

    public void vAlignDescribeApiTextControls() {
        GridData gd_control;
        Point controlLocation;
        Control control;
        ArrayList<Composite> compositesToLayout = new ArrayList<Composite>();
        Control[] controlsToVAlign = new Control[]{this.txtTitle, this.txtBasePath, this.txtVersion, this.txtName, this.txtUrl, this.txtEmail};
        Integer minStartX = null;
        Integer maxStartX = null;
        Control[] controlArray = controlsToVAlign;
        int n = controlsToVAlign.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            if (control.getLayoutData() instanceof GridData) {
                controlLocation = control.toDisplay(new Point(0, 0));
                gd_control = (GridData)control.getLayoutData();
                if (minStartX == null) {
                    minStartX = controlLocation.x;
                }
                minStartX = Math.min(minStartX, controlLocation.x);
                if (maxStartX == null) {
                    maxStartX = controlLocation.x;
                }
                maxStartX = Math.max(maxStartX, controlLocation.x);
            }
            ++n2;
        }
        if (minStartX == null || maxStartX == null) {
            return;
        }
        controlArray = controlsToVAlign;
        n = controlsToVAlign.length;
        n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            if (control.getLayoutData() instanceof GridData) {
                Composite parentComposite;
                controlLocation = control.toDisplay(new Point(0, 0));
                gd_control = (GridData)control.getLayoutData();
                if (controlLocation.x < maxStartX) {
                    gd_control.horizontalIndent += maxStartX - controlLocation.x;
                }
                if (!compositesToLayout.contains(parentComposite = control.getParent())) {
                    compositesToLayout.add(parentComposite);
                }
            }
            ++n2;
        }
        for (Composite composite : compositesToLayout) {
            XSwt.layout((Composite)composite, (boolean)true);
        }
    }

    public boolean isFormContentCreated() {
        return this.formContentCreated;
    }
}

