/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class WorkspaceSingleFileSelectionDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private String fileExtension;
    private String message;
    private String title;
    private boolean selectFile;
    private IProject currentProject;
    private Rectangle screen;
    private Button btnOK;
    private IResource result;
    private String prevExportPath;
    private IWorkspaceRoot root;
    private TreeViewer treeViewer;

    public WorkspaceSingleFileSelectionDialog(Shell parentShell, String title, String message, String fileExtension, boolean selectFile) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.title = title;
        this.message = message;
        this.fileExtension = fileExtension;
        this.selectFile = selectFile;
    }

    public WorkspaceSingleFileSelectionDialog(Shell parentShell, String title, String message, String fileExtension, boolean selectFile, IProject currentProject) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.title = title;
        this.message = message;
        this.fileExtension = fileExtension;
        this.selectFile = selectFile;
        this.currentProject = currentProject;
    }

    public IResource getResult() {
        return this.result;
    }

    protected Control createDialogArea(Composite parent) {
        this.screen = XSwt.getScreenSize();
        Composite compContents = (Composite)super.createDialogArea(parent);
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        compContents.setLayout((Layout)new GridLayout(1, false));
        GridData gd_compContents = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_compContents.heightHint = Math.max(200, (int)(0.3 * (double)this.screen.height));
        gd_compContents.widthHint = Math.max(400, (int)(0.4 * (double)this.screen.width));
        compContents.setLayoutData((Object)gd_compContents);
        Label lblTreeTitle = new Label(compContents, 0);
        lblTreeTitle.setText(this.message);
        this.treeViewer = new TreeViewer(compContents, 2048);
        this.treeViewer.setExpandPreCheckFilters(false);
        Tree treeWorkspace = this.treeViewer.getTree();
        GridData gd_treeWorkspace = new GridData(4, 4, true, true, 1, 1);
        treeWorkspace.setLayoutData((Object)gd_treeWorkspace);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.root = ResourcesPlugin.getWorkspace().getRoot();
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object child) {
                if (!(child instanceof IResource)) {
                    return false;
                }
                IFileUtil iFileUtil = new IFileUtil();
                switch (((IResource)child).getType()) {
                    case 1: {
                        IFile fileResource = (IFile)child;
                        if (WorkspaceSingleFileSelectionDialog.this.selectFile && !fileResource.getProject().equals((Object)WorkspaceSingleFileSelectionDialog.this.currentProject)) {
                            return StringUtils.equals((CharSequence)fileResource.getFileExtension(), (CharSequence)WorkspaceSingleFileSelectionDialog.this.fileExtension);
                        }
                        return false;
                    }
                    case 4: {
                        IProject project = (IProject)child;
                        if (project.equals((Object)WorkspaceSingleFileSelectionDialog.this.currentProject)) {
                            return false;
                        }
                        if (WorkspaceSingleFileSelectionDialog.this.selectFile) {
                            return iFileUtil.hasIFileWithExt(project, WorkspaceSingleFileSelectionDialog.this.fileExtension);
                        }
                        return true;
                    }
                    case 2: {
                        IFolder folder = (IFolder)child;
                        if (folder.getProject().equals((Object)WorkspaceSingleFileSelectionDialog.this.currentProject)) {
                            return false;
                        }
                        if (WorkspaceSingleFileSelectionDialog.this.selectFile) {
                            return iFileUtil.hasIFileWithExt(folder, WorkspaceSingleFileSelectionDialog.this.fileExtension);
                        }
                        return true;
                    }
                }
                return false;
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compContents, "com.ibm.zosconnect.ui.importwizard");
        this.selectPrevPath();
        return compContents;
    }

    private void selectPrevPath() {
        if (this.prevExportPath == null || this.prevExportPath.isEmpty()) {
            return;
        }
        try {
            IProject[] projects = this.root.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject currProj = projects[i];
                if (currProj.isOpen()) {
                    if (currProj.getFullPath().toString().equals(this.prevExportPath)) {
                        this.treeViewer.reveal((Object)currProj);
                        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)currProj));
                        return;
                    }
                    IResource[] projResources = currProj.members();
                    int j = 0;
                    while (j < projResources.length) {
                        IResource currResource = projResources[j];
                        if (currResource instanceof IFolder) {
                            IFolder folder = (IFolder)currResource;
                            if (folder.getFullPath().toString().equals(this.prevExportPath)) {
                                this.treeViewer.reveal((Object)folder);
                                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)folder));
                                return;
                            }
                            IResource[] folderResources = folder.members();
                            int k = 0;
                            while (k < folderResources.length) {
                                IResource currFolderResource = folderResources[k];
                                if (currFolderResource instanceof IFolder && this.doesFolderMatch((IFolder)currFolderResource)) {
                                    return;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doesFolderMatch(IFolder folder) {
        if (folder != null && folder.getFullPath().toString().equals(this.prevExportPath)) {
            this.treeViewer.reveal((Object)folder);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)folder));
            return true;
        }
        try {
            IResource[] folderResources = folder.members();
            int k = 0;
            while (true) {
                if (k >= folderResources.length) {
                    return false;
                }
                IResource currFolderResource = folderResources[k];
                if (currFolderResource instanceof IFolder && this.doesFolderMatch((IFolder)currFolderResource)) {
                    return true;
                }
                ++k;
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        return false;
    }

    public void setPrevPath(String prevPath) {
        this.prevExportPath = prevPath;
    }

    private void addSelectionListener() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selected != null && !(selected instanceof IFile)) {
                    WorkspaceSingleFileSelectionDialog.this.btnOK.setEnabled(false);
                } else {
                    WorkspaceSingleFileSelectionDialog.this.result = (IResource)selected;
                    WorkspaceSingleFileSelectionDialog.this.btnOK.setEnabled(true);
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.btnOK.setEnabled(false);
        this.addSelectionListener();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    private void updateStatusAndPack(IStatus status) {
        this.updateStatus(status);
        XSwt.pack((Control)this.getShell());
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (!XSwt.isOK((IStatus)status)) {
            ZCeeUILogger.error((IStatus)status);
        }
    }

    private class IFileUtil
    implements IResourceVisitor {
        private boolean result;
        private String extension;

        public boolean visit(IResource resource) throws CoreException {
            if (!this.result && resource instanceof IFile) {
                IFile fileResource = (IFile)resource;
                this.result = StringUtils.equals((CharSequence)fileResource.getFileExtension(), (CharSequence)this.extension);
            }
            return true;
        }

        public boolean hasIFileWithExt(IProject project, String extension) {
            this.extension = extension;
            this.result = false;
            try {
                project.accept((IResourceVisitor)this);
            }
            catch (CoreException e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
            return this.result;
        }

        public boolean hasIFileWithExt(IFolder folder, String extension) {
            this.extension = extension;
            this.result = false;
            try {
                folder.accept((IResourceVisitor)this);
            }
            catch (CoreException e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
            return this.result;
        }
    }
}

