/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZCeeProjectConstants;
import com.ibm.zosconnect.ui.common.util.WorkspaceUtil;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.api.ServiceArchiveController;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.dialogs.ImportServicesImpactAnalysisDialog;
import com.ibm.zosconnect.ui.dialogs.WorkspaceFileSelectionDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ServiceSelectionDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite compButtonBar;
    private Label lblSelectServiceArchive;
    private List listServices;
    private Button btnWorkspace;
    private Button btnFileSystem;
    private Button btnOk;
    private ApiProjectController apiProjectController;
    private ApiModelController apiModelController;
    private ServiceArchiveController serviceArchiveController;
    private ISchedulingRule modifyRule;
    private String selectedServiceName;
    private boolean isContextMenu;

    public ServiceSelectionDialog(Shell parentShell, ApiProjectController apiProjectController, ApiModelController apiModelController, boolean isContextMenu) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.apiProjectController = apiProjectController;
        this.apiModelController = apiModelController;
        this.apiProjectController.setApiModelController(apiModelController);
        this.isContextMenu = isContextMenu;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        this.modifyRule = ruleFactory.modifyRule((IResource)apiProjectController.getProject());
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws Exception {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblSelectServiceArchive = new Label(this.compContents, 0);
        if (this.isContextMenu) {
            this.lblSelectServiceArchive.setText(Xlat.label((String)"IMPORTDLG_LABEL_SERVICES"));
        } else {
            this.lblSelectServiceArchive.setText(Xlat.label((String)"APIDLG_LABEL_SELECT_OR_IMPORT_SERVICE"));
        }
        new Label(this.compContents, 0);
        this.listServices = new List(this.compContents, 2816);
        GridData gd_compResourceBrowser = new GridData(4, 128, false, false, 1, 1);
        gd_compResourceBrowser.widthHint = 400;
        gd_compResourceBrowser.heightHint = 250;
        this.listServices.setLayoutData((Object)gd_compResourceBrowser);
        this.listServices.setBounds(0, 0, 89, 89);
        this.listServices.setItems(this.apiProjectController.getImportedServiceNames());
        XSwt.sortItems((List)this.listServices);
        this.listServices.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (ServiceSelectionDialog.this.listServices.getSelectionCount() == 1) {
                    ServiceSelectionDialog.this.selectedServiceName = ServiceSelectionDialog.this.listServices.getSelection()[0];
                    ServiceSelectionDialog.this.btnOk.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        if (this.isContextMenu) {
            this.listServices.setEnabled(false);
        }
        this.compButtonBar = new Composite(this.compContents, 0);
        GridLayout gl_compButtonBar = new GridLayout(1, false);
        gl_compButtonBar.horizontalSpacing = 0;
        gl_compButtonBar.marginBottom = 5;
        gl_compButtonBar.marginHeight = 0;
        this.compButtonBar.setLayout((Layout)gl_compButtonBar);
        this.compButtonBar.setLayoutData((Object)new GridData(0x1000000, 128, false, true, 1, 1));
        this.btnWorkspace = new Button(this.compButtonBar, 0);
        this.btnWorkspace.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnWorkspace.setText(Xlat.label((String)"APIDLG_BUTTON_WORKSPACE"));
        this.btnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkspaceFileSelectionDialog dialog = new WorkspaceFileSelectionDialog(ServiceSelectionDialog.this.getShell(), Xlat.label((String)"APIDLG_TITLE_IMPORT_ZOSCONNECT_SERVICES"), Xlat.label((String)"APIDLG_LABEL_SELECT_SAR_WORKSPACE"), "sar", true);
                if (dialog.open() == 0) {
                    ArrayList<IFile> sarFiles = dialog.getResults();
                    HashMap<String, File> sarFilesMap = new HashMap<String, File>();
                    HashMap<String, ServiceArchiveController> sarControllersMap = new HashMap<String, ServiceArchiveController>();
                    try {
                        int i = 0;
                        while (i < sarFiles.size()) {
                            File newSarFile = sarFiles.get(i).getLocation().toFile();
                            ServiceSelectionDialog.this.serviceArchiveController = new ServiceArchiveController(newSarFile);
                            ServiceSelectionDialog.this.serviceArchiveController.extractToStateLocation();
                            sarFilesMap.put(ServiceSelectionDialog.this.serviceArchiveController.getServiceName(), newSarFile);
                            sarControllersMap.put(ServiceSelectionDialog.this.serviceArchiveController.getServiceName(), ServiceSelectionDialog.this.serviceArchiveController);
                            ServiceSelectionDialog.this.serviceArchiveController.deleteFromStateLocation();
                            ++i;
                        }
                        boolean doImport = ServiceSelectionDialog.this.checkOverwriteServices(sarFilesMap, sarControllersMap);
                        if (doImport) {
                            ImportServiceArchivesOp workspaceOp = new ImportServiceArchivesOp(sarFilesMap, ServiceSelectionDialog.this.modifyRule);
                            WorkspaceUtil.run((WorkspaceModifyOperation)workspaceOp, (boolean)false, (boolean)false);
                        }
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((Throwable)e);
                        ZCeeErrorDialog.openError((Exception)e);
                    }
                    ServiceSelectionDialog.this.listServices.setSelection(new String[]{ServiceSelectionDialog.this.selectedServiceName});
                    ServiceSelectionDialog.this.btnOk.setEnabled(true);
                }
            }
        });
        this.btnFileSystem = new Button(this.compButtonBar, 0);
        this.btnFileSystem.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnFileSystem.setText(Xlat.label((String)"APIDLG_BUTTON_FILE_SYSTEM"));
        this.btnFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ServiceSelectionDialog.this.btnFileSystem.getShell(), 4098);
                dialog.setFilterExtensions(new String[]{"*.sar"});
                try {
                    String prevPath = ServiceSelectionDialog.this.apiProjectController.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_IMPORT_SERVICE_LOCAL_FILEPATH);
                    if (prevPath != null && !prevPath.isEmpty()) {
                        dialog.setFilterPath(prevPath);
                    } else {
                        dialog.setFilterPath("/");
                    }
                }
                catch (CoreException e) {
                    ZCeeUILogger.error((Throwable)e);
                }
                boolean duplicateError = false;
                boolean invalidServiceNameError = false;
                String firstFileName = dialog.open();
                if (firstFileName != null) {
                    String path = firstFileName.substring(0, firstFileName.lastIndexOf(File.separator) + 1);
                    String[] fileNames = dialog.getFileNames();
                    HashMap<String, File> sarFilesMap = new HashMap<String, File>();
                    HashMap<String, ServiceArchiveController> sarControllersMap = new HashMap<String, ServiceArchiveController>();
                    try {
                        ServiceSelectionDialog.this.apiProjectController.getProject().setPersistentProperty(ZCeeProjectConstants.PROP_API_IMPORT_SERVICE_LOCAL_FILEPATH, path);
                    }
                    catch (CoreException e2) {
                        ZCeeUILogger.error((Throwable)e2);
                    }
                    try {
                        boolean doImport;
                        HashMap<String, String> serviceNames = new HashMap<String, String>();
                        int i = 0;
                        while (i < fileNames.length) {
                            String name = path + fileNames[i];
                            File newSarFile = new File(name);
                            ServiceSelectionDialog.this.serviceArchiveController = new ServiceArchiveController(newSarFile);
                            ServiceSelectionDialog.this.serviceArchiveController.extractToStateLocation();
                            String currServiceName = ServiceSelectionDialog.this.serviceArchiveController.getServiceName();
                            if (serviceNames.containsKey(currServiceName)) {
                                String[] inputs = new String[]{(String)serviceNames.get(currServiceName), newSarFile.getName(), currServiceName};
                                ApiEditorMessageDialog msgDialog = new ApiEditorMessageDialog(ServiceSelectionDialog.this.getShell(), false);
                                msgDialog.openError(Xlat.error((String)"IMPORT_DUPLICATE_SAR_FILES", (String[])inputs));
                                duplicateError = true;
                                break;
                            }
                            if (!ServiceArchiveController.isValidServiceName((String)currServiceName)) {
                                String[] inputs = new String[]{newSarFile.getName(), currServiceName};
                                ApiEditorMessageDialog msgDialog = new ApiEditorMessageDialog(ServiceSelectionDialog.this.getShell(), false);
                                msgDialog.openError(Xlat.error((String)"IMPORT_INVALID_SERVICE_NAME", (String[])inputs));
                                invalidServiceNameError = true;
                                break;
                            }
                            serviceNames.put(currServiceName, newSarFile.getName());
                            sarFilesMap.put(currServiceName, newSarFile);
                            sarControllersMap.put(currServiceName, ServiceSelectionDialog.this.serviceArchiveController);
                            ServiceSelectionDialog.this.serviceArchiveController.deleteFromStateLocation();
                            sarControllersMap.put(ServiceSelectionDialog.this.serviceArchiveController.getServiceName(), ServiceSelectionDialog.this.serviceArchiveController);
                            sarControllersMap.put(ServiceSelectionDialog.this.serviceArchiveController.getServiceName(), ServiceSelectionDialog.this.serviceArchiveController);
                            ++i;
                        }
                        if (!duplicateError && !invalidServiceNameError && (doImport = ServiceSelectionDialog.this.checkOverwriteServices(sarFilesMap, sarControllersMap))) {
                            ImportServiceArchivesOp workspaceOp = new ImportServiceArchivesOp(sarFilesMap, ServiceSelectionDialog.this.modifyRule);
                            WorkspaceUtil.run((WorkspaceModifyOperation)workspaceOp, (boolean)false, (boolean)false);
                        }
                    }
                    catch (Exception e) {
                        ZCeeUILogger.error((Throwable)e);
                        ZCeeErrorDialog.openError((Exception)e);
                    }
                    if (!duplicateError) {
                        ServiceSelectionDialog.this.listServices.setSelection(new String[]{ServiceSelectionDialog.this.selectedServiceName});
                        ServiceSelectionDialog.this.btnOk.setEnabled(true);
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.importwizard");
        return compDialogArea;
    }

    private boolean checkOverwriteServices(HashMap<String, File> sarFilesMap, HashMap<String, ServiceArchiveController> sarControllersMap) throws Exception {
        String[] existingServiceNames = this.apiProjectController.getImportedServiceNames();
        HashMap<String, String> overlappedServices = new HashMap<String, String>();
        HashMap<String, String> newServices = new HashMap<String, String>();
        int i = 0;
        while (i < existingServiceNames.length) {
            if (sarFilesMap.get(existingServiceNames[i]) != null) {
                Object serviceDescp = sarControllersMap.get(existingServiceNames[i]).getServiceDescription();
                if (serviceDescp == null) {
                    serviceDescp = "";
                }
                overlappedServices.put(existingServiceNames[i], (String)serviceDescp);
            }
            ++i;
        }
        for (String currServiceName : sarFilesMap.keySet()) {
            if (overlappedServices.containsKey(currServiceName)) continue;
            String serviceDescp = sarControllersMap.get(currServiceName).getServiceDescription();
            if (serviceDescp == null) {
                serviceDescp = "";
            }
            newServices.put(currServiceName, serviceDescp);
        }
        ImpactAnalysisOperation compOp = new ImpactAnalysisOperation(overlappedServices, sarControllersMap);
        WorkspaceUtil.run((WorkspaceModifyOperation)compOp, (String)Xlat.description((String)"STATUS_IMPACT_ANALYSIS"), (boolean)false, (boolean)false);
        ImportServicesImpactAnalysisDialog iaDialog = new ImportServicesImpactAnalysisDialog(this.getShell(), this.apiProjectController, newServices, overlappedServices);
        int cancelPressed = iaDialog.open();
        if (cancelPressed == 1) {
            this.apiProjectController.clearProblemsCache();
            return false;
        }
        return true;
    }

    private void addToServiceList(ServiceArchiveController serviceArchiveController) throws Exception {
        if (serviceArchiveController == null) {
            return;
        }
        this.selectedServiceName = serviceArchiveController.getServiceName();
        boolean addToServiceList = true;
        String[] stringArray = this.listServices.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceName = stringArray[n2];
            if (serviceName.equalsIgnoreCase(this.selectedServiceName)) {
                addToServiceList = false;
                break;
            }
            ++n2;
        }
        if (addToServiceList) {
            this.listServices.add(this.selectedServiceName);
            XSwt.sortItems((List)this.listServices);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.btnOk = this.getButton(0);
        if (!this.isContextMenu) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.btnOk.setEnabled(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isContextMenu) {
            newShell.setText(Xlat.label((String)"APIDLG_TITLE_IMPORT_ZOSCONNECT_SERVICES"));
        } else {
            newShell.setText(Xlat.label((String)"APIDLG_TITLE_SELECT_ZOSCONNECT_SERVICE"));
        }
    }

    public ServiceArchiveController getSelectedService() throws Exception {
        if (this.serviceArchiveController == null || !this.serviceArchiveController.getServiceName().equals(this.selectedServiceName)) {
            this.serviceArchiveController = this.apiProjectController.getServiceArchiveController(this.selectedServiceName);
        }
        return this.serviceArchiveController;
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (!XSwt.isOK((IStatus)status)) {
            ZCeeUILogger.error((IStatus)status);
        }
    }

    private class ImpactAnalysisOperation
    extends WorkspaceModifyOperation {
        private HashMap<String, String> overlappedServices;
        private HashMap<String, ServiceArchiveController> sarControllersMap;

        public ImpactAnalysisOperation(HashMap<String, String> overlappedServices, HashMap<String, ServiceArchiveController> sarControllersMap) {
            this.overlappedServices = overlappedServices;
            this.sarControllersMap = sarControllersMap;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask(Xlat.description((String)"STATUS_IMPACT_ANALYSIS"), 100);
                monitor.worked(50);
                for (String service : this.overlappedServices.keySet()) {
                    monitor.setTaskName(Xlat.description((String)"STATUS_SERVICE_COMPARISONS", (String[])new String[]{service}));
                    ServiceArchiveController currSarController = this.sarControllersMap.get(service);
                    ServiceSelectionDialog.this.apiProjectController.updateClonedMappingFiles(currSarController, monitor);
                }
                monitor.done();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.zosconnect.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private class ImportServiceArchivesOp
    extends WorkspaceModifyOperation {
        private HashMap<String, File> sarFilesMap;

        public ImportServiceArchivesOp(HashMap<String, File> sarFilesMap, ISchedulingRule rule) {
            super(rule);
            this.sarFilesMap = sarFilesMap;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                for (File currSarFile : this.sarFilesMap.values()) {
                    ServiceSelectionDialog.this.serviceArchiveController = new ServiceArchiveController(currSarFile);
                    ServiceSelectionDialog.this.apiProjectController.importServiceArchive(ServiceSelectionDialog.this.serviceArchiveController, monitor);
                    ServiceSelectionDialog.this.apiProjectController.updateMappingFiles(ServiceSelectionDialog.this.serviceArchiveController, monitor);
                    ServiceSelectionDialog.this.apiProjectController.clearProblemsCache();
                    XSwt.getActiveShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ServiceSelectionDialog.this.addToServiceList(((ImportServiceArchivesOp)ImportServiceArchivesOp.this).ServiceSelectionDialog.this.serviceArchiveController);
                            }
                            catch (Exception e) {
                                ZCeeUILogger.error((Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.zosconnect.ui", e.getMessage(), (Throwable)e));
            }
        }
    }
}

