/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.api.mapping.service.ResponseMessageType;
import com.ibm.zosconnect.api.rules.BooleanExpression;
import com.ibm.zosconnect.api.rules.BooleanOperator;
import com.ibm.zosconnect.ui.common.util.ListUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.controllers.walkers.ISwaggerModelVisitor;
import com.ibm.zosconnect.ui.controllers.walkers.ModelLeafPropertyVisitor;
import com.ibm.zosconnect.ui.controllers.walkers.SwaggerModelWalker;
import com.ibm.zosconnect.ui.dialogs.AddOrEditResponseDialog;
import com.ibm.zosconnect.ui.dialogs.ResponseCodeRuleComposite;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ResponseCodeRulesComposite
extends Composite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private LinkedHashMap<String, Property> leafProperties;
    private ServiceMappingController serviceMappingController;
    private Composite controlParent;
    private AddOrEditResponseDialog responseDialog;
    private int totalRules = 0;
    private List<ResponseCodeRuleComposite> ruleComposites = new ArrayList<ResponseCodeRuleComposite>();

    public ResponseCodeRulesComposite(Composite controlParent, AddOrEditResponseDialog responseDialog, ServiceMappingController serviceMappingController, boolean edit) throws Exception {
        super(controlParent, 0);
        this.controlParent = controlParent;
        this.responseDialog = responseDialog;
        this.serviceMappingController = serviceMappingController;
        this.ruleComposites = new ArrayList<ResponseCodeRuleComposite>();
        this.populateLeafFieldPaths();
        this.setLayout((Layout)new GridLayoutBuilder().marginHeight(5).marginLeft(MaxFieldDecorationWidth).verticalSpacing(10).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).build());
        this.setBackgroundMode(1);
        if (edit) {
            ResponseMessageType respMsg = serviceMappingController.getResponseMessage(responseDialog.getResponseCode());
            BooleanExpression rootExp = respMsg.getBooleanExpression();
            if (rootExp == null) {
                ++this.totalRules;
                ResponseCodeRuleComposite newRule = new ResponseCodeRuleComposite(this, this.totalRules, responseDialog);
                this.ruleComposites.add(newRule);
            } else {
                this.createRulesFromBooleanExpression(rootExp);
            }
        } else {
            ++this.totalRules;
            ResponseCodeRuleComposite newRule = new ResponseCodeRuleComposite(this, this.totalRules, responseDialog);
            this.ruleComposites.add(newRule);
        }
        XSwt.layout((Composite)this, (boolean)true);
        XSwt.layout((Composite)controlParent, (boolean)true);
        this.setSize(this.computeSize(-1, -1));
    }

    private void createRulesFromBooleanExpression(BooleanExpression rootExp) {
        if (ResponseCodeRulesComposite.getAndOrEnum(rootExp.getOp()) == BooleanOperator.AND) {
            List children = rootExp.getBooleanExpression();
            int andChildProcessed = 0;
            for (BooleanExpression currExp : children) {
                if (++andChildProcessed == children.size()) {
                    ResponseCodeRuleComposite rule = this.addExistingRule(currExp.getId(), currExp.getLeft(), BooleanOperator.valueOf((String)currExp.getOp()), currExp.getRight(), null);
                    rule.clearDisableBooleanAndOrCombo();
                    continue;
                }
                this.addExistingRule(currExp.getId(), currExp.getLeft(), BooleanOperator.valueOf((String)currExp.getOp()), currExp.getRight(), BooleanOperator.AND);
            }
        } else if (ResponseCodeRulesComposite.getAndOrEnum(rootExp.getOp()) == BooleanOperator.OR) {
            List orChildren = rootExp.getBooleanExpression();
            int orChildProcessed = 0;
            for (BooleanExpression currOrExp : orChildren) {
                if (currOrExp.getBooleanExpression().isEmpty()) {
                    if (++orChildProcessed == orChildren.size()) {
                        ResponseCodeRuleComposite rule = this.addExistingRule(currOrExp.getId(), currOrExp.getLeft(), BooleanOperator.valueOf((String)currOrExp.getOp()), currOrExp.getRight(), null);
                        rule.clearDisableBooleanAndOrCombo();
                        continue;
                    }
                    this.addExistingRule(currOrExp.getId(), currOrExp.getLeft(), BooleanOperator.valueOf((String)currOrExp.getOp()), currOrExp.getRight(), BooleanOperator.OR);
                    continue;
                }
                if (ResponseCodeRulesComposite.getAndOrEnum(currOrExp.getOp()) != BooleanOperator.AND) continue;
                List andChildren = currOrExp.getBooleanExpression();
                ++orChildProcessed;
                int andChildProcessed = 0;
                for (BooleanExpression currAndExp : andChildren) {
                    if (++andChildProcessed == andChildren.size() && orChildProcessed == orChildren.size()) {
                        ResponseCodeRuleComposite rule = this.addExistingRule(currAndExp.getId(), currAndExp.getLeft(), BooleanOperator.valueOf((String)currAndExp.getOp()), currAndExp.getRight(), null);
                        rule.clearDisableBooleanAndOrCombo();
                        continue;
                    }
                    if (andChildProcessed == andChildren.size()) {
                        this.addExistingRule(currAndExp.getId(), currAndExp.getLeft(), BooleanOperator.valueOf((String)currAndExp.getOp()), currAndExp.getRight(), BooleanOperator.OR);
                        continue;
                    }
                    this.addExistingRule(currAndExp.getId(), currAndExp.getLeft(), BooleanOperator.valueOf((String)currAndExp.getOp()), currAndExp.getRight(), BooleanOperator.AND);
                }
            }
        } else {
            ResponseCodeRuleComposite rule = this.addExistingRule(rootExp.getId(), rootExp.getLeft(), BooleanOperator.valueOf((String)rootExp.getOp()), rootExp.getRight(), null);
            rule.clearDisableBooleanAndOrCombo();
        }
    }

    private void populateLeafFieldPaths() throws Exception {
        Model responseModel = this.serviceMappingController.getServiceArchiveController().getResponseSchemaModel();
        ModelLeafPropertyVisitor visitor = new ModelLeafPropertyVisitor();
        SwaggerModelWalker walker = new SwaggerModelWalker();
        walker.accept((ISwaggerModelVisitor)visitor, responseModel);
        this.leafProperties = visitor.getLeafProperties();
    }

    private ResponseCodeRuleComposite addExistingRule(String id, String fieldPath, BooleanOperator op, String value, BooleanOperator andOr) {
        ++this.totalRules;
        ResponseCodeRuleComposite rule = new ResponseCodeRuleComposite(this, id, fieldPath, op, value, andOr, this.responseDialog);
        this.ruleComposites.add(rule);
        return rule;
    }

    public ResponseCodeRuleComposite addNewRule() {
        if (this.totalRules >= 1) {
            ResponseCodeRuleComposite oldLastRule = this.ruleComposites.get(this.totalRules - 1);
            oldLastRule.enableBooleanAndOrCombo();
        }
        ++this.totalRules;
        ResponseCodeRuleComposite newRule = new ResponseCodeRuleComposite(this, this.totalRules, this.responseDialog);
        this.ruleComposites.add(newRule);
        this.responseDialog.setDirty(true);
        this.responseDialog.validate();
        XSwt.layout((Composite)this, (boolean)true);
        XSwt.layout((Composite)this.controlParent, (boolean)true);
        this.setSize(this.computeSize(-1, -1));
        this.responseDialog.updateRulesSectionDimensions();
        this.responseDialog.packShell();
        this.responseDialog.focusRule(newRule);
        return newRule;
    }

    public void moveRuleUp(ResponseCodeRuleComposite rule) {
        int index = this.ruleComposites.indexOf(rule);
        if (index > 0) {
            ResponseCodeRuleComposite higherRule = this.ruleComposites.get(index - 1);
            this.ruleComposites.set(index - 1, rule);
            this.ruleComposites.set(index, higherRule);
            rule.moveAbove((Control)higherRule);
            if (this.isLastRule(higherRule)) {
                higherRule.clearDisableBooleanAndOrCombo();
                rule.enableBooleanAndOrCombo();
            }
            XSwt.layout((Composite)this, (boolean)true);
            XSwt.layout((Composite)this.controlParent, (boolean)true);
            this.responseDialog.packShell();
            this.responseDialog.focusRule(rule);
        }
    }

    public List<ResponseCodeRuleComposite> getRuleComposites() {
        return this.ruleComposites;
    }

    public void moveRuleDown(ResponseCodeRuleComposite rule) {
        int index = this.ruleComposites.indexOf(rule);
        if (index < this.totalRules - 1) {
            ResponseCodeRuleComposite lowerRule = this.ruleComposites.get(index + 1);
            this.ruleComposites.set(index + 1, rule);
            this.ruleComposites.set(index, lowerRule);
            rule.moveBelow((Control)lowerRule);
            if (this.isLastRule(rule)) {
                rule.clearDisableBooleanAndOrCombo();
                lowerRule.enableBooleanAndOrCombo();
            }
            XSwt.layout((Composite)this, (boolean)true);
            XSwt.layout((Composite)this.controlParent, (boolean)true);
            this.responseDialog.packShell();
            this.responseDialog.focusRule(rule);
        }
    }

    public void removeRule(ResponseCodeRuleComposite rule) {
        this.ruleComposites.remove(rule);
        --this.totalRules;
        ResponseCodeRuleComposite lastRule = this.ruleComposites.get(this.totalRules - 1);
        lastRule.clearDisableBooleanAndOrCombo();
        XSwt.dispose((Control)rule);
        XSwt.layout((Composite)this, (boolean)true);
        XSwt.layout((Composite)this.controlParent, (boolean)true);
        this.setSize(this.computeSize(-1, -1));
        this.responseDialog.updateRulesSectionDimensions();
        this.responseDialog.packShell();
    }

    public boolean isFirstRule(ResponseCodeRuleComposite rule) {
        return ListUtilz.isFirstMember(this.ruleComposites, (Object)rule);
    }

    public boolean isLastRule(ResponseCodeRuleComposite rule) {
        return ListUtilz.isLastMember(this.ruleComposites, (Object)rule);
    }

    public boolean isOnlyOneRuleLeft() {
        return ListUtilz.size(this.ruleComposites) == 1;
    }

    private BooleanExpression createSimpleExpression(ResponseCodeRuleComposite ruleComposite) {
        BooleanExpression exp = new BooleanExpression();
        exp.setId(ruleComposite.getRuleName());
        exp.setLeft(ruleComposite.getServicePropertyPath());
        String opStr = ruleComposite.getBooleanOperatorString();
        exp.setOp(opStr);
        if (opStr == BooleanOperator.EXISTS.toString()) {
            exp.setRight(null);
        } else {
            exp.setRight(ruleComposite.getComparisonValue());
        }
        return exp;
    }

    protected static BooleanOperator getAndOrEnum(String op) {
        BooleanOperator retVal = null;
        if ("AND".equals(op)) {
            retVal = BooleanOperator.AND;
        } else if ("OR".equals(op)) {
            retVal = BooleanOperator.OR;
        }
        return retVal;
    }

    protected BooleanExpression createBooleanExpressionFromRules() {
        BooleanExpression rootExp = null;
        if (this.ruleComposites.size() == 1) {
            rootExp = this.createSimpleExpression(this.ruleComposites.get(0));
        } else {
            boolean inAndState = false;
            BooleanExpression inAndExpression = null;
            for (ResponseCodeRuleComposite currRuleComposite : this.ruleComposites) {
                BooleanExpression newSimpleExp = this.createSimpleExpression(currRuleComposite);
                BooleanOperator currAndOr = ResponseCodeRulesComposite.getAndOrEnum(currRuleComposite.getAndORString());
                if (rootExp == null) {
                    rootExp = new BooleanExpression();
                    rootExp.getBooleanExpression().add(newSimpleExp);
                    if (currAndOr == BooleanOperator.AND) {
                        rootExp.setOp(BooleanOperator.AND.toString());
                        inAndState = true;
                        continue;
                    }
                    if (currAndOr != BooleanOperator.OR) continue;
                    rootExp.setOp(BooleanOperator.OR.toString());
                    inAndState = false;
                    continue;
                }
                BooleanOperator rootAndOr = ResponseCodeRulesComposite.getAndOrEnum(rootExp.getOp());
                if (currAndOr != null) {
                    if (rootAndOr == BooleanOperator.AND && currAndOr == BooleanOperator.AND) {
                        rootExp.getBooleanExpression().add(newSimpleExp);
                        inAndState = true;
                        continue;
                    }
                    if (rootAndOr == BooleanOperator.AND && currAndOr == BooleanOperator.OR) {
                        rootExp.getBooleanExpression().add(newSimpleExp);
                        BooleanExpression newRootExp = new BooleanExpression();
                        newRootExp.setOp(BooleanOperator.OR.toString());
                        newRootExp.getBooleanExpression().add(rootExp);
                        rootExp = newRootExp;
                        inAndState = false;
                        continue;
                    }
                    if (rootAndOr == BooleanOperator.OR && currAndOr == BooleanOperator.OR) {
                        if (!inAndState) {
                            rootExp.getBooleanExpression().add(newSimpleExp);
                            continue;
                        }
                        inAndExpression.getBooleanExpression().add(newSimpleExp);
                        inAndState = false;
                        inAndExpression = null;
                        continue;
                    }
                    if (rootAndOr != BooleanOperator.OR || currAndOr != BooleanOperator.AND) continue;
                    if (!inAndState) {
                        inAndExpression = new BooleanExpression();
                        inAndExpression.setOp(BooleanOperator.AND.toString());
                        inAndExpression.getBooleanExpression().add(newSimpleExp);
                        rootExp.getBooleanExpression().add(inAndExpression);
                        inAndState = true;
                        continue;
                    }
                    inAndExpression.getBooleanExpression().add(newSimpleExp);
                    continue;
                }
                if (rootAndOr == BooleanOperator.AND) {
                    rootExp.getBooleanExpression().add(newSimpleExp);
                    continue;
                }
                if (!inAndState) {
                    rootExp.getBooleanExpression().add(newSimpleExp);
                    continue;
                }
                inAndExpression.getBooleanExpression().add(newSimpleExp);
            }
        }
        return rootExp;
    }

    public Map<String, Property> getLeafProperties() {
        return this.leafProperties;
    }

    public int getTotalRules() {
        return this.totalRules;
    }
}

