/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.api.rules.BooleanOperator;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swagger.OpenApi2xUtil;
import com.ibm.zosconnect.ui.common.util.swt.ComboBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.LabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.ModifyListener2;
import com.ibm.zosconnect.ui.common.util.swt.MouseAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.MouseTrackAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.SelectionAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.TextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.controllers.util.ResponseCodeRulesUtil;
import com.ibm.zosconnect.ui.dialogs.AddOrEditResponseDialog;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.dialogs.ResponseCodeRulesComposite;
import com.ibm.zosconnect.ui.editors.listeners.AddOrEditDialogListener;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResponseCodeRuleComposite
extends Composite
implements AddOrEditDialogListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private ResponseCodeRulesComposite logicalParent;
    private ResponseCodeRuleComposite self;
    private Text txtRuleName;
    private Text txtComparisonValue;
    private Combo cmbServicePropertyPath;
    private Combo cmbComparisonOperator;
    private Combo cmbLogicalOperator;
    private Label lblMoveUp;
    private Label lblMoveDown;
    private Label lblRemove;
    private ControlDecoration cd_txtRuleName;
    private ControlDecoration cd_cmbFieldPath;
    private ControlDecoration cd_cmbComparisonOperator;
    private ControlDecoration cd_cmbBooleanAndOr;
    private ControlDecoration cd_textValue;
    private List<String> servicePropertyPaths = new ArrayList<String>();
    private int ruleNumber;
    private boolean isExistingRule = false;
    private String ruleName = null;
    private String ruleServicePropertyPath = null;
    private String ruleComparisonValue = null;
    private BooleanOperator ruleOperator = null;
    private BooleanOperator ruleAndOr = null;
    private AddOrEditResponseDialog responseDialog;
    private Point size_cmbComparisonOperator;
    private boolean servicePropertyPathModified = false;

    public ResponseCodeRuleComposite(Composite controlParent, int ruleNumber, final AddOrEditResponseDialog responseDialog) {
        super(controlParent, 0);
        this.logicalParent = (ResponseCodeRulesComposite)controlParent;
        this.ruleNumber = ruleNumber;
        this.responseDialog = responseDialog;
        this.self = this;
        this.createContent();
        responseDialog.getListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                responseDialog.getListeners().remove(ResponseCodeRuleComposite.this.self);
            }
        });
    }

    public ResponseCodeRuleComposite(Composite controlParent, String id, String fieldPath, BooleanOperator op, String value, BooleanOperator andOr, final AddOrEditResponseDialog responseDialog) {
        super(controlParent, 0);
        this.isExistingRule = true;
        this.ruleName = id;
        this.ruleServicePropertyPath = fieldPath;
        this.ruleComparisonValue = value;
        this.ruleOperator = op;
        this.ruleAndOr = andOr;
        this.logicalParent = (ResponseCodeRulesComposite)controlParent;
        this.responseDialog = responseDialog;
        this.self = this;
        responseDialog.getListeners().add(this.self);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                responseDialog.getListeners().remove(ResponseCodeRuleComposite.this.self);
            }
        });
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayoutBuilder().numColumns(8).marginHeight(0).marginWidth(0).horizontalSpacing(MaxFieldDecorationWidth + 3).verticalSpacing(0).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).build());
        this.setBackgroundMode(1);
        this.populateServicePropertyPaths();
        this.addTxtRuleNumber();
        this.addCmbField();
        this.addCmbBooleanComparison();
        this.addTxtValue();
        this.addCmbBooleanAndOrOperator();
        this.addLblMoveUp();
        this.addLblMoveDown();
        this.addLblRemove();
    }

    private void addTxtRuleNumber() {
        Object ruleNumberStr = this.isExistingRule && this.ruleName != null ? this.ruleName : Xlat.label((String)"APIDLG_LABEL_RULE") + " " + this.ruleNumber;
        this.txtRuleName = (Text)new TextBuilder().text((String)ruleNumberStr).listener((VerifyListener)new VerifyListener2((Control)this.self){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)this.self){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                ResponseCodeRuleComposite.this.responseDialog.validate();
            }
        }).style(Integer.valueOf(2048)).widthHint(15 * XSwt.getAverageCharWidth((Control)this)).build((Composite)this);
        this.cd_txtRuleName = new ControlDecoration((Control)this.txtRuleName, 17408);
    }

    private void addCmbField() {
        this.cmbServicePropertyPath = (Combo)new ComboBuilder().items(this.servicePropertyPaths).text(this.ruleServicePropertyPath).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                ResponseCodeRuleComposite.this.servicePropertyPathModified = true;
                ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                ResponseCodeRuleComposite.this.responseDialog.validate();
            }
        }).listener((ModifyListener)new ModifyListener2((Control)this.self){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ResponseCodeRuleComposite.this.servicePropertyPathModified = true;
                ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                ResponseCodeRuleComposite.this.responseDialog.validate();
            }
        }).style(Integer.valueOf(2048)).widthHint(43 * XSwt.getAverageCharWidth((Control)this)).build((Composite)this);
        this.cd_cmbFieldPath = new ControlDecoration((Control)this.cmbServicePropertyPath, 17408);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.cmbServicePropertyPath, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new FieldProposalProvider(), null, null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setPropagateKeys(true);
    }

    private void addCmbBooleanComparison() {
        String ruleOperatorUIStr = null;
        if (this.ruleOperator != null) {
            ruleOperatorUIStr = ResponseCodeRulesUtil.getUIStringFromBooleanOperator((BooleanOperator)this.ruleOperator);
        }
        this.cmbComparisonOperator = (Combo)new ComboBuilder().items(ResponseCodeRulesUtil.getAllBooleanOperatorUIStrings()).text(ruleOperatorUIStr).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                XSwt.setTooltipText((Control)ResponseCodeRuleComposite.this.cmbComparisonOperator, (String)XSwt.getText((Combo)ResponseCodeRuleComposite.this.cmbComparisonOperator));
                BooleanOperator op = ResponseCodeRulesUtil.getBooleanOperatorFromUIString((String)XSwt.getText((Combo)ResponseCodeRuleComposite.this.cmbComparisonOperator));
                if (op == BooleanOperator.EXISTS) {
                    XSwt.setText((Text)ResponseCodeRuleComposite.this.txtComparisonValue, (String)"");
                    XSwt.disable((Control[])new Control[]{ResponseCodeRuleComposite.this.txtComparisonValue});
                } else {
                    XSwt.enable((Control[])new Control[]{ResponseCodeRuleComposite.this.txtComparisonValue});
                }
                ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                ResponseCodeRuleComposite.this.responseDialog.validate();
            }
        }).style(Integer.valueOf(2056)).enabled(Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)this.cmbServicePropertyPath.getText()))).build((Composite)this);
        this.cd_cmbComparisonOperator = new ControlDecoration((Control)this.cmbComparisonOperator, 17408);
        this.size_cmbComparisonOperator = this.cmbComparisonOperator.computeSize(-1, -1);
        ((GridData)this.cmbComparisonOperator.getLayoutData()).widthHint = this.size_cmbComparisonOperator.x;
    }

    private void addTxtValue() {
        boolean enabled = false;
        if (this.isExistingRule && this.ruleComparisonValue != null && this.isCompatibleOperator(this.ruleServicePropertyPath, this.ruleOperator)) {
            enabled = true;
        }
        this.txtComparisonValue = (Text)new TextBuilder().text(this.ruleComparisonValue != null ? this.ruleComparisonValue : "").listener((VerifyListener)new VerifyListener2((Control)this.self){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)this.self){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                ResponseCodeRuleComposite.this.responseDialog.validate();
            }
        }).style(Integer.valueOf(2048)).widthHint(33 * XSwt.getAverageCharWidth((Control)this)).enabled(Boolean.valueOf(enabled)).build((Composite)this);
        this.cd_textValue = new ControlDecoration((Control)this.txtComparisonValue, 17408);
    }

    private void addCmbBooleanAndOrOperator() {
        boolean enabled = false;
        if (this.isExistingRule || this.ruleAndOr != null) {
            enabled = true;
        }
        String ruleAndOrUIStr = null;
        if (this.ruleAndOr != null) {
            ruleAndOrUIStr = ResponseCodeRulesUtil.getUIStringFromBooleanOperator((BooleanOperator)this.ruleAndOr);
        }
        this.cmbLogicalOperator = (Combo)new ComboBuilder().items(ResponseCodeRulesUtil.getLogicalOperatorUIStrings()).text(ruleAndOrUIStr).listener((SelectionListener)new SelectionAdapter2((Control)this.self){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                if (ResponseCodeRuleComposite.this.logicalParent.isLastRule(ResponseCodeRuleComposite.this.self)) {
                    ResponseCodeRuleComposite.this.logicalParent.addNewRule();
                }
                ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                ResponseCodeRuleComposite.this.responseDialog.validate();
            }
        }).style(Integer.valueOf(2056)).enabled(Boolean.valueOf(enabled)).build((Composite)this);
        this.cd_cmbBooleanAndOr = new ControlDecoration((Control)this.cmbLogicalOperator, 17408);
    }

    private void addLblMoveUp() {
        this.lblMoveUp = (Label)new LabelBuilder().image(XImg.icon((String)"icon-move-up@x1.png")).listener((MouseListener)new MouseAdapter2((Control)this.self){

            public void mouseUp(MouseEvent event) {
                if (!ResponseCodeRuleComposite.this.logicalParent.isFirstRule(ResponseCodeRuleComposite.this.self)) {
                    ResponseCodeRuleComposite.this.logicalParent.moveRuleUp(ResponseCodeRuleComposite.this.self);
                    ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                    ResponseCodeRuleComposite.this.responseDialog.validate();
                } else {
                    new ApiEditorMessageDialog(ResponseCodeRuleComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_RULE_ALREADY_HIGHEST", (String[])new String[]{XSwt.getText((Text)ResponseCodeRuleComposite.this.txtRuleName)}));
                }
            }
        }).listener((MouseTrackAdapter)new MouseTrackAdapter2((Control)this.self){
            final Image normal;
            final Image linked;
            Image currImage;
            {
                this.normal = XImg.icon((String)"icon-move-up@x1.png");
                this.linked = XImg.icon((String)"icon-move-up-hover@x1.png");
                this.currImage = null;
            }

            public void mouseEnter(MouseEvent event, Control owner) throws Exception {
                if (!ResponseCodeRuleComposite.this.logicalParent.isFirstRule(ResponseCodeRuleComposite.this.self) && this.currImage != this.linked) {
                    XSwt.setImage((Label)ResponseCodeRuleComposite.this.lblMoveUp, (Image)this.linked);
                    this.currImage = this.linked;
                }
            }

            public void mouseExit(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.normal) {
                    XSwt.setImage((Label)ResponseCodeRuleComposite.this.lblMoveUp, (Image)this.normal);
                    this.currImage = this.normal;
                }
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addLblMoveDown() {
        this.lblMoveDown = (Label)new LabelBuilder().image(XImg.icon((String)"icon-move-down@x1.png")).listener((MouseListener)new MouseAdapter2((Control)this.self){

            public void mouseUp(MouseEvent event) {
                if (!ResponseCodeRuleComposite.this.logicalParent.isLastRule(ResponseCodeRuleComposite.this.self)) {
                    ResponseCodeRuleComposite.this.logicalParent.moveRuleDown(ResponseCodeRuleComposite.this.self);
                    ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                    ResponseCodeRuleComposite.this.responseDialog.validate();
                } else {
                    new ApiEditorMessageDialog(ResponseCodeRuleComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_RULE_ALREADY_LOWEST", (String[])new String[]{XSwt.getText((Text)ResponseCodeRuleComposite.this.txtRuleName)}));
                }
            }
        }).listener((MouseTrackAdapter)new MouseTrackAdapter2((Control)this.self){
            final Image normal;
            final Image linked;
            Image currImage;
            {
                this.normal = XImg.icon((String)"icon-move-down@x1.png");
                this.linked = XImg.icon((String)"icon-move-down-hover@x1.png");
                this.currImage = null;
            }

            public void mouseEnter(MouseEvent event, Control owner) throws Exception {
                if (!ResponseCodeRuleComposite.this.logicalParent.isLastRule(ResponseCodeRuleComposite.this.self) && this.currImage != this.linked) {
                    XSwt.setImage((Label)ResponseCodeRuleComposite.this.lblMoveDown, (Image)this.linked);
                    this.currImage = this.linked;
                }
            }

            public void mouseExit(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.normal) {
                    XSwt.setImage((Label)ResponseCodeRuleComposite.this.lblMoveDown, (Image)this.normal);
                    this.currImage = this.normal;
                }
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
    }

    private void addLblRemove() {
        this.lblRemove = (Label)new LabelBuilder().image(XImg.icon((String)"icon-delete@x1.png")).listener((MouseListener)new MouseAdapter2((Control)this.self){

            public void mouseUp(MouseEvent event) {
                if (!ResponseCodeRuleComposite.this.logicalParent.isOnlyOneRuleLeft()) {
                    ApiEditorMessageDialog dialog = new ApiEditorMessageDialog(XSwt.getActiveShell(), true);
                    if (dialog.openConfirm(Xlat.description((String)"CONFIRM_DELETE_RULE", (String[])new String[]{XSwt.getText((Text)ResponseCodeRuleComposite.this.txtRuleName)}))) {
                        ResponseCodeRuleComposite.this.logicalParent.removeRule(ResponseCodeRuleComposite.this.self);
                        ResponseCodeRuleComposite.this.responseDialog.setDirty(true);
                        ResponseCodeRuleComposite.this.responseDialog.validate();
                    }
                } else {
                    new ApiEditorMessageDialog(ResponseCodeRuleComposite.this.getShell(), true).openInfo(Xlat.description((String)"INFO_RULE_AT_LEAST_ONE"));
                }
            }
        }).listener((MouseTrackAdapter)new MouseTrackAdapter2((Control)this.self){
            final Image normal;
            final Image linked;
            Image currImage;
            {
                this.normal = XImg.icon((String)"icon-delete@x1.png");
                this.linked = XImg.icon((String)"icon-delete-hover@x1.png");
                this.currImage = null;
            }

            public void mouseEnter(MouseEvent event, Control owner) throws Exception {
                if (!ResponseCodeRuleComposite.this.logicalParent.isOnlyOneRuleLeft() && this.currImage != this.linked) {
                    XSwt.setImage((Label)ResponseCodeRuleComposite.this.lblRemove, (Image)this.linked);
                    this.currImage = this.linked;
                }
            }

            public void mouseExit(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.normal) {
                    XSwt.setImage((Label)ResponseCodeRuleComposite.this.lblRemove, (Image)this.normal);
                    this.currImage = this.normal;
                }
            }
        }).horizontalAlignment(131072).verticalAlignment(0x1000000).build((Composite)this);
    }

    public String getRuleName() {
        return XSwt.getText((Text)this.txtRuleName);
    }

    public String getServicePropertyPath() {
        return XSwt.getText((Combo)this.cmbServicePropertyPath);
    }

    public String getBooleanOperatorString() {
        BooleanOperator op = ResponseCodeRulesUtil.getBooleanOperatorFromUIString((String)this.cmbComparisonOperator.getText());
        if (op == null) {
            return null;
        }
        return op.toString();
    }

    public String getComparisonValue() {
        return XSwt.getText((Text)this.txtComparisonValue);
    }

    public String getAndORString() {
        return XSwt.getText((Combo)this.cmbLogicalOperator);
    }

    private boolean isCompatibleOperator(String leafFieldPath, BooleanOperator operator) {
        Property property = this.logicalParent.getLeafProperties().get(leafFieldPath);
        return ResponseCodeRulesUtil.isOperatorCompatible((Property)property, (BooleanOperator)operator);
    }

    private List<String> getPropertyOperatorUIStrings(String leafFieldPath) {
        Property property = this.logicalParent.getLeafProperties().get(leafFieldPath);
        return ResponseCodeRulesUtil.getPropertyOperatorUIStrings((Property)property);
    }

    private void populateServicePropertyPaths() {
        for (Map.Entry<String, Property> leafProp : this.logicalParent.getLeafProperties().entrySet()) {
            String leafFieldPath = leafProp.getKey();
            this.servicePropertyPaths.add(leafFieldPath);
        }
    }

    protected void clearDisableBooleanAndOrCombo() {
        XSwt.deselectAll((Combo)this.cmbLogicalOperator);
        XSwt.disable((Control[])new Control[]{this.cmbLogicalOperator});
    }

    protected void enableBooleanAndOrCombo() {
        if (this.cmbServicePropertyPath.getText() != null && !this.cmbServicePropertyPath.getText().isEmpty()) {
            this.cmbLogicalOperator.setEnabled(true);
        }
    }

    @Override
    public IStatus doValidate() {
        String comparisonValue;
        String msg;
        IStatus status = Status.OK_STATUS;
        BooleanOperator comparisonOperator = ResponseCodeRulesUtil.getBooleanOperatorFromUIString((String)XSwt.getText((Combo)this.cmbComparisonOperator));
        BooleanOperator logicalOperator = ResponseCodeRulesUtil.getBooleanOperatorFromUIString((String)XSwt.getText((Combo)this.cmbLogicalOperator));
        String servicePropertyPath = this.getServicePropertyPath();
        if (!StringUtils.isBlank((CharSequence)servicePropertyPath)) {
            List<String> operators = this.getPropertyOperatorUIStrings(XSwt.getText((Combo)this.cmbServicePropertyPath));
            String operator = XSwt.getText((Combo)this.cmbComparisonOperator);
            XSwt.setItems((Combo)this.cmbComparisonOperator, operators);
            if (XSwt.containsItem((Combo)this.cmbComparisonOperator, (String)operator)) {
                XSwt.setText((Combo)this.cmbComparisonOperator, (String)operator);
            } else {
                XSwt.clearSelection((Combo)this.cmbComparisonOperator);
            }
            XSwt.enable((Control[])new Control[]{this.cmbComparisonOperator});
            XSwt.enable((Control[])new Control[]{this.txtComparisonValue});
        }
        if (!this.logicalParent.isLastRule(this.self)) {
            XSwt.enable((Control[])new Control[]{this.cmbLogicalOperator});
        } else {
            XSwt.disable((Control[])new Control[]{this.cmbLogicalOperator});
        }
        String ruleName = this.getRuleName();
        if (StringUtils.isBlank((CharSequence)ruleName)) {
            msg = Xlat.error((String)"RULES_NAME_EMPTY");
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_txtRuleName, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (!this.isRuleNameUnique(ruleName)) {
            msg = Xlat.error((String)"RULES_NAME_NOT_UNIQUE", (String[])new String[]{ruleName});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_txtRuleName, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (XSwt.isVisible((ControlDecoration)this.cd_txtRuleName)) {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_txtRuleName);
        }
        if (StringUtils.isBlank((CharSequence)servicePropertyPath) || this.servicePropertyPathModified && !this.servicePropertyPaths.contains(servicePropertyPath)) {
            msg = Xlat.error((String)"RULES_SERVICE_FIELD_EMPTY", (String[])new String[]{ruleName});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_cmbFieldPath, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (!this.servicePropertyPaths.contains(servicePropertyPath)) {
            msg = Xlat.error((String)"RULES_SERVICE_FIELD_NOT_FOUND", (String[])new String[]{servicePropertyPath, ruleName});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_cmbFieldPath, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (XSwt.isVisible((ControlDecoration)this.cd_cmbFieldPath)) {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_cmbFieldPath);
        }
        Property property = this.logicalParent.getLeafProperties().get(servicePropertyPath);
        if (comparisonOperator == null) {
            msg = Xlat.error((String)"RULES_COMPARISON_OPERATOR_EMPTY", (String[])new String[]{ruleName});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_cmbComparisonOperator, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (property != null && !ResponseCodeRulesUtil.isOperatorCompatible((Property)property, (BooleanOperator)comparisonOperator)) {
            String operatorUIStr = ResponseCodeRulesUtil.getUIStringFromBooleanOperator((BooleanOperator)comparisonOperator);
            msg = Xlat.error((String)"RULES_COMPARISON_OPERATOR_INCOMPAT", (String[])new String[]{operatorUIStr, servicePropertyPath});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_cmbComparisonOperator, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (XSwt.isVisible((ControlDecoration)this.cd_cmbComparisonOperator)) {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_cmbComparisonOperator);
        }
        if (!this.logicalParent.isLastRule(this.self) && logicalOperator == null) {
            msg = Xlat.error((String)"RULES_LOGICAL_OPERATOR_EMPTY", (String[])new String[]{ruleName});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_cmbBooleanAndOr, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (XSwt.isVisible((ControlDecoration)this.cd_cmbBooleanAndOr)) {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_cmbBooleanAndOr);
        }
        if (StringUtils.isBlank((CharSequence)(comparisonValue = this.getComparisonValue())) && !BooleanOperator.EXISTS.equals((Object)comparisonOperator)) {
            msg = Xlat.error((String)"RULES_COMPARSION_VALUE_EMPTY", (String[])new String[]{servicePropertyPath, ruleName});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textValue, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (property instanceof StringProperty && !OpenApi2xUtil.isValueInRange((Property)property, (String)comparisonValue)) {
            StringProperty stringProperty = (StringProperty)property;
            msg = OpenApi2xUtil.isValueTooShort((StringProperty)stringProperty, (String)comparisonValue) ? Xlat.error((String)"RULES_COMPARISON_VALUE_MIN_LENGTH", (Object[])new Object[]{comparisonValue, servicePropertyPath, OpenApi2xUtil.getMinLength((StringProperty)stringProperty)}) : Xlat.error((String)"RULES_COMPARISON_VALUE_MAX_LENGTH", (Object[])new Object[]{comparisonValue, servicePropertyPath, OpenApi2xUtil.getMaxLength((StringProperty)stringProperty)});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textValue, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (property instanceof AbstractNumericProperty && !NumberUtils.isNumber((String)comparisonValue)) {
            msg = Xlat.error((String)"RULES_COMPARISON_VALUE_NOT_NUMERIC", (String[])new String[]{comparisonValue, servicePropertyPath});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textValue, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (property instanceof AbstractNumericProperty && !OpenApi2xUtil.isValueInRange((Property)property, (String)comparisonValue)) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
            msg = OpenApi2xUtil.isValueTooSmall((AbstractNumericProperty)numericProperty, (String)comparisonValue) ? Xlat.error((String)"RULES_COMPARISON_VALUE_MIN_QUANTITY", (String[])new String[]{comparisonValue, servicePropertyPath, OpenApi2xUtil.getMinimum((AbstractNumericProperty)numericProperty).toPlainString()}) : Xlat.error((String)"RULES_COMPARISON_VALUE_MAX_QUANTITY", (String[])new String[]{comparisonValue, servicePropertyPath, OpenApi2xUtil.getMaximum((AbstractNumericProperty)numericProperty).toPlainString()});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textValue, (String)msg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", msg);
            }
        } else if (XSwt.isVisible((ControlDecoration)this.cd_textValue)) {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_textValue);
        }
        XSwt.setTooltipText((Control)this.txtRuleName, (String)ruleName);
        XSwt.setTooltipText((Control)this.cmbServicePropertyPath, (String)servicePropertyPath);
        XSwt.setTooltipText((Control)this.cmbComparisonOperator, (String)XSwt.getText((Combo)this.cmbComparisonOperator));
        XSwt.setTooltipText((Control)this.txtComparisonValue, (String)comparisonValue);
        XSwt.setTooltipText((Control)this.lblMoveUp, (String)Xlat.description((String)"TOOLTIP_INCREASE_RULE_PRECEDENCE", (String[])new String[]{ruleName}));
        XSwt.setTooltipText((Control)this.lblMoveDown, (String)Xlat.description((String)"TOOLTIP_DECREASE_RULE_PRECEDENCE", (String[])new String[]{ruleName}));
        XSwt.setTooltipText((Control)this.lblRemove, (String)Xlat.description((String)"TOOLTIP_DELETE_RULE", (String[])new String[]{ruleName}));
        return status;
    }

    public boolean isRuleNameUnique(String ruleName) {
        boolean isUnique = true;
        Iterator<ResponseCodeRuleComposite> rulesIt = this.logicalParent.getRuleComposites().iterator();
        while (isUnique && rulesIt.hasNext()) {
            ResponseCodeRuleComposite ruleComposite = rulesIt.next();
            if (ruleComposite == this.self || !StringUtils.equals((CharSequence)ruleComposite.getRuleName(), (CharSequence)ruleName)) continue;
            isUnique = false;
        }
        return isUnique;
    }

    public boolean setFocus() {
        return XSwt.focus((Control)this.txtRuleName);
    }

    private class FieldProposalProvider
    implements IContentProposalProvider {
        private FieldProposalProvider() {
        }

        public IContentProposal[] getProposals(String text, int textLen) {
            text = StringUtils.trimToEmpty((String)text);
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            if (StringUtils.isEmpty((CharSequence)text)) {
                String[] stringArray = ResponseCodeRuleComposite.this.cmbServicePropertyPath.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    proposals.add(new ContentProposal(item));
                    ++n2;
                }
            } else {
                String item;
                ArrayList<String> proposedItems = new ArrayList<String>();
                String[] stringArray = ResponseCodeRuleComposite.this.cmbServicePropertyPath.getItems();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    item = stringArray[n3];
                    if (StringUtils.startsWithIgnoreCase((CharSequence)item, (CharSequence)text)) {
                        proposals.add(new ContentProposal(item));
                        proposedItems.add(item);
                    }
                    ++n3;
                }
                stringArray = ResponseCodeRuleComposite.this.cmbServicePropertyPath.getItems();
                n = stringArray.length;
                n3 = 0;
                while (n3 < n) {
                    item = stringArray[n3];
                    if (!proposedItems.contains(item) && StringUtils.containsIgnoreCase((CharSequence)item, (CharSequence)text)) {
                        proposals.add(new ContentProposal(item));
                    }
                    ++n3;
                }
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
    }
}

