/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.MappingValidationProblem2;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.problems.model.ProblemsContentProvider;
import com.ibm.zosconnect.ui.problems.model.ProblemsLabelProvider;
import com.ibm.zosconnect.ui.problems.model.ProblemsNode;
import com.ibm.zosconnect.ui.problems.model.ProblemsTreeParent;
import com.ibm.zosconnect.ui.problems.model.ProblemsType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.WorkbenchJob;

public class ImportServicesImpactAnalysisDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite mainComposite;
    private Composite compDialogArea;
    private Label labelDescription;
    private Label labelNewServicesTable;
    private Label labelExistingServicesTable;
    private Label labelProblemsTable;
    private Table tableNewServices;
    private Table tableExistingServices;
    private TableColumn table1Col1;
    private TableColumn table1Col2;
    private TableColumn table2Col1;
    private TableColumn table2Col2;
    private TreeViewerColumn table3Col1;
    private TreeViewerColumn table3Col2;
    private TreeViewerColumn table3Col3;
    private TreeViewerColumn table3Col4;
    private TreeViewerColumn table3Col5;
    private TreeViewerColumn table3Col6;
    private TreeViewerColumn table3Col7;
    private FilteredTree filteredTree;
    private TreeViewer viewer;
    private Rectangle screen;
    public static final String[] COLUMN_NAMES = new String[]{Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL1"), Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL2"), Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL3"), Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL4"), Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL5"), Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL6"), Xlat.label((String)"IMPACT_ANALYSIS_PROBLEMS_TABLE_COL7")};
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private static final int NUM_ROWS_DISPLAYED = 4;
    private static final double descriptionScale = 0.42;
    private static final double mappingScale = 0.07;
    private static final double pathScale = 0.1;
    private static final double methodScale = 0.05;
    private static final double opidScale = 0.15;
    private static final double serviceScale = 0.1;
    private static final double typeScale = 0.1;
    private int dialogWidth;
    private int dialogHeight;
    private ApiProjectController apiProjectController;
    private HashMap<String, String> newServicesNameDesc;
    private HashMap<String, String> overlappedServicesNameDesc;

    public ImportServicesImpactAnalysisDialog(Shell parent, ApiProjectController apiProjectController, HashMap<String, String> newServices, HashMap<String, String> overlappedServices) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.newServicesNameDesc = newServices;
        this.overlappedServicesNameDesc = overlappedServices;
        this.apiProjectController = apiProjectController;
        this.setTitle(Xlat.label((String)"IMPACT_ANALYSIS_TITLE"));
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        int tableHeight;
        TableItem tableItem;
        String currServiceName;
        int i;
        this.screen = XSwt.getScreenSize();
        boolean hasNewServices = this.newServicesNameDesc.size() > 0;
        final boolean hasOverlappedServices = this.overlappedServicesNameDesc.size() > 0;
        this.dialogWidth = !hasOverlappedServices ? Math.max(400, (int)(0.4 * (double)this.screen.width)) : Math.max(800, (int)(0.8 * (double)this.screen.width));
        this.dialogHeight = !hasOverlappedServices ? Math.max(200, (int)(0.2 * (double)this.screen.height)) : Math.max(800, (int)(0.8 * (double)this.screen.height));
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.formToolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        this.compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        this.compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        this.compDialogArea.setLayout((Layout)gridLayout);
        this.compContents = new Composite(this.compDialogArea, 0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = this.dialogWidth;
        gridData.heightHint = this.dialogHeight;
        this.compContents.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 5;
        gridLayout.marginLeft = 2;
        gridLayout.marginRight = 2;
        gridLayout.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gridLayout);
        if (hasOverlappedServices) {
            this.labelDescription = new Label(this.compContents, 64);
            gridData = new GridData(4, 0x1000000, true, false, 1, 1);
            this.labelDescription.setLayoutData((Object)gridData);
            if (!hasNewServices) {
                this.labelDescription.setText(Xlat.label((String)"IMPORT_EXISTING_SERVICE_DESC1"));
            } else {
                this.labelDescription.setText(Xlat.label((String)"IMPORT_EXISTING_SERVICE_DESC2"));
            }
        }
        if (hasNewServices) {
            this.labelNewServicesTable = new Label(this.compContents, 0);
            this.labelNewServicesTable.setText(Xlat.label((String)"IMPORT_NEW_SERVICE_LIST") + Xlat.colon());
            gridData = new GridData(4, 0x1000000, true, false, 1, 1);
            gridData.verticalIndent = 10;
            this.labelNewServicesTable.setLayoutData((Object)gridData);
            this.tableNewServices = new Table(this.compContents, 2560);
            this.table2Col1 = new TableColumn(this.tableNewServices, 4);
            this.table2Col1.setText(Xlat.label((String)"IMPACT_ANALYSIS_SERVICES_TABLE_COL1"));
            this.table2Col2 = new TableColumn(this.tableNewServices, 4);
            this.table2Col2.setText(Xlat.label((String)"IMPACT_ANALYSIS_SERVICES_TABLE_COL2"));
            ArrayList<String> newServiceNames = new ArrayList<String>(this.newServicesNameDesc.keySet());
            Collections.sort(newServiceNames, String.CASE_INSENSITIVE_ORDER);
            i = 0;
            while (i < newServiceNames.size()) {
                currServiceName = newServiceNames.get(i);
                tableItem = new TableItem(this.tableNewServices, 0);
                tableItem.setText(0, currServiceName);
                tableItem.setText(1, this.newServicesNameDesc.get(currServiceName));
                ++i;
            }
            if (hasOverlappedServices) {
                gridData = new GridData(4, 0x1000000, true, false, 1, 1);
                if (this.newServicesNameDesc.size() > 4) {
                    gridData.heightHint = tableHeight = this.tableNewServices.getItemHeight() * 4 + this.tableNewServices.getHeaderHeight();
                }
            } else {
                gridData = new GridData(4, 4, true, true, 1, 1);
            }
            this.tableNewServices.setHeaderVisible(true);
            this.tableNewServices.setLinesVisible(true);
            this.tableNewServices.setLayoutData((Object)gridData);
            this.tableNewServices.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = ImportServicesImpactAnalysisDialog.this.compContents.getClientArea();
                    int tableWidth = area.width - 2 - 2 - 2 * ImportServicesImpactAnalysisDialog.this.tableNewServices.getBorderWidth() - 10;
                    ImportServicesImpactAnalysisDialog.this.table2Col1.setWidth((int)(0.35 * (double)tableWidth));
                    ImportServicesImpactAnalysisDialog.this.table2Col2.setWidth((int)(0.65 * (double)tableWidth));
                }
            });
        }
        if (hasOverlappedServices) {
            this.labelExistingServicesTable = new Label(this.compContents, 0);
            this.labelExistingServicesTable.setText(Xlat.label((String)"IMPORT_EXISTING_SERVICE_LIST") + Xlat.colon());
            gridData = new GridData(4, 0x1000000, true, false, 1, 1);
            gridData.verticalIndent = 20;
            this.labelExistingServicesTable.setLayoutData((Object)gridData);
            this.tableExistingServices = new Table(this.compContents, 2560);
            this.table1Col1 = new TableColumn(this.tableExistingServices, 4);
            this.table1Col1.setText(Xlat.label((String)"IMPACT_ANALYSIS_SERVICES_TABLE_COL1"));
            this.table1Col2 = new TableColumn(this.tableExistingServices, 4);
            this.table1Col2.setText(Xlat.label((String)"IMPACT_ANALYSIS_SERVICES_TABLE_COL2"));
            ArrayList<String> overlappedServiceNames = new ArrayList<String>(this.overlappedServicesNameDesc.keySet());
            Collections.sort(overlappedServiceNames, String.CASE_INSENSITIVE_ORDER);
            i = 0;
            while (i < overlappedServiceNames.size()) {
                currServiceName = overlappedServiceNames.get(i);
                tableItem = new TableItem(this.tableExistingServices, 0);
                tableItem.setText(0, currServiceName);
                tableItem.setText(1, this.overlappedServicesNameDesc.get(currServiceName));
                ++i;
            }
            gridData = new GridData(4, 0x1000000, true, false, 1, 1);
            if (this.overlappedServicesNameDesc.size() > 4) {
                gridData.heightHint = tableHeight = this.tableExistingServices.getItemHeight() * 4 + this.tableExistingServices.getHeaderHeight();
            }
            this.tableExistingServices.setHeaderVisible(true);
            this.tableExistingServices.setLinesVisible(true);
            this.tableExistingServices.setLayoutData((Object)gridData);
            this.tableExistingServices.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = ImportServicesImpactAnalysisDialog.this.compContents.getClientArea();
                    int tableWidth = area.width - 2 - 2 - 2 * ImportServicesImpactAnalysisDialog.this.tableExistingServices.getBorderWidth() - 10;
                    ImportServicesImpactAnalysisDialog.this.table1Col1.setWidth((int)(0.35 * (double)tableWidth));
                    ImportServicesImpactAnalysisDialog.this.table1Col2.setWidth((int)(0.65 * (double)tableWidth));
                }
            });
        }
        if (hasOverlappedServices) {
            this.labelProblemsTable = new Label(this.compContents, 0);
            this.labelProblemsTable.setText(Xlat.label((String)"IMPORT_EXISTING_SERVICE_PROBLEMS") + Xlat.colon());
            gridData = new GridData(4, 0x1000000, true, false, 1, 1);
            gridData.verticalIndent = 20;
            this.labelProblemsTable.setLayoutData((Object)gridData);
            this.filteredTree = new FilteredTree(this.compContents, 67586, new ProblemsPatternFilter(), true){

                protected WorkbenchJob doCreateRefreshJob() {
                    WorkbenchJob job = super.doCreateRefreshJob();
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            Text filterControl = (this).ImportServicesImpactAnalysisDialog.this.filteredTree.getFilterControl();
                            String filterText = XSwt.getTrimText((Text)filterControl);
                            if (StringUtils.isBlank((CharSequence)filterText)) {
                                ImportServicesImpactAnalysisDialog.this.restoreExpansionState();
                            }
                        }
                    });
                    return job;
                }
            };
            this.viewer = this.filteredTree.getViewer();
            Tree tree = this.viewer.getTree();
            tree.setLinesVisible(true);
            gridData = new GridData(4, 4, true, true, 1, 1);
            tree.setLayoutData((Object)gridData);
            this.filteredTree.setLayoutData((Object)gridData);
            ArrayList<TreeViewerColumn> treeViewerCols = new ArrayList<TreeViewerColumn>();
            int i2 = 0;
            while (i2 < COLUMN_NAMES.length) {
                TreeViewerColumn column = new TreeViewerColumn(this.viewer, 16384);
                column.getColumn().setText(COLUMN_NAMES[i2]);
                column.getColumn().setAlignment(16384);
                treeViewerCols.add(column);
                ++i2;
            }
            this.table3Col1 = (TreeViewerColumn)treeViewerCols.get(0);
            this.table3Col2 = (TreeViewerColumn)treeViewerCols.get(1);
            this.table3Col3 = (TreeViewerColumn)treeViewerCols.get(2);
            this.table3Col4 = (TreeViewerColumn)treeViewerCols.get(3);
            this.table3Col5 = (TreeViewerColumn)treeViewerCols.get(4);
            this.table3Col6 = (TreeViewerColumn)treeViewerCols.get(5);
            this.table3Col7 = (TreeViewerColumn)treeViewerCols.get(6);
            this.viewer.setContentProvider((IContentProvider)new ProblemsContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
            this.populateMsgsTable();
            tree.setHeaderVisible(true);
            this.viewer.expandToLevel(3);
            this.compContents.addControlListener((ControlListener)new ControlAdapter(){
                boolean initial = true;

                public void controlResized(ControlEvent e) {
                    if (this.initial) {
                        this.initial = false;
                        Rectangle area = ImportServicesImpactAnalysisDialog.this.compContents.getClientArea();
                        int width = area.width - 2 - 2 - 2 * ImportServicesImpactAnalysisDialog.this.tableExistingServices.getBorderWidth() - 10;
                        ImportServicesImpactAnalysisDialog.this.table3Col1.getColumn().setWidth((int)(0.42 * (double)width));
                        ImportServicesImpactAnalysisDialog.this.table3Col2.getColumn().setWidth((int)(0.07 * (double)width));
                        ImportServicesImpactAnalysisDialog.this.table3Col3.getColumn().setWidth((int)(0.1 * (double)width));
                        ImportServicesImpactAnalysisDialog.this.table3Col4.getColumn().setWidth((int)(0.05 * (double)width));
                        ImportServicesImpactAnalysisDialog.this.table3Col5.getColumn().setWidth((int)(0.15 * (double)width));
                        ImportServicesImpactAnalysisDialog.this.table3Col6.getColumn().setWidth((int)(0.1 * (double)width));
                        ImportServicesImpactAnalysisDialog.this.table3Col7.getColumn().setWidth((int)(0.1 * (double)width));
                    }
                }
            });
        }
        this.compContents.layout(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.compDialogArea, "com.ibm.zosconnect.ui.reimportservices");
        this.compDialogArea.addPaintListener(new PaintListener(){
            boolean initial = true;

            public void paintControl(PaintEvent event) {
                if (this.initial && hasOverlappedServices) {
                    this.initial = false;
                    XSwt.centerInWorkbench((Shell)ImportServicesImpactAnalysisDialog.this.getShell());
                }
            }
        });
        return this.compDialogArea;
    }

    private void restoreExpansionState() {
        this.viewer.expandToLevel(3);
    }

    private void populateMsgsTable() {
        List errorMsgs = this.apiProjectController.getErrorProblems();
        List warningMsgs = this.apiProjectController.getWarningProblems();
        List otherMsgs = this.apiProjectController.getOtherProblems();
        String errorTypeTitle = errorMsgs.size() == 1 ? Xlat.label((String)"IMPORT_EXISTING_SERVICE_ERROR", (String[])new String[]{"1"}) : Xlat.label((String)"IMPORT_EXISTING_SERVICE_ERRORS", (String[])new String[]{Integer.toString(errorMsgs.size())});
        String warningTypeTitle = warningMsgs.size() == 1 ? Xlat.label((String)"IMPORT_EXISTING_SERVICE_WARNING", (String[])new String[]{"1"}) : Xlat.label((String)"IMPORT_EXISTING_SERVICE_WARNINGS", (String[])new String[]{Integer.toString(warningMsgs.size())});
        String infoTypeTitle = otherMsgs.size() == 1 ? Xlat.label((String)"IMPORT_EXISTING_SERVICE_OTHER", (String[])new String[]{"1"}) : Xlat.label((String)"IMPORT_EXISTING_SERVICE_OTHERS", (String[])new String[]{Integer.toString(otherMsgs.size())});
        ProblemsTreeParent invisibleRoot = new ProblemsTreeParent("", null);
        ProblemsType errorsType = new ProblemsType(errorTypeTitle, invisibleRoot);
        errorsType.probType = ProblemsType.ProbType.ERRORS;
        ProblemsType warningsType = new ProblemsType(warningTypeTitle, invisibleRoot);
        warningsType.probType = ProblemsType.ProbType.WARNINGS;
        ProblemsType infoType = new ProblemsType(infoTypeTitle, invisibleRoot);
        infoType.probType = ProblemsType.ProbType.INFO;
        invisibleRoot.addChild(errorsType);
        invisibleRoot.addChild(warningsType);
        invisibleRoot.addChild(infoType);
        Iterator it1 = errorMsgs.iterator();
        while (it1.hasNext()) {
            ProblemsNode probNode = new ProblemsNode((MappingValidationProblem2)it1.next(), (ProblemsTreeParent)errorsType);
            errorsType.addChild(probNode);
        }
        Iterator it2 = warningMsgs.iterator();
        while (it2.hasNext()) {
            ProblemsNode probNode = new ProblemsNode((MappingValidationProblem2)it2.next(), (ProblemsTreeParent)warningsType);
            warningsType.addChild(probNode);
        }
        Iterator it3 = otherMsgs.iterator();
        while (it3.hasNext()) {
            ProblemsNode probNode = new ProblemsNode((MappingValidationProblem2)it3.next(), (ProblemsTreeParent)infoType);
            infoType.addChild(probNode);
        }
        this.viewer.setInput((Object)invisibleRoot);
    }

    private class ProblemsPatternFilter
    extends PatternFilter {
        private ProblemsPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof ProblemsType) {
                return true;
            }
            MappingValidationProblem2 msg = ((ProblemsNode)element).getMsg();
            if (msg == null) {
                return false;
            }
            String labelText = msg.getMessage() + " " + msg.getMethod() + " " + msg.getOperationId() + " " + msg.getPath() + " " + msg.getService() + " " + String.valueOf(msg.getType());
            return this.wordMatches(labelText);
        }
    }
}

