/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZCeeProjectConstants;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.PosixPortableValidator;
import com.ibm.zosconnect.ui.controllers.api.ApiArchiveExportController;
import com.ibm.zosconnect.ui.dialogs.ApiEditorMessageDialog;
import com.ibm.zosconnect.ui.dialogs.WorkspaceFileSelectionDialog;
import java.io.File;
import java.nio.file.Files;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExportApiDialog
extends StatusDialog
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ApiArchiveExportController controller;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Label lblSelectServiceArchive;
    private Label lblDescription;
    private Text textFolder;
    private Text textFileName;
    private Button buttonWorkspace;
    private Button buttonFileSystem;
    private Button buttonRemoteFileSystem;
    private Button buttonBrowse;
    private Button okButton;
    private Button buttonOverwrite;
    private String localNativePath;
    private IResource workspaceFolder;
    private final String aarFileExt = ".aar";

    public ExportApiDialog(Shell parentShell, ApiArchiveExportController controller) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) throws Exception {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.lblDescription = new Label(this.compContents, 64);
        this.lblDescription.setText(Xlat.label((String)"EXPRT_API_DLG_DESCR"));
        GridData gd_description = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_description.widthHint = 500;
        this.lblDescription.setLayoutData((Object)gd_description);
        Group radioGroup = new Group(this.compContents, 0);
        radioGroup.setText(Xlat.label((String)"EXPRT_API_DLG_RADIO_GROUP_TITLE") + Xlat.colon());
        GridLayout gl_radioGroup = new GridLayout(1, false);
        gl_radioGroup.marginTop = 5;
        gl_radioGroup.verticalSpacing = 10;
        radioGroup.setLayout((Layout)gl_radioGroup);
        GridData gd_radioGroup = new GridData(4, 0x1000000, true, false, 3, 1);
        radioGroup.setLayoutData((Object)gd_radioGroup);
        this.buttonWorkspace = new Button((Composite)radioGroup, 16);
        this.buttonWorkspace.setText(Xlat.label((String)"EXPRT_API_DLG_WORKSPACE"));
        this.buttonWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportApiDialog.this.buttonWorkspace.getSelection()) {
                    try {
                        String prevPath = ExportApiDialog.this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_FILEPATH);
                        if (prevPath != null && !prevPath.isEmpty()) {
                            ExportApiDialog.this.textFolder.setText(prevPath);
                            ExportApiDialog.this.localNativePath = ExportApiDialog.this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_OS_FILEPATH);
                            ExportApiDialog.this.validateInput();
                        } else {
                            ExportApiDialog.this.textFolder.setText("");
                            XSwt.disable((Control[])new Control[]{ExportApiDialog.this.okButton});
                        }
                    }
                    catch (CoreException e1) {
                        ZCeeUILogger.error((Throwable)e1);
                    }
                }
            }
        });
        this.buttonWorkspace.setSelection(true);
        this.buttonFileSystem = new Button((Composite)radioGroup, 16);
        this.buttonFileSystem.setText(Xlat.label((String)"EXPRT_API_DLG_LOCAL_FS"));
        this.buttonFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportApiDialog.this.buttonFileSystem.getSelection()) {
                    try {
                        String prevPath = ExportApiDialog.this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_LOCAL_FILEPATH);
                        if (prevPath != null && !prevPath.isEmpty()) {
                            ExportApiDialog.this.textFolder.setText(prevPath);
                            ExportApiDialog.this.localNativePath = prevPath;
                            ExportApiDialog.this.validateInput();
                        } else {
                            ExportApiDialog.this.textFolder.setText("");
                            XSwt.disable((Control[])new Control[]{ExportApiDialog.this.okButton});
                        }
                    }
                    catch (CoreException e1) {
                        ZCeeUILogger.error((Throwable)e1);
                    }
                }
            }
        });
        this.lblSelectServiceArchive = new Label(this.compContents, 0);
        this.lblSelectServiceArchive.setText(Xlat.label((String)"EXPRT_API_DLG_FOLDER") + Xlat.colon());
        this.textFolder = new Text(this.compContents, 2048);
        this.textFolder.setEditable(false);
        GridData gd_textFolder = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textFolder.setLayoutData((Object)gd_textFolder);
        String prevPath = this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_FILEPATH);
        if (prevPath != null && !prevPath.isEmpty()) {
            this.textFolder.setText(prevPath);
            String prevOsPath = this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_OS_FILEPATH);
            Path wsSaveFolderPath = new Path(prevOsPath);
            this.workspaceFolder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)wsSaveFolderPath);
        }
        this.buttonBrowse = new Button(this.compContents, 0);
        this.buttonBrowse.setText(Xlat.label((String)"EXPRT_API_DLG_BROWSE"));
        this.buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportApiDialog.this.handleBrowse();
            }
        });
        Label lblFileName = new Label(this.compContents, 0);
        lblFileName.setText(Xlat.label((String)"EXPRT_API_DLG_FILE") + Xlat.colon());
        this.textFileName = new Text(this.compContents, 2048);
        String apiName = this.controller.getApiName();
        this.textFileName.setText(ExportApiDialog.sanitizeFileName(apiName));
        this.textFileName.addModifyListener((ModifyListener)this);
        GridData gd_textFileName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textFileName.setLayoutData((Object)gd_textFileName);
        Label lblFileExt = new Label(this.compContents, 0);
        lblFileExt.setText(".aar");
        this.buttonOverwrite = new Button(this.compContents, 32);
        this.buttonOverwrite.setText(Xlat.label((String)"EXPRT_API_DLG_OVERWRITE"));
        GridData gd_buttonOverwrite = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_buttonOverwrite.horizontalSpan = 3;
        this.buttonOverwrite.setLayoutData((Object)gd_buttonOverwrite);
        this.buttonOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportApiDialog.this.validateInput();
            }
        });
        new Label(compDialogArea, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.exportwizard");
        this.localNativePath = this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_OS_FILEPATH);
        return compDialogArea;
    }

    public void create() {
        super.create();
        this.validateInput();
    }

    private void handleBrowse() {
        try {
            if (this.buttonWorkspace.getSelection()) {
                this.browseWorkspace();
            } else if (this.buttonFileSystem.getSelection()) {
                this.browseLocalFileSystem();
            } else {
                this.buttonRemoteFileSystem.getSelection();
            }
            this.validateInput();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    private void validateInput() {
        this.updateStatus(null);
        if (StringUtils.isBlank((CharSequence)this.localNativePath)) {
            Status status = new Status(1, "com.ibm.zosconnect.ui", Xlat.description((String)"SPECIFY_DEST_FOLDER"));
            this.updateStatus((IStatus)status);
            return;
        }
        String fileName = XSwt.getText((Text)this.textFileName);
        if (StringUtils.isBlank((CharSequence)fileName) || !ResourcesPlugin.getWorkspace().validateName(fileName, 1).isOK()) {
            Status status = new Status(4, "com.ibm.zosconnect.ui", Xlat.error((String)"DEST_FILE_INVALID"));
            this.updateStatus((IStatus)status);
            return;
        }
        String errMsg = PosixPortableValidator.validate((String)XSwt.getText((Text)this.textFileName), (PosixPortableValidator.MessageInsertType)PosixPortableValidator.MessageInsertType.FILE);
        if (errMsg != null) {
            Status status = new Status(4, "com.ibm.zosconnect.ui", errMsg);
            this.updateStatus((IStatus)status);
            return;
        }
        Path path = new Path(this.getFilePath());
        if (path.toFile().exists() && !this.buttonOverwrite.getSelection()) {
            Status status = new Status(4, "com.ibm.zosconnect.ui", Xlat.error((String)"DEST_FILE_EXISTS"));
            this.updateStatus((IStatus)status);
            return;
        }
    }

    private static String sanitizeFileName(String fileName) {
        String returnValue = fileName.replaceAll("[\\/\\\\]", "-");
        return returnValue;
    }

    boolean isPathValid(String pathStr) {
        boolean retVal = false;
        Path path = new Path(pathStr);
        File folder = path.toFile();
        boolean folderWriteable = Files.isWritable(new File(pathStr).toPath());
        if (folder.exists() && folderWriteable) {
            retVal = true;
        }
        return retVal;
    }

    private void browseLocalFileSystem() {
        String pathName;
        DirectoryDialog dialog = new DirectoryDialog(this.buttonBrowse.getShell());
        dialog.setMessage(Xlat.label((String)"EXPRT_API_DLG_WS_DESCR"));
        try {
            String prevPath = this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_LOCAL_FILEPATH);
            if (prevPath != null && !prevPath.isEmpty() && this.isPathValid(prevPath)) {
                dialog.setFilterPath(prevPath);
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        if ((pathName = dialog.open()) != null && !pathName.isEmpty()) {
            this.textFolder.setText(pathName);
            this.localNativePath = pathName;
            this.workspaceFolder = null;
            try {
                this.controller.getProject().setPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_LOCAL_FILEPATH, this.localNativePath);
            }
            catch (CoreException e2) {
                ZCeeUILogger.error((Throwable)e2);
            }
        }
    }

    private void browseWorkspace() {
        IResource folder;
        WorkspaceFileSelectionDialog dialog = new WorkspaceFileSelectionDialog(this.getShell(), Xlat.label((String)"EXPRT_API_DLG_WS_TITLE"), Xlat.label((String)"EXPRT_API_DLG_WS_DESCR"), "sar", false);
        try {
            String prevPath = this.controller.getProject().getPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_FILEPATH);
            if (prevPath != null && !prevPath.isEmpty()) {
                dialog.setPrevPath(prevPath);
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        if (dialog.open() == 0 && (folder = dialog.getResult()) != null) {
            String pathName = folder.getFullPath().toString();
            this.localNativePath = folder.getLocation().toOSString();
            this.workspaceFolder = folder;
            this.textFolder.setText(pathName);
            try {
                this.controller.getProject().setPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_FILEPATH, pathName);
                this.controller.getProject().setPersistentProperty(ZCeeProjectConstants.PROP_API_EXPORT_WORKSPACE_OS_FILEPATH, this.localNativePath);
            }
            catch (CoreException e2) {
                ZCeeUILogger.error((Throwable)e2);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Xlat.label((String)"EXPRT_API_DLG_TITLE"));
    }

    private String getFilePath() {
        String fileName;
        StringBuffer path = new StringBuffer();
        if (!StringUtils.isBlank((CharSequence)this.localNativePath)) {
            path.append(this.localNativePath);
        }
        if (!StringUtils.isBlank((CharSequence)(fileName = XSwt.getTrimText((Text)this.textFileName)))) {
            path.append(File.separator);
            path.append(fileName);
            path.append(".aar");
        }
        return path.toString();
    }

    protected void okPressed() {
        try {
            String fileName = this.getFilePath();
            this.controller.setOutputFileName(fileName);
            boolean methodsRemoved = this.controller.createZipFile();
            if (this.workspaceFolder != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExportApiDialog.this.workspaceFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            ZCeeUILogger.error((Throwable)e);
                        }
                    }
                });
            }
            super.okPressed();
            if (methodsRemoved) {
                ApiEditorMessageDialog messageDialog = new ApiEditorMessageDialog(this.getShell(), false);
                messageDialog.openInfo(Xlat.description((String)"INFO_OMITTED_METHODS"));
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.textFileName) {
            this.validateInput();
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null) {
            XSwt.disable((Control[])new Control[]{this.okButton});
        } else {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }
}

