/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.ui.common.exceptions.ZosConnectUIException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.SWTResourceManager;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.connections.categories.IZCeeAdminApiConnection;
import com.ibm.zosconnect.ui.connections.models.adminapi.ZosConnectApiDetail;
import com.ibm.zosconnect.ui.model.ZosConnectDeployResult;
import com.ibm.zosconnect.ui.resources.ZCeeUIResourcePlugin;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DeployApiResultsDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite mainComposite;
    private Label labelServer;
    private Label labelTable1;
    private Table tableResults;
    private TableColumn table1Col1;
    private TableColumn table1Col2;
    private TableColumn table1Col3;
    private TableColumn table1Col4;
    private IZCeeAdminApiConnection connection;
    private Vector<ZosConnectDeployResult> deployResults;
    private boolean errorsExist;
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private static final int COMPOSITE_WIDTH = 500;
    private static final int NUM_ROWS_DISPLAYED = 7;

    public DeployApiResultsDialog(Vector<ZosConnectDeployResult> deployResults, Shell parentShell, IZCeeAdminApiConnection connection) {
        super(parentShell);
        this.deployResults = deployResults;
        this.connection = connection;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.formToolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.widthHint = 500;
        this.compContents.setLayoutData((Object)gridData);
        GridLayout gl_compContents = new GridLayout(1, false);
        gl_compContents.marginTop = 5;
        gl_compContents.marginLeft = 2;
        gl_compContents.marginRight = 2;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.labelServer = new Label(this.compContents, 0);
        this.labelServer.setText(Xlat.label((String)"DEPLOY_API_RESULT_SERVER") + Xlat.colon() + " " + this.connection.getName());
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelServer.setLayoutData((Object)gridData);
        this.labelTable1 = new Label(this.compContents, 0);
        this.labelTable1.setText(Xlat.label((String)"DEPLOY_API_RESULT_TABLE_TITLE") + Xlat.colon());
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelTable1.setLayoutData((Object)gridData);
        this.tableResults = new Table(this.compContents, 2560);
        this.tableResults.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                Object data;
                DeployApiResultsDialog.this.tableResults.setToolTipText("");
                Point point = new Point(event.x, event.y);
                TableItem item = XSwt.getTableItem((Table)DeployApiResultsDialog.this.tableResults, (Point)point);
                if (item != null && (data = item.getData(ZosConnectUIException.class.getName())) instanceof ZosConnectUIException) {
                    ZosConnectUIException exception = (ZosConnectUIException)((Object)data);
                    String errorMsg = StringUtils.trimToEmpty((String)exception.getExternalMessage());
                    String serverMsg = StringUtils.substringAfter((String)errorMsg, (String)"BAQ");
                    if (!StringUtils.isBlank((CharSequence)serverMsg)) {
                        DeployApiResultsDialog.this.tableResults.setToolTipText("BAQ" + serverMsg);
                    } else {
                        DeployApiResultsDialog.this.tableResults.setToolTipText(errorMsg);
                    }
                }
            }
        });
        this.table1Col1 = new TableColumn(this.tableResults, 0);
        this.table1Col1.setText(Xlat.label((String)"DEPLOY_API_TABLE_COL1"));
        this.table1Col2 = new TableColumn(this.tableResults, 0);
        this.table1Col2.setText(Xlat.label((String)"DEPLOY_API_TABLE_COL2"));
        this.table1Col3 = new TableColumn(this.tableResults, 0);
        this.table1Col3.setText(Xlat.label((String)"DEPLOY_API_TABLE_COL3"));
        this.table1Col4 = new TableColumn(this.tableResults, 0);
        this.table1Col4.setText(Xlat.label((String)"DEPLOY_API_RESULT_TABLE_COL4"));
        int newApiRowNum = this.deployResults.size();
        Iterator<ZosConnectDeployResult> it = this.deployResults.iterator();
        this.errorsExist = false;
        while (it.hasNext()) {
            String deployResultString = "";
            Image resultImage = null;
            ZosConnectDeployResult currResult = it.next();
            ZosConnectUIException uiException = currResult.getUiException();
            if (uiException == null) {
                ZosConnectApiDetail apiDetail = currResult.getApiDetail();
                if (HttpStatusCodes.Created.equals(apiDetail.getStatusCode())) {
                    deployResultString = Xlat.label((String)"DEPLOY_API_RESULT_CREATED");
                } else if (HttpStatusCodes.OK.equals(apiDetail.getStatusCode())) {
                    deployResultString = Xlat.label((String)"DEPLOY_API_RESULT_UPDATED");
                }
                resultImage = SWTResourceManager.getImage(ZCeeUIResourcePlugin.class, (String)"icons/OK_16.gif");
            } else {
                this.errorsExist = true;
                deployResultString = Xlat.label((String)"DEPLOY_API_RESULT_ERROR");
                resultImage = SWTResourceManager.getImage(ZCeeUIResourcePlugin.class, (String)"icons/error_16.gif");
            }
            TableItem tableItem = new TableItem(this.tableResults, 0);
            tableItem.setData(ZosConnectUIException.class.getName(), (Object)uiException);
            tableItem.setText(0, currResult.getApiTitle());
            tableItem.setText(1, currResult.getApiVersion());
            tableItem.setText(2, currResult.getApiBasePath());
            tableItem.setText(3, deployResultString);
            tableItem.setImage(3, resultImage);
        }
        if (this.errorsExist) {
            try {
                IWorkbenchPage page = XSwt.getActivePage();
                IViewPart viewPart = page.findView("org.eclipse.ui.views.ProblemView");
                if (viewPart == null || !page.isPartVisible((IWorkbenchPart)viewPart)) {
                    viewPart = page.showView("org.eclipse.ui.views.ProblemView", null, 2);
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
                ZCeeErrorDialog.openError((Exception)e);
            }
        }
        this.tableResults.setHeaderVisible(true);
        this.tableResults.setLinesVisible(true);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        if (newApiRowNum > 7) {
            int tableHeight;
            gridData.heightHint = tableHeight = this.tableResults.getItemHeight() * 7 + this.tableResults.getHeaderHeight();
        }
        this.tableResults.setLayoutData((Object)gridData);
        this.tableResults.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = DeployApiResultsDialog.this.compContents.getClientArea();
                int width = area.width - 2 - 2 - 2 * DeployApiResultsDialog.this.tableResults.getBorderWidth() - 10;
                TableColumn[] tableColumns = DeployApiResultsDialog.this.tableResults.getColumns();
                int i = 0;
                while (i < tableColumns.length) {
                    tableColumns[i].setWidth(width / tableColumns.length);
                    ++i;
                }
            }
        });
        this.tableResults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeployApiResultsDialog.this.tableResults.setSelection(new int[0]);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.apideploydialog");
        this.compContents.layout(true);
        return compDialogArea;
    }

    private void validateInput() {
        this.updateStatus(null);
        if (this.errorsExist) {
            Status status = new Status(4, "com.ibm.zosconnect.ui", Xlat.error((String)"DEPLOY_FAILURE"));
            this.updateStatus((IStatus)status);
        } else {
            Status status = new Status(1, "com.ibm.zosconnect.ui", Xlat.label((String)"DEPLOY_API_RESULT_SUCCESS"));
            this.updateStatus((IStatus)status);
        }
        XSwt.pack((Control)this.getShell());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Xlat.label((String)"DEPLOY_API_RESULT_TITLE"));
    }

    public void create() {
        super.create();
        this.validateInput();
        XSwt.centerInWorkbench((Shell)this.getShell());
    }
}

