/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.api.MethodValues;
import com.ibm.zosconnect.ui.common.util.SWTResourceManager;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.FormImageHyperlinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.editors.ApiEditorFormPage;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodsComposite;
import com.ibm.zosconnect.ui.resources.ZCeeUIResourcePlugin;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ApiEditorMethodDialog
extends Dialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected MethodValues result;
    protected Shell shell;
    private ApiEditorMethodsComposite parentApiMethods;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private ImageHyperlink imgPOST;
    private ImageHyperlink imgGET;
    private ImageHyperlink imgPUT;
    private ImageHyperlink imgDELETE;
    private ImageHyperlink imgPATCH;
    private ImageHyperlink imgHEAD;
    private ImageHyperlink imgClose;
    private ShellListener shellListener;

    public ApiEditorMethodDialog(Shell parent, ApiEditorMethodsComposite compApiMethods) {
        super(parent, 0);
        this.parentApiMethods = compApiMethods;
    }

    private ApiEditorMethodDialog(Shell parent, int style) {
        super(parent, style);
    }

    public MethodValues open() {
        this.createContents();
        Point pt = this.shell.getDisplay().getCursorLocation();
        this.shell.setLocation(pt.x, pt.y);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 65536);
        this.shell.setBackground(SWTResourceManager.getColor((int)1));
        this.shell.setSize(287, 371);
        this.shell.setText(this.getText());
        GridLayout gl_shell = new GridLayout(1, false);
        gl_shell.marginWidth = 0;
        gl_shell.verticalSpacing = 10;
        gl_shell.marginHeight = 0;
        gl_shell.marginTop = 10;
        gl_shell.marginBottom = 15;
        gl_shell.marginRight = 15;
        gl_shell.marginLeft = 15;
        gl_shell.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gl_shell);
        if (this.shellListener != null) {
            this.shell.addShellListener(this.shellListener);
        }
        this.imgClose = this.formToolkit.createImageHyperlink((Composite)this.shell, 0);
        this.imgClose.setToolTipText(Xlat.label((String)"APIDLG_BUTTON_CLOSE"));
        this.imgClose.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
            }
        });
        this.imgClose.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.imgClose.setImage(SWTResourceManager.getImage(ZCeeUIResourcePlugin.class, (String)"icons/remove_path_method_16x16.png"));
        if (!this.parentApiMethods.hasPOSTMethod()) {
            this.result = this.addPOSTMethod();
        }
        if (!this.parentApiMethods.hasGETMethod()) {
            this.result = this.addGETMethod();
        }
        if (!this.parentApiMethods.hasPUTMethod()) {
            this.result = this.addPUTMethod();
        }
        if (!this.parentApiMethods.hasDELETEMethod()) {
            this.result = this.addDELETEMethod();
        }
        if (!this.parentApiMethods.hasPATCHMethod()) {
            this.result = this.addPATCHMethod();
        }
        if (!this.parentApiMethods.hasHEADMethod()) {
            this.result = this.addHEADMethod();
        }
        this.shell.pack();
    }

    private MethodValues addPOSTMethod() {
        this.imgPOST = (ImageHyperlink)new FormImageHyperlinkBuilder(this.formToolkit).image(XImg.icon((String)"POST.png")).hoverImage(XImg.icon((String)"POST_hover.png")).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{MethodValues.POST.toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
                ApiEditorMethodDialog.this.parentApiMethods.addNewMethod(MethodValues.POST);
            }
        }).build((Composite)this.shell);
        return MethodValues.POST;
    }

    private MethodValues addGETMethod() {
        this.imgGET = (ImageHyperlink)new FormImageHyperlinkBuilder(this.formToolkit).image(XImg.icon((String)"GET.png")).hoverImage(XImg.icon((String)"GET_hover.png")).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{MethodValues.GET.toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
                ApiEditorMethodDialog.this.parentApiMethods.addNewMethod(MethodValues.GET);
            }
        }).build((Composite)this.shell);
        return MethodValues.GET;
    }

    private MethodValues addPUTMethod() {
        this.imgPUT = (ImageHyperlink)new FormImageHyperlinkBuilder(this.formToolkit).image(XImg.icon((String)"PUT.png")).hoverImage(XImg.icon((String)"PUT_hover.png")).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{MethodValues.PUT.toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
                ApiEditorMethodDialog.this.parentApiMethods.addNewMethod(MethodValues.PUT);
            }
        }).build((Composite)this.shell);
        return MethodValues.PUT;
    }

    private MethodValues addDELETEMethod() {
        this.imgDELETE = (ImageHyperlink)new FormImageHyperlinkBuilder(this.formToolkit).image(XImg.icon((String)"DELETE.png")).hoverImage(XImg.icon((String)"DELETE_hover.png")).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{MethodValues.DELETE.toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
                ApiEditorMethodDialog.this.parentApiMethods.addNewMethod(MethodValues.DELETE);
            }
        }).build((Composite)this.shell);
        return MethodValues.DELETE;
    }

    private MethodValues addPATCHMethod() {
        this.imgPATCH = (ImageHyperlink)new FormImageHyperlinkBuilder(this.formToolkit).image(XImg.icon((String)"PATCH.png")).hoverImage(XImg.icon((String)"PATCH_hover.png")).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{MethodValues.PATCH.toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
                ApiEditorMethodDialog.this.parentApiMethods.addNewMethod(MethodValues.PATCH);
            }
        }).build((Composite)this.shell);
        return MethodValues.PATCH;
    }

    private MethodValues addHEADMethod() {
        this.imgHEAD = (ImageHyperlink)new FormImageHyperlinkBuilder(this.formToolkit).image(XImg.icon((String)"HEAD.png")).hoverImage(XImg.icon((String)"HEAD_hover.png")).toolTipText(Xlat.description((String)"TOOLTIP_HTTP_METHOD", (String[])new String[]{MethodValues.HEAD.toString()})).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.getParent()){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                ApiEditorMethodDialog.this.shell.close();
                ApiEditorMethodDialog.this.parentApiMethods.addNewMethod(MethodValues.HEAD);
            }
        }).build((Composite)this.shell);
        return MethodValues.HEAD;
    }

    public void setShellListener(ShellListener shellListener) {
        this.shellListener = shellListener;
    }

    public ApiEditorFormPage getParentFormPage() {
        return this.parentApiMethods.getParentFormPage();
    }

    public ApiModelController getApiModelController() {
        return this.parentApiMethods.getApiModelController();
    }
}

