/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.ArrayUtilz;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ApiEditorMessageDialog
extends Dialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private String message;
    private MessageType messageType;
    private String[] warningItems;
    private Label imgMessageIcon;
    private Composite compMessage;
    private Label txtMessage;
    private boolean atCursor = false;

    public ApiEditorMessageDialog(Shell parentShell, boolean atCursor) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() & 0x10000000);
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.atCursor = atCursor;
    }

    public void openInfo(String message) {
        this.messageType = MessageType.INFO;
        this.message = message;
        this.open();
    }

    public boolean openConfirm(String message) {
        this.messageType = MessageType.CONFIRM;
        this.message = message;
        return this.open() == 0;
    }

    public boolean openWarning(String message, String[] warningItems) {
        this.messageType = MessageType.WARN;
        this.message = message;
        this.warningItems = warningItems;
        return this.open() == 0;
    }

    public boolean openWarning(String message) {
        this.messageType = MessageType.WARN;
        this.message = message;
        this.warningItems = new String[0];
        return this.open() == 0;
    }

    public void openError(String message) {
        this.messageType = MessageType.ERROR;
        this.message = message;
        this.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite retVal = null;
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        try {
            switch (this.messageType) {
                case INFO: {
                    retVal = this.createInfoContents(parent);
                    break;
                }
                case CONFIRM: {
                    retVal = this.createConfirmContents(parent);
                    break;
                }
                case WARN: {
                    retVal = this.createWarningContents(parent);
                    break;
                }
                case ERROR: {
                    retVal = this.createErrorContents(parent);
                    break;
                }
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.messageType == MessageType.CONFIRM || this.messageType == MessageType.WARN) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        Point retVal = super.getInitialLocation(initialSize);
        if (this.atCursor) {
            retVal = this.getShell().getDisplay().getCursorLocation();
        }
        return retVal;
    }

    private Composite createInfoContents(Composite parent) {
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        Composite compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        compContents.setLayout((Layout)gl_compContents);
        compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compMessage = new Composite(compContents, 0);
        GridLayout gl_messageArea = new GridLayout(2, false);
        gl_messageArea.horizontalSpacing = 15;
        this.compMessage.setLayout((Layout)gl_messageArea);
        this.compMessage.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.imgMessageIcon = this.formToolkit.createLabel(this.compMessage, "", 0);
        this.imgMessageIcon.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.imgMessageIcon.setImage(this.getShell().getDisplay().getSystemImage(2));
        this.txtMessage = this.formToolkit.createLabel(this.compMessage, "", 352);
        GridData gd_txtMessage = new GridData(4, 128, true, true, 1, 1);
        gd_txtMessage.widthHint = 250;
        this.txtMessage.setLayoutData((Object)gd_txtMessage);
        this.txtMessage.setText(this.message);
        return compDialogArea;
    }

    private Composite createConfirmContents(Composite parent) {
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        Composite compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        compContents.setLayout((Layout)gl_compContents);
        compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compMessage = new Composite(compContents, 0);
        GridLayout gl_messageArea = new GridLayout(2, false);
        gl_messageArea.horizontalSpacing = 15;
        this.compMessage.setLayout((Layout)gl_messageArea);
        this.compMessage.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.imgMessageIcon = this.formToolkit.createLabel(this.compMessage, "", 0);
        this.imgMessageIcon.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.imgMessageIcon.setImage(this.getShell().getDisplay().getSystemImage(4));
        this.txtMessage = this.formToolkit.createLabel(this.compMessage, "", 352);
        GridData gd_txtMessage = new GridData(4, 128, true, true, 1, 1);
        gd_txtMessage.widthHint = 250;
        this.txtMessage.setLayoutData((Object)gd_txtMessage);
        this.txtMessage.setText(this.message);
        return compDialogArea;
    }

    private Composite createWarningContents(Composite parent) {
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        Composite compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        compContents.setLayout((Layout)gl_compContents);
        compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compMessage = new Composite(compContents, 0);
        GridLayout gl_messageArea = new GridLayout(2, false);
        gl_messageArea.horizontalSpacing = 15;
        this.compMessage.setLayout((Layout)gl_messageArea);
        this.compMessage.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.imgMessageIcon = this.formToolkit.createLabel(this.compMessage, "", 0);
        this.imgMessageIcon.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.imgMessageIcon.setImage(this.getShell().getDisplay().getSystemImage(8));
        this.txtMessage = this.formToolkit.createLabel(this.compMessage, "", 352);
        GridData gd_txtMessage = new GridData(4, 128, true, true, 1, 1);
        gd_txtMessage.widthHint = 250;
        this.txtMessage.setLayoutData((Object)gd_txtMessage);
        this.txtMessage.setText(this.message);
        if (ArrayUtilz.notEmpty((Object[])this.warningItems)) {
            List listServices = new List(this.compMessage, 2816);
            GridData gd_compResourceBrowser = new GridData(4, 4, true, false, 2, 1);
            gd_compResourceBrowser.verticalIndent = 10;
            gd_compResourceBrowser.heightHint = 100;
            listServices.setLayoutData((Object)gd_compResourceBrowser);
            listServices.setItems(this.warningItems);
            listServices.setEnabled(false);
        }
        return compDialogArea;
    }

    private Composite createErrorContents(Composite parent) {
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        Composite compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(3, false);
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        compContents.setLayout((Layout)gl_compContents);
        compContents.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compMessage = new Composite(compDialogArea, 0);
        GridLayout gl_messageArea = new GridLayout(2, false);
        gl_messageArea.horizontalSpacing = 15;
        this.compMessage.setLayout((Layout)gl_messageArea);
        this.compMessage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.adapt(this.compMessage);
        this.formToolkit.paintBordersFor(this.compMessage);
        this.imgMessageIcon = this.formToolkit.createLabel(this.compMessage, "", 0);
        this.imgMessageIcon.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.imgMessageIcon.setImage(this.getShell().getDisplay().getSystemImage(1));
        this.txtMessage = this.formToolkit.createLabel(this.compMessage, "", 352);
        GridData gd_txtMessage = new GridData(4, 128, true, true, 1, 1);
        gd_txtMessage.widthHint = 250;
        this.txtMessage.setLayoutData((Object)gd_txtMessage);
        this.txtMessage.setText(this.message);
        return compDialogArea;
    }

    private static enum MessageType {
        INFO,
        CONFIRM,
        WARN,
        ERROR;

    }
}

