/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.dialogs;

import com.ibm.zosconnect.api.rules.BooleanExpression;
import com.ibm.zosconnect.api.rules.BooleanOperator;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.NumberUtilz;
import com.ibm.zosconnect.ui.common.util.StringUtilz;
import com.ibm.zosconnect.ui.common.util.XImg;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.http.HttpStatusCodes;
import com.ibm.zosconnect.ui.common.util.swt.ComboBuilder;
import com.ibm.zosconnect.ui.common.util.swt.CompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.LabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.ModifyListener2;
import com.ibm.zosconnect.ui.common.util.swt.MouseAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.MouseTrackAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.ScrolledCompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.SelectionAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.TextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.controllers.api.ServiceMappingController;
import com.ibm.zosconnect.ui.dialogs.ResponseCodeRuleComposite;
import com.ibm.zosconnect.ui.dialogs.ResponseCodeRulesComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponseComposite;
import com.ibm.zosconnect.ui.editors.ApiEditorMethodResponsesComposite;
import com.ibm.zosconnect.ui.editors.listeners.AddOrEditDialogListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddOrEditResponseDialog
extends StatusDialog {
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private FormToolkit toolkit;
    private ApiEditorMethodResponsesComposite logicalParent;
    private ApiEditorMethodResponseComposite responseComposite;
    private ServiceMappingController serviceMappingController;
    private String title;
    private Composite mainComposite;
    private Composite dialogArea;
    private ResponseCodeRulesComposite cmpResponseCodeRules;
    private Button btnOK;
    private Button btnImport;
    private Combo cmbStatusCode;
    private Text txtDescription;
    private Composite cmpAddRules;
    private ScrolledComposite cmpRulesSection;
    private Composite cmpRulesSummary;
    private Label lblAddRule;
    private Text txtRulesSummary;
    private String cmbStatusCodeVal;
    private String txtDescriptionVal;
    private ControlDecoration cmbStatusCodeDecoration;
    private List<Integer> definedResponseCodes;
    private List<AddOrEditDialogListener> listeners;
    private boolean isEditResponse;
    private BooleanExpression expression;
    private boolean isDefaultResponse;
    private boolean isDirty = false;
    private PaintListener workbenchPaintListener;
    private Point screenSize;

    public AddOrEditResponseDialog(Shell shell, ApiEditorMethodResponsesComposite logicalParent, ApiEditorMethodResponseComposite responseComposite, String title, FormToolkit toolkit) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.logicalParent = logicalParent;
        this.responseComposite = responseComposite;
        this.title = title;
        this.toolkit = toolkit;
        this.serviceMappingController = logicalParent.getLogicalParent().getServiceMappingController();
        this.listeners = new ArrayList<AddOrEditDialogListener>();
        this.definedResponseCodes = logicalParent.getDefinedResponseCodes();
        if (responseComposite != null) {
            this.isEditResponse = true;
            this.isDefaultResponse = logicalParent.isDefaultResponseCode(responseComposite.getResponseCode());
        }
    }

    public AddOrEditResponseDialog(Shell controlParent, ApiEditorMethodResponsesComposite logicalParent, String title, FormToolkit toolkit) {
        this(controlParent, logicalParent, null, title, toolkit);
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = null;
        try {
            dialogArea = this.createDialogAreaInternal(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        return dialogArea;
    }

    private Control createDialogAreaInternal(Composite parent) throws Exception {
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.toolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        this.dialogArea = (Composite)new CompositeBuilder().background(this.toolkit.getColors().getBackground()).numColumns(2).build(this.mainComposite);
        int fontHeight = XSwt.getFontHeight((Control)this.dialogArea);
        Composite cmpStatusCode = (Composite)new CompositeBuilder().numColumns(2).build(this.dialogArea);
        new LabelBuilder().text(Xlat.labelWithColon((String)"APIDLG_LABEL_RESPONSE_CODE")).verticalAlignment(0x1000000).build(cmpStatusCode);
        ArrayList<String> cmbStatusCodeItems = new ArrayList<String>();
        if (this.isEditResponse) {
            for (HttpStatusCodes statusCode : this.getAdvertisedStatusCodes()) {
                if (this.responseComposite.getResponseCode().equals(statusCode.getCode())) {
                    cmbStatusCodeItems.add(statusCode.toDetail());
                    continue;
                }
                if (this.definedResponseCodes.contains(statusCode.getCode())) continue;
                cmbStatusCodeItems.add(statusCode.toDetail());
            }
        } else {
            for (HttpStatusCodes statusCode : this.getAdvertisedStatusCodes()) {
                if (this.definedResponseCodes.contains(statusCode.getCode())) continue;
                cmbStatusCodeItems.add(statusCode.toDetail());
            }
        }
        if (this.isEditResponse) {
            statusCode = HttpStatusCodes.fromCode((Integer)this.responseComposite.getResponseCode());
            this.cmbStatusCodeVal = statusCode != null ? statusCode.toDetail() : this.responseComposite.getResponseCodeAsString();
            this.txtDescriptionVal = this.responseComposite.getDescription();
        } else {
            statusCode = HttpStatusCodes.fromDetail((String)((String)cmbStatusCodeItems.get(0)));
            if (statusCode != null) {
                this.cmbStatusCodeVal = statusCode.toDetail();
                this.txtDescriptionVal = statusCode.getDescription();
            }
        }
        this.cmbStatusCode = (Combo)new ComboBuilder().items(cmbStatusCodeItems).text(this.cmbStatusCodeVal).listener((SelectionListener)new SelectionAdapter2((Control)cmpStatusCode){

            public void widgetSelected(SelectionEvent event, Control owner) throws Exception {
                AddOrEditResponseDialog.this.handleModifyResponseCode();
            }
        }).listener((VerifyListener)new VerifyListener2((Control)cmpStatusCode){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)cmpStatusCode){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                AddOrEditResponseDialog.this.handleModifyResponseCode();
            }
        }).style(Integer.valueOf(2048)).horizontalAlignment(16384).horizontalIndent(5).build(cmpStatusCode);
        this.cmbStatusCodeDecoration = new ControlDecoration((Control)this.cmbStatusCode, 17408);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.cmbStatusCode, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new StatusCodeProposalProvider(), null, null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setPropagateKeys(true);
        Composite cmpDescription = (Composite)new CompositeBuilder().numColumns(2).grabExcessHorizontalSpace(true).build(this.dialogArea);
        new LabelBuilder().text(Xlat.labelWithColon((String)"APIEDIT_LABEL_DESCRIPTION")).verticalAlignment(128).horizontalAlignment(131072).build(cmpDescription);
        this.txtDescription = (Text)new TextBuilder().text(this.txtDescriptionVal).listener((VerifyListener)new VerifyListener2((Control)cmpDescription){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        }).listener((ModifyListener)new ModifyListener2((Control)cmpDescription){

            public void modifyText(ModifyEvent event, Control owner) throws Exception {
                AddOrEditResponseDialog.this.txtDescriptionVal = XSwt.getTrimText((Text)AddOrEditResponseDialog.this.txtDescription);
                AddOrEditResponseDialog.this.setDirty(true);
                AddOrEditResponseDialog.this.validate();
            }
        }).style(Integer.valueOf(2626)).grabExcessHorizontalSpace(true).horizontalIndent(5).widthHint(43 * XSwt.getAverageCharWidth((Control)this.dialogArea)).heightHint(fontHeight * 3).build(cmpDescription);
        Composite cmpSepLine = (Composite)new CompositeBuilder().horizontalSpan(2).verticalIndent(10).build(this.dialogArea);
        new LabelBuilder().style(Integer.valueOf(258)).grabExcessHorizontalSpace(true).build(cmpSepLine);
        Composite cmpResponseDesc = (Composite)new CompositeBuilder().numColumns(2).horizontalSpan(2).build(this.dialogArea);
        if (!this.isDefaultResponse) {
            new LabelBuilder().text(Xlat.description((String)"APIDLG_RESPONSECODE_RULES_DESC")).horizontalSpan(2).build(cmpResponseDesc);
            this.cmpRulesSection = (ScrolledComposite)new ScrolledCompositeBuilder().horizontalSpan(2).verticalIndent(5).style(Integer.valueOf(512)).build(this.dialogArea);
            this.cmpResponseCodeRules = new ResponseCodeRulesComposite((Composite)this.cmpRulesSection, this, this.serviceMappingController, this.isEditResponse);
            this.cmpRulesSection.setContent((Control)this.cmpResponseCodeRules);
            this.cmpRulesSection.setAlwaysShowScrollBars(true);
            this.cmpRulesSection.setShowFocusedControl(true);
            this.createAddRulesButton();
            this.cmpRulesSummary = (Composite)new CompositeBuilder().horizontalSpan(2).build(this.dialogArea);
            new LabelBuilder().text(Xlat.label((String)"APIDLG_RULES_SUMMARY")).build(this.cmpRulesSummary);
            this.createSummaryText();
        } else {
            new LabelBuilder().text(Xlat.description((String)"APIDLG_RESPONSECODE_RULES_DESC_DFLT")).horizontalSpan(2).build(cmpResponseDesc);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.dialogArea, "com.ibm.zosconnect.ui.definingmultipleresponsecodes");
        return this.dialogArea;
    }

    private void createSummaryText() {
        int fontHeight = XSwt.getFontHeight((Control)this.dialogArea);
        this.txtRulesSummary = (Text)new TextBuilder().style(Integer.valueOf(2626)).background(XSwt.getColor((RGB)XSwt.RGB_LIGHT_GRAY)).grabExcessHorizontalSpace(true).heightHint(fontHeight * 3).build(this.cmpRulesSummary);
    }

    private void createAddRulesButton() {
        this.cmpAddRules = (Composite)new CompositeBuilder().numColumns(2).marginLeft(MaxFieldDecorationWidth).build(this.dialogArea);
        this.lblAddRule = (Label)new LabelBuilder().toolTipText(Xlat.description((String)"TOOLTIP_ADD_RULE")).image(XImg.icon((String)"icon-add@x1.png")).listener((MouseListener)new MouseAdapter2((Control)this.cmpRulesSection){

            public void mouseUp(MouseEvent event) {
                ResponseCodeRuleComposite newRule = AddOrEditResponseDialog.this.cmpResponseCodeRules.addNewRule();
                newRule.setFocus();
            }
        }).listener((MouseTrackAdapter)new MouseTrackAdapter2((Control)this.cmpRulesSection){
            final Image normal;
            final Image linked;
            Image currImage;
            {
                this.normal = XImg.icon((String)"icon-add@x1.png");
                this.linked = XImg.icon((String)"icon-add-hover@x1.png");
                this.currImage = null;
            }

            public void mouseEnter(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.linked) {
                    XSwt.setImage((Label)AddOrEditResponseDialog.this.lblAddRule, (Image)this.linked);
                    this.currImage = this.linked;
                }
            }

            public void mouseExit(MouseEvent event, Control owner) throws Exception {
                if (this.currImage != this.normal) {
                    XSwt.setImage((Label)AddOrEditResponseDialog.this.lblAddRule, (Image)this.normal);
                    this.currImage = this.normal;
                }
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build(this.cmpAddRules);
        new LabelBuilder().text(Xlat.label((String)"APIDLG_LABEL_ADD_RULE")).horizontalAlignment(16384).verticalAlignment(0x1000000).build(this.cmpAddRules);
    }

    private void handleModifyResponseCode() {
        String description = XSwt.getText((Text)this.txtDescription);
        HttpStatusCodes oldStatusCode = HttpStatusCodes.fromDescription((String)description);
        this.cmbStatusCodeVal = XSwt.getTrimText((Combo)this.cmbStatusCode);
        HttpStatusCodes newStatusCode = this.getHttpStatusCode();
        if (oldStatusCode != null && newStatusCode != null) {
            XSwt.setText((Text)this.txtDescription, (String)newStatusCode.getDescription());
        }
        this.setDirty(true);
        this.validate();
    }

    protected IStatus validate() {
        String errorMsg;
        XSwt.hideFieldDecoration((ControlDecoration)this.cmbStatusCodeDecoration);
        IStatus status = Status.OK_STATUS;
        Integer newResponseCode = StringUtilz.getFirstInteger((String)this.cmbStatusCodeVal);
        if (newResponseCode == null || !NumberUtilz.isInRange((int)newResponseCode, (int)100, (int)599)) {
            errorMsg = Xlat.error((String)"RESPONSE_CODE_INVALID");
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cmbStatusCodeDecoration, (String)errorMsg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", errorMsg);
            }
        }
        if (!this.isEditResponse && newResponseCode != null && this.definedResponseCodes.contains(newResponseCode)) {
            errorMsg = Xlat.error((String)"RESPONSE_CODE_EXISTS", (Object[])new Object[]{newResponseCode});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cmbStatusCodeDecoration, (String)errorMsg);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", errorMsg);
            }
        }
        if (this.isEditResponse && newResponseCode != null && this.definedResponseCodes.contains(newResponseCode) && this.responseComposite != null && !newResponseCode.equals(this.responseComposite.getResponseCode())) {
            Integer oldResponseCode = this.responseComposite.getResponseCode();
            String errorMsg2 = Xlat.error((String)"RESPONSE_CODE_EXISTS", (Object[])new Object[]{newResponseCode});
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cmbStatusCodeDecoration, (String)errorMsg2);
            if (status == Status.OK_STATUS) {
                status = new Status(4, "com.ibm.zosconnect.ui", errorMsg2);
            }
        }
        for (AddOrEditDialogListener listener : this.listeners) {
            IStatus newStatus = listener.doValidate();
            if (status != Status.OK_STATUS || newStatus == Status.OK_STATUS) continue;
            status = newStatus;
        }
        if (!this.isDefaultResponse) {
            if (status == Status.OK_STATUS) {
                XSwt.setText((Text)this.txtRulesSummary, (String)this.getRulesSummaryString());
            } else {
                XSwt.setText((Text)this.txtRulesSummary, (String)"");
            }
        }
        this.updateStatus(status);
        return status;
    }

    private String getRulesSummaryString() {
        Object summary = "";
        List<ResponseCodeRuleComposite> ruleComposites = this.cmpResponseCodeRules.getRuleComposites();
        if (ruleComposites.size() == 1) {
            summary = ruleComposites.get(0).getRuleName();
        } else if (ruleComposites.size() == 2) {
            summary = ruleComposites.get(0).getRuleName() + " " + ruleComposites.get(0).getAndORString() + " " + ruleComposites.get(1).getRuleName();
        } else {
            boolean currInAndState = false;
            boolean nextIsAndState = false;
            boolean onlyAnds = true;
            for (ResponseCodeRuleComposite currRule : ruleComposites) {
                BooleanOperator andOrOp = ResponseCodeRulesComposite.getAndOrEnum(currRule.getAndORString());
                if (andOrOp == null) break;
                if (andOrOp == BooleanOperator.AND) {
                    nextIsAndState = true;
                } else {
                    onlyAnds = false;
                    nextIsAndState = false;
                }
                if (!currInAndState && nextIsAndState) {
                    summary = (String)summary + "(";
                }
                summary = (String)summary + currRule.getRuleName();
                if (nextIsAndState) {
                    summary = (String)summary + " AND ";
                    currInAndState = true;
                    continue;
                }
                if (currInAndState) {
                    summary = (String)summary + ")";
                }
                summary = (String)summary + " OR ";
                currInAndState = false;
            }
            summary = (String)summary + ruleComposites.get(ruleComposites.size() - 1).getRuleName();
            if (currInAndState) {
                summary = (String)summary + ")";
            }
            if (onlyAnds) {
                summary = ((String)summary).substring(1, ((String)summary).length() - 1);
            }
        }
        return summary;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public void create() {
        super.create();
        XSwt.layout((Composite)this.cmpResponseCodeRules, (boolean)true);
        if (!this.isDefaultResponse) {
            XSwt.layout((Composite)this.cmpRulesSection, (boolean)true);
        }
        XSwt.layout((Composite)this.dialogArea, (boolean)true);
        if (!this.isDefaultResponse) {
            this.updateRulesSectionDimensions();
        }
        this.packShell();
        XSwt.centerInWorkbench((Shell)this.getShell());
        if (!this.isDefaultResponse) {
            this.registerWorkbenchPaintListener();
        }
        this.validate();
    }

    public void updateRulesSectionDimensions() {
        this.screenSize = XSwt.getSmallestScreenSize();
        this.screenSize.y = (int)((double)this.screenSize.y * 0.8);
        Point useScreenSize = new Point(this.screenSize.x, this.screenSize.y);
        GridDataBuilder.setHeightHint((Control)this.cmpRulesSection, (int)-1);
        Point cmpRulesSize = this.cmpResponseCodeRules.computeSize(-1, -1);
        Point dialogAreaSize = this.dialogArea.computeSize(-1, -1);
        Point shellSize = this.getShell().computeSize(-1, -1);
        int totalRuleCount = this.cmpResponseCodeRules.getTotalRules();
        int heightOfOneRule = cmpRulesSize.y / totalRuleCount;
        int heightOfNonRuleContent = shellSize.y - cmpRulesSize.y;
        int availHeightForRules = useScreenSize.y - heightOfNonRuleContent;
        int maxPageRuleCount = availHeightForRules / heightOfOneRule;
        int usePageRuleCount = Math.max(1, Math.min(maxPageRuleCount, totalRuleCount));
        int rulesSectionHeight = heightOfOneRule * usePageRuleCount;
        GridDataBuilder.setHeightHint((Control)this.cmpRulesSection, (int)rulesSectionHeight);
        GridDataBuilder.setWidthHint((Control)this.txtRulesSummary, (int)cmpRulesSize.x);
    }

    private void registerWorkbenchPaintListener() {
        this.workbenchPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point newScreenSize = XSwt.getSmallestScreenSize();
                if (newScreenSize.x != AddOrEditResponseDialog.this.screenSize.x || newScreenSize.y != AddOrEditResponseDialog.this.screenSize.y) {
                    AddOrEditResponseDialog.this.updateRulesSectionDimensions();
                    AddOrEditResponseDialog.this.packShell();
                }
            }
        };
        XSwt.getWorkbenchShell().addPaintListener(this.workbenchPaintListener);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XSwt.getWorkbenchShell().removePaintListener(AddOrEditResponseDialog.this.workbenchPaintListener);
            }
        });
    }

    public void focusRule(ResponseCodeRuleComposite cmpRule) {
        if (!XSwt.isAnyDisposed((Control[])new Control[]{this.cmpRulesSection, cmpRule})) {
            this.cmpRulesSection.showControl((Control)cmpRule);
            XSwt.focus((Control)cmpRule);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (!XSwt.isOK((IStatus)status) || !this.isDirty()) {
            XSwt.disable((Control[])new Control[]{this.btnOK});
        } else {
            XSwt.enable((Control[])new Control[]{this.btnOK});
        }
    }

    public Integer getResponseCode() {
        return StringUtilz.getFirstInteger((String)this.cmbStatusCodeVal);
    }

    public String getDescription() {
        return this.txtDescriptionVal;
    }

    public HttpStatusCodes getHttpStatusCode() {
        return HttpStatusCodes.fromCode((Integer)this.getResponseCode());
    }

    protected void packShell() {
        this.getShell().pack();
    }

    public List<HttpStatusCodes> getAdvertisedStatusCodes() {
        return HttpStatusCodes.getByClass((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public BooleanExpression getExpression() {
        return this.expression;
    }

    protected void okPressed() {
        if (!this.isDefaultResponse) {
            this.expression = this.cmpResponseCodeRules.createBooleanExpressionFromRules();
        } else if (this.isEditResponse) {
            this.expression = this.responseComposite.getBooleanExpression();
        }
        super.okPressed();
    }

    public List<AddOrEditDialogListener> getListeners() {
        return this.listeners;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    private class StatusCodeProposalProvider
    implements IContentProposalProvider {
        private StatusCodeProposalProvider() {
        }

        public IContentProposal[] getProposals(String text, int textLen) {
            text = StringUtils.trimToEmpty((String)text);
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            if (StringUtils.isEmpty((CharSequence)text)) {
                String[] stringArray = AddOrEditResponseDialog.this.cmbStatusCode.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    proposals.add(new ContentProposal(item));
                    ++n2;
                }
            } else {
                String item;
                ArrayList<String> proposedItems = new ArrayList<String>();
                String[] stringArray = AddOrEditResponseDialog.this.cmbStatusCode.getItems();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    item = stringArray[n3];
                    if (StringUtils.startsWithIgnoreCase((CharSequence)item, (CharSequence)text)) {
                        proposals.add(new ContentProposal(item));
                        proposedItems.add(item);
                    }
                    ++n3;
                }
                stringArray = AddOrEditResponseDialog.this.cmbStatusCode.getItems();
                n = stringArray.length;
                n3 = 0;
                while (n3 < n) {
                    item = stringArray[n3];
                    if (!proposedItems.contains(item) && StringUtils.containsIgnoreCase((CharSequence)item, (CharSequence)text)) {
                        proposals.add(new ContentProposal(item));
                    }
                    ++n3;
                }
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
    }
}

