/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.builder;

import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.validation.ApiProjectValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ApiProjectBuilderModel {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IProject project;
    private ApiProjectController apiProjectController;
    private IFile packageXmlFile;
    private ApiModelController apiModelController;
    private ApiProjectValidator apiProjectValidator;

    public ApiProjectBuilderModel(IProject project) throws Exception {
        this.project = project;
        this.initialize();
    }

    public void initialize() throws Exception {
        this.apiProjectController = new ApiProjectController(this.project);
        this.packageXmlFile = this.project.getFile("package.xml");
        this.apiModelController = new ApiModelController(this.packageXmlFile, this.apiProjectController);
        this.apiProjectController.setApiModelController(this.apiModelController);
        this.apiProjectValidator = new ApiProjectValidator(this.project, this.apiProjectController);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ApiProjectController getApiProjectController() {
        return this.apiProjectController;
    }

    public void setApiProjectController(ApiProjectController apiProjectController) {
        this.apiProjectController = apiProjectController;
    }

    public IFile getPackageXmlFile() {
        return this.packageXmlFile;
    }

    public void setPackageXmlFile(IFile packageXmlFile) {
        this.packageXmlFile = packageXmlFile;
    }

    public ApiModelController getApiModelController() {
        return this.apiModelController;
    }

    public void setApiModelController(ApiModelController apiModelController) {
        this.apiModelController = apiModelController;
    }

    public ApiProjectValidator getApiProjectValidator() {
        return this.apiProjectValidator;
    }

    public void setApiProjectValidator(ApiProjectValidator apiProjectValidator) {
        this.apiProjectValidator = apiProjectValidator;
    }
}

