/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.builder;

import com.ibm.zosconnect.ui.builder.ApiProjectBuilderModel;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.validation.ApiProjectValidationError;
import com.ibm.zosconnect.ui.common.validation.ValidationUtil;
import com.ibm.zosconnect.ui.controllers.api.ApiModelController;
import com.ibm.zosconnect.ui.controllers.api.ApiProjectController;
import com.ibm.zosconnect.ui.controllers.validation.ApiDuplicatePathsValidator;
import com.ibm.zosconnect.ui.controllers.validation.ApiResponseValidator;
import com.ibm.zosconnect.ui.validation.ApiProjectValidator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ApiProjectBuilder
extends IncrementalProjectBuilder {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = ((Object)((Object)this)).getClass().getName();
    public static final String PROJECT_MARKER = "com.ibm.zosconnect.ui.projectproblem";
    public static final String CAPABILITIES_MARKER = "com.ibm.zosconnect.ui.capabilitiesproblem";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        String methodName = "build";
        ZCeeUILogger.entering((String)this.className, (String)"build", (Object[])new Object[]{kind, args});
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.zosconnect.ui", e.getMessage(), (Throwable)e));
        }
        ZCeeUILogger.exiting((String)this.className, (String)"build", (Object[])new Object[]{kind, args});
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws Exception {
        this.fullBuild(monitor);
    }

    private void fullBuild(IProgressMonitor monitor) throws Exception {
        String methodName = "fullBuild";
        ZCeeUILogger.entering((String)this.className, (String)"fullBuild", (Object[])new Object[0]);
        IProject project = this.getProject();
        ApiProjectBuilderModel model = new ApiProjectBuilderModel(project);
        this.validateProject(model);
        project.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        ZCeeUILogger.exiting((String)this.className, (String)"fullBuild", (Object[])new Object[0]);
    }

    private void validateProject(ApiProjectBuilderModel model) throws Exception {
        String methodName = "validateProject";
        ZCeeUILogger.entering((String)this.className, (String)"validateProject", (Object[])new Object[]{model.getProject()});
        model.getProject().deleteMarkers(CAPABILITIES_MARKER, true, 2);
        this.validateCapabilities(model);
        this.validateDuplicatePaths(model);
        this.validateApiResponses(model);
        ZCeeUILogger.exiting((String)this.className, (String)"validateProject", (Object[])new Object[]{model.getProject()});
    }

    private void validateDuplicatePaths(ApiProjectBuilderModel model) throws Exception {
        String methodName = "validateDuplicatePaths";
        ZCeeUILogger.entering((String)this.className, (String)"validateDuplicatePaths", (Object[])new Object[0]);
        ApiDuplicatePathsValidator.validateAndCreateMarkers((String)model.getProject().getName(), (ApiModelController)model.getApiModelController(), (IFile)model.getPackageXmlFile());
        ZCeeUILogger.exiting((String)this.className, (String)"validateDuplicatePaths", (Object[])new Object[0]);
    }

    private void validateCapabilities(ApiProjectBuilderModel model) throws Exception {
        String methodName = "validateCapabilities";
        ZCeeUILogger.entering((String)this.className, (String)"validateCapabilities", (Object[])new Object[0]);
        ApiProjectValidator apiProjectValidator = model.getApiProjectValidator();
        List<ApiProjectValidationError> errors = apiProjectValidator.validateCapabilitiesFile();
        if (errors.isEmpty()) {
            apiProjectValidator.updateProjectCapabilities();
        } else {
            this.addMarkersFor(errors);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateCapabilities", (Object[])new Object[0]);
    }

    private void validateApiResponses(ApiProjectBuilderModel model) throws Exception {
        String methodName = "validateApiResponses";
        ZCeeUILogger.entering((String)this.className, (String)"validateApiResponses", (Object[])new Object[0]);
        ApiResponseValidator.validateAndCreateMarkers((ApiProjectController)model.getApiProjectController(), (IFile)model.getPackageXmlFile());
        ZCeeUILogger.exiting((String)this.className, (String)"validateApiResponses", (Object[])new Object[0]);
    }

    private void addMarkersFor(List<ApiProjectValidationError> errors) {
        String methodName = "addMarkersFor";
        ZCeeUILogger.entering((String)this.className, (String)"addMarkersFor", (Object[])new Object[0]);
        for (ApiProjectValidationError error : errors) {
            try {
                ValidationUtil.createMarker((String)error.getMarkerType(), (IResource)error.getResource(), (String)error.getBareMessage(), (Integer)error.getLineNumber(), (Integer)error.getColumnNumber(), (int)error.getSeverity());
            }
            catch (CoreException e) {
                ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"addMarkersFor", (Object[])new Object[0]);
    }
}

